/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.integration.deployer.jndi;

import javax.enterprise.inject.spi.BeanManager;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.Reference;
import org.jboss.logging.Logger;

public abstract class JavaCompJndiBinder {
    protected Logger log = Logger.getLogger(this.getClass());
    private String deploymentUnitName;

    public JavaCompJndiBinder(String deploymentUnitName) {
        this.deploymentUnitName = deploymentUnitName;
    }

    public void bindToJavaComp() {
        try {
            Context compContext = this.getJavaCompContext();
            Context beanManagerContext = null;
            try {
                beanManagerContext = (Context)compContext.lookup("BeanManager");
            }
            catch (NamingException namingException) {
                // empty catch block
            }
            if (beanManagerContext == null) {
                compContext.bind("BeanManager", (Object)new Reference(BeanManager.class.getName(), "org.jboss.weld.resources.ManagerObjectFactory", null));
            }
        }
        catch (NamingException e) {
            this.log.error((Object)("Could not bound BeanManager on " + this.getJavaContextDescription()));
        }
    }

    protected abstract Context getJavaCompContext() throws NamingException;

    protected abstract String getJavaContextDescription();

    public void unbind() {
        try {
            this.getJavaCompContext().unbind("BeanManager");
        }
        catch (NamingException e) {
            this.log.error((Object)("Cound not unbind java:comp/BeanManager for " + this.deploymentUnitName));
        }
    }
}

