/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.deployers.test;

import java.lang.reflect.Method;
import java.util.Set;
import org.jboss.classloader.plugins.jdk.AbstractJDKChecker;
import org.jboss.deployers.vfs.deployer.kernel.BeanMetaDataFactoryVisitor;
import org.jboss.test.deployers.BootstrapDeployersTest;
import org.jboss.test.deployers.support.crm.CrmWebBean;
import org.jboss.test.deployers.support.ejb.MySLSBean;
import org.jboss.test.deployers.support.ext.ExternalWebBean;
import org.jboss.test.deployers.support.jar.PlainJavaBean;
import org.jboss.test.deployers.support.jsf.NotWBJsfBean;
import org.jboss.test.deployers.support.ui.UIWebBean;
import org.jboss.test.deployers.support.util.SomeUtil;
import org.jboss.test.deployers.support.web.ServletWebBean;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractWeldTest
extends BootstrapDeployersTest {
    protected AbstractWeldTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        Set excluded = AbstractJDKChecker.getExcluded();
        excluded.add(BeanMetaDataFactoryVisitor.class);
        super.setUp();
    }

    protected void assertInstanceOf(Object target, String className, ClassLoader cl) throws Exception {
        Class<?> clazz = cl.loadClass(className);
        AbstractWeldTest.assertTrue((boolean)clazz.isInstance(target));
    }

    protected boolean invoke(Object target, String name) throws Exception {
        Method m = target.getClass().getMethod("is" + name, new Class[0]);
        return (Boolean)m.invoke(target, new Object[0]);
    }

    protected VirtualFile createBasicEar() throws Exception {
        return this.createBasicEar(SomeUtil.class);
    }

    protected VirtualFile createBasicEar(Class<?> utilClass) throws Exception {
        VirtualFile ear = this.createTopLevelWithUtil(utilClass);
        VirtualFile jar = ear.getChild("simple.jar");
        this.createAssembledDirectory(jar).addPackage(PlainJavaBean.class).addPath("/weld/simple/jar");
        VirtualFile ejbs = ear.getChild("ejbs.jar");
        this.createAssembledDirectory(ejbs).addPackage(MySLSBean.class).addPath("/weld/simple/ejb");
        VirtualFile war = ear.getChild("simple.war");
        this.createAssembledDirectory(war).addPackage("WEB-INF/classes", ServletWebBean.class).addPath("/weld/simple/web").addPackage("WEB-INF/lib/ui.jar", UIWebBean.class).addPath("WEB-INF/lib/ui.jar", "/weld/simple/ui");
        war = ear.getChild("crm.war");
        this.createAssembledDirectory(war).addPackage("WEB-INF/classes", NotWBJsfBean.class).addPackage("WEB-INF/lib/crm.jar", CrmWebBean.class).addPath("WEB-INF/lib/crm.jar", "/weld/simple/crm");
        this.enableTrace("org.jboss.deployers");
        return ear;
    }

    protected VirtualFile createTopLevelWithUtil() throws Exception {
        return this.createTopLevelWithUtil("/weld/simple");
    }

    protected VirtualFile createTopLevelWithUtil(Class<?> utilClass) throws Exception {
        if (utilClass != null) {
            return this.createTopLevelWithUtil("/weld/simple", utilClass);
        }
        return this.createTopLevelWithUtil();
    }

    protected VirtualFile createTopLevelWithUtil(String path) throws Exception {
        return this.createTopLevelWithUtil(path, SomeUtil.class);
    }

    protected VirtualFile createTopLevelWithUtil(String path, Class<?> utilClass) throws Exception {
        VirtualFile earFile = VFS.getChild((String)"top-level.ear");
        this.createAssembledDirectory(earFile).addPath(path).addPackage("lib/util.jar", utilClass).addPackage("lib/ext.jar", ExternalWebBean.class).addPath("lib/ext.jar", "/weld/simple/ext");
        return earFile;
    }

    protected VirtualFile createWarInEar() throws Exception {
        VirtualFile earFile = VFS.getChild((String)"war-in-ear.ear");
        this.createAssembledDirectory(earFile).addPath("/weld/warinear").addPackage("simple.war/WEB-INF/classes", ServletWebBean.class).addPath("simple.war", "/weld/simple/web");
        return earFile;
    }

    protected VirtualFile createJarInEar() throws Exception {
        VirtualFile earFile = VFS.getChild((String)"jar-in-ear.ear");
        this.createAssembledDirectory(earFile).addPath("/weld/jarinear").addPackage("simple.jar", PlainJavaBean.class).addPath("simple.jar", "/weld/simple/jar");
        return earFile;
    }

    protected VirtualFile createWar(String warName, Class<?> reference) throws Exception {
        VirtualFile warFile = VFS.getChild((String)warName);
        this.createAssembledDirectory(warFile).addPackage("WEB-INF/classes", reference).addPath("/weld/simple/web");
        return warFile;
    }

    protected VirtualFile createEjbJar(String jarName, Class<?> reference) throws Exception {
        VirtualFile jarFile = VFS.getChild((String)jarName);
        this.createAssembledDirectory(jarFile).addPackage(reference).addPath("/weld/simple/ejb");
        return jarFile;
    }
}

