/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jmx.adaptor.snmp.agent;

import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;

class SecurityActions {
    private SecurityActions() {
        throw new UnsupportedOperationException("No instances permitted");
    }

    static InputStream getThreadContextClassLoaderResource(String resourceName) throws IllegalArgumentException {
        ClassLoader cl = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
        InputStream in = cl.getResourceAsStream(resourceName);
        if (in == null) {
            throw new IllegalArgumentException("Cannot locate classloader resource \"" + resourceName + "\" using " + cl);
        }
        return in;
    }
}

