/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jmx.adaptor.snmp.agent;

import java.io.InputStream;
import java.net.InetAddress;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.jmx.adaptor.snmp.agent.AttributeMappingsBinding;
import org.jboss.jmx.adaptor.snmp.agent.AttributeTableMapper;
import org.jboss.jmx.adaptor.snmp.agent.BindEntry;
import org.jboss.jmx.adaptor.snmp.agent.Clock;
import org.jboss.jmx.adaptor.snmp.agent.EndOfMibViewException;
import org.jboss.jmx.adaptor.snmp.agent.NoSuchInstanceException;
import org.jboss.jmx.adaptor.snmp.agent.ReadOnlyException;
import org.jboss.jmx.adaptor.snmp.agent.Reconfigurable;
import org.jboss.jmx.adaptor.snmp.agent.RequestHandlerSupport;
import org.jboss.jmx.adaptor.snmp.agent.SecurityActions;
import org.jboss.jmx.adaptor.snmp.agent.TableMapper;
import org.jboss.jmx.adaptor.snmp.agent.VariableTypeException;
import org.jboss.jmx.adaptor.snmp.config.attribute.AttributeMappings;
import org.jboss.jmx.adaptor.snmp.config.attribute.ManagedBean;
import org.jboss.jmx.adaptor.snmp.config.attribute.MappedAttribute;
import org.jboss.logging.Logger;
import org.jboss.xb.binding.ObjectModelFactory;
import org.jboss.xb.binding.Unmarshaller;
import org.jboss.xb.binding.UnmarshallerFactory;
import org.snmp4j.PDU;
import org.snmp4j.PDUv1;
import org.snmp4j.ScopedPDU;
import org.snmp4j.Snmp;
import org.snmp4j.smi.Counter32;
import org.snmp4j.smi.Counter64;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.Null;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.TimeTicks;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.util.DefaultPDUFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestHandlerImpl
extends RequestHandlerSupport
implements Reconfigurable {
    public static final String NO_ENTRY_FOUND_FOR_OID = "No bind entry found for oid ";
    public static final String SKIP_ENTRY = " - skipping entry";
    protected SortedMap<OID, BindEntry> bindings = new TreeMap<OID, BindEntry>();
    private SortedSet<OID> oidKeys = new TreeSet<OID>();
    private TableMapper tableMapper = null;
    private AttributeTableMapper attributeTableMapper = null;
    private boolean initialized = false;

    @Override
    public void initialize(String resourceName, MBeanServer server, Logger log, Clock uptime) throws Exception {
        log.debug((Object)("initialize() with res=" + resourceName));
        super.initialize(resourceName, server, log, uptime);
        this.tableMapper = new TableMapper(server, log);
        this.attributeTableMapper = new AttributeTableMapper(server, log);
        if (resourceName != null) {
            this.initializeBindings();
        } else {
            log.warn((Object)"No RequestHandlerResName configured, disabling snmp-get");
        }
        this.initialized = true;
    }

    @Override
    public void reconfigure(String resName) throws Exception {
        if (resName == null || resName.equals("")) {
            throw new IllegalArgumentException("Null or empty resName, cannot reconfigure");
        }
        if (!this.initialized) {
            throw new IllegalStateException("Cannot reconfigure, not initialized yet");
        }
        this.resourceName = resName;
        this.bindings.clear();
        this.initializeBindings();
    }

    @Override
    public PDU snmpReceivedGetBulk(PDU pdu) {
        OID noid;
        OID oid;
        int i;
        int maxRepetitions;
        PDU response = this.getResponsePDU(pdu);
        if (response == null) {
            return response;
        }
        boolean trace = this.log.isTraceEnabled();
        if (trace) {
            this.log.trace((Object)("requestID=" + pdu.getRequestID() + ", elementCount=" + pdu.size()));
        }
        int errorIndex = 1;
        int nonRepeaters = pdu.getNonRepeaters();
        if (nonRepeaters < 0) {
            nonRepeaters = 0;
        }
        if ((maxRepetitions = pdu.getMaxRepetitions()) < 0) {
            maxRepetitions = 0;
        }
        Vector vbList = pdu.getVariableBindings();
        VariableBinding vb = null;
        Null var = null;
        if (vbList.size() == 0) {
            this.log.debug((Object)"snmpReceivedGetBulk: No VariableBindings in received PDU");
            this.makeErrorPdu(response, pdu, errorIndex, 5);
            return response;
        }
        for (i = 0; i < Math.min(nonRepeaters, vbList.size()); ++i) {
            vb = (VariableBinding)vbList.get(i);
            oid = vb.getOid();
            noid = null;
            try {
                noid = this.getNextOid(oid);
            }
            catch (EndOfMibViewException e) {
                this.log.debug((Object)"snmpReceivedGetBulk: End of MIB View in NonRepeaters.");
                var = Null.endOfMibView;
                response.add(new VariableBinding(oid, (Variable)var));
                continue;
            }
            try {
                var = this.getValueFor(noid);
            }
            catch (NoSuchInstanceException e) {
                this.log.debug((Object)"snmpReceivedGetBulk: An instance of an OID didn't exist.");
                response.add(new VariableBinding(oid, (Variable)Null.noSuchInstance));
                continue;
            }
            catch (VariableTypeException e) {
                this.log.debug((Object)"snmpReceivedGetBulk: Couldn't convert a Variable to a correct type.");
                this.makeErrorPdu(response, pdu, errorIndex, 5);
                return response;
            }
            response.add(new VariableBinding(noid, (Variable)var));
            ++errorIndex;
        }
        for (i = nonRepeaters; i < vbList.size(); ++i) {
            vb = (VariableBinding)vbList.get(i);
            oid = vb.getOid();
            noid = null;
            try {
                noid = this.getNextOid(oid);
            }
            catch (EndOfMibViewException e) {
                response.add(new VariableBinding(oid, (Variable)Null.endOfMibView));
                continue;
            }
            for (int j = 0; j < maxRepetitions; ++j) {
                try {
                    var = this.getValueFor(noid);
                }
                catch (NoSuchInstanceException e) {
                    var = Null.noSuchInstance;
                }
                catch (VariableTypeException e) {
                    this.makeErrorPdu(response, pdu, errorIndex, 5);
                    var = Null.instance;
                }
                response.add(new VariableBinding(noid, (Variable)var));
                try {
                    noid = this.getNextOid(noid);
                    continue;
                }
                catch (EndOfMibViewException e) {
                    response.add(new VariableBinding(noid, (Variable)Null.endOfMibView));
                    break;
                }
            }
            ++errorIndex;
        }
        return response;
    }

    @Override
    public PDU snmpReceivedGet(PDU pdu) {
        int errorIndex = 1;
        boolean endOfMib = false;
        PDU response = this.getResponsePDU(pdu);
        boolean trace = this.log.isTraceEnabled();
        if (trace) {
            this.log.trace((Object)("requestID=" + pdu.getRequestID() + ", elementCount=" + pdu.size()));
        }
        Iterator it = pdu.getVariableBindings().iterator();
        OID noid = null;
        while (it.hasNext()) {
            Null var;
            VariableBinding newVB;
            VariableBinding vb = (VariableBinding)it.next();
            OID oid = vb.getOid();
            if (pdu.getType() == -95) {
                try {
                    noid = this.getNextOid(oid);
                }
                catch (EndOfMibViewException e) {
                    this.log.debug((Object)"snmpReceivedGet: GETNEXT operation left the MIB View");
                    endOfMib = true;
                }
                if (endOfMib) {
                    newVB = new VariableBinding(oid);
                    var = Null.endOfMibView;
                } else {
                    newVB = new VariableBinding(noid);
                    try {
                        var = this.getValueFor(noid);
                    }
                    catch (NoSuchInstanceException e) {
                        this.log.debug((Object)"snmpReceivedGet: GETNEXT operation returned null. No such OID.");
                        var = Null.noSuchInstance;
                    }
                    catch (VariableTypeException e) {
                        this.log.debug((Object)("snmpReceivedGet: GETNEXT operation could not convert the returned value for " + noid + " into an appropriate type."));
                        this.makeErrorPdu(response, pdu, errorIndex, 5);
                        return response;
                    }
                }
            } else {
                newVB = new VariableBinding(oid);
                var = null;
                this.tableMapper.checkTables(oid);
                if (this.checkObject(oid)) {
                    try {
                        var = this.getValueFor(oid);
                    }
                    catch (NoSuchInstanceException e) {
                        this.log.debug((Object)"snmpReceivedGet: GET operation returned null. No such Instance.");
                        var = Null.noSuchInstance;
                    }
                    catch (VariableTypeException e) {
                        this.log.debug((Object)("snmpReceivedGet: GET operation could not convert the returned value for " + oid + " into an appropriate type."));
                        this.makeErrorPdu(response, pdu, errorIndex, 5);
                        return response;
                    }
                } else {
                    var = Null.noSuchObject;
                }
            }
            newVB.setVariable((Variable)var);
            response.add(newVB);
            ++errorIndex;
        }
        return response;
    }

    @Override
    public PDU snmpReceivedSet(PDU pdu) {
        PDU response = this.getResponsePDU(pdu);
        HashSet<VariableBinding> modified = new HashSet<VariableBinding>();
        int errorIndex = 1;
        Variable oldVar = null;
        boolean trace = this.log.isTraceEnabled();
        if (trace) {
            this.log.trace((Object)("requestID=" + pdu.getRequestID() + ", elementCount=" + pdu.size()));
        }
        for (VariableBinding vb : pdu.getVariableBindings()) {
            OID oid = vb.getOid();
            Variable newVal = vb.getVariable();
            VariableBinding newVB = new VariableBinding(oid, newVal);
            try {
                this.tableMapper.checkTables(oid);
                oldVar = this.getValueFor(oid);
                modified.add(new VariableBinding(oid, oldVar));
                if (!this.checkObject(oid)) {
                    this.log.error((Object)"snmpReceivedSet: no object for SET request");
                    this.undoSets(modified);
                    this.makeErrorPdu(response, pdu, errorIndex, 6);
                    return response;
                }
                Variable var = this.setValueFor(oid, newVal);
            }
            catch (NoSuchInstanceException e) {
                this.log.info((Object)("snmpReceivedSet: attempt to set a non-existent instance: " + oid.last() + " of object: " + oid.trim()), (Throwable)e);
                this.undoSets(modified);
                this.makeErrorPdu(response, pdu, errorIndex, 11);
                return response;
            }
            catch (VariableTypeException e) {
                this.log.info((Object)("snmpReceievedSet: could not convert the given value into an appropriate type: " + newVal), (Throwable)e);
                this.undoSets(modified);
                this.makeErrorPdu(response, pdu, errorIndex, 7);
                return response;
            }
            catch (ReadOnlyException e) {
                this.log.info((Object)("snmpReceivedSet: attempt to set a read-only attribute: " + newVB), (Throwable)e);
                this.undoSets(modified);
                this.makeErrorPdu(response, pdu, errorIndex, 17);
                return response;
            }
            catch (Exception e) {
                this.log.error((Object)"snmpReceivedSet: catastrophe!!! General variable validation error.", (Throwable)e);
                this.undoSets(modified);
                this.makeErrorPdu(response, pdu, errorIndex, 5);
                return response;
            }
            response.add(newVB);
            ++errorIndex;
        }
        return response;
    }

    private PDU getResponsePDU(PDU pdu) {
        PDU response;
        if (pdu instanceof ScopedPDU) {
            response = DefaultPDUFactory.createPDU((int)3);
            ((ScopedPDU)response).setContextEngineID(((ScopedPDU)pdu).getContextEngineID());
            ((ScopedPDU)response).setContextName(((ScopedPDU)pdu).getContextName());
        } else if (pdu instanceof PDUv1) {
            if (pdu.getType() == -91) {
                this.log.debug((Object)"snmpReceievedGetBulk: cannot getBulk with V1 PDU.");
                return null;
            }
            response = DefaultPDUFactory.createPDU((int)0);
        } else {
            response = new PDU();
        }
        response.setType(-94);
        return response;
    }

    @Override
    public void snmpReceivedPdu(Snmp session, InetAddress manager, int port, OctetString community, PDU pdu) {
    }

    @Override
    public void SnmpAgentSessionError(Snmp session, int error, Object ref) {
    }

    private void initializeBindings() throws Exception {
        this.log.debug((Object)("Reading resource: '" + this.resourceName + "'"));
        AttributeMappingsBinding omf = new AttributeMappingsBinding();
        InputStream is = null;
        AttributeMappings mappings = null;
        try {
            is = SecurityActions.getThreadContextClassLoaderResource(this.resourceName);
            Unmarshaller unmarshaller = UnmarshallerFactory.newInstance().newUnmarshaller();
            mappings = (AttributeMappings)unmarshaller.unmarshal(is, (ObjectModelFactory)omf, null);
        }
        catch (Exception e) {
            this.log.error((Object)("Accessing resource '" + this.resourceName + "'"));
            throw e;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        if (mappings == null) {
            this.log.warn((Object)("No bindings found in " + this.resourceName));
            return;
        }
        this.log.debug((Object)("Found " + mappings.size() + " attribute mappings"));
        this.addAttributeMappings(mappings);
    }

    @Override
    public void addAttributeMappings(List<ManagedBean> mappings) {
        for (ManagedBean mmb : mappings) {
            ObjectName oname = null;
            try {
                oname = new ObjectName(mmb.getName());
            }
            catch (Exception e) {
                // empty catch block
            }
            if (oname.isPattern()) {
                this.tableMapper.addTableMapping(mmb, oname);
                continue;
            }
            String oidPrefix = mmb.getOidPrefix();
            List<MappedAttribute> attrs = mmb.getAttributes();
            for (MappedAttribute ma : attrs) {
                String oid = oidPrefix != null ? oidPrefix + ma.getOid() : ma.getOid();
                if (ma.isAttributeTable()) {
                    this.attributeTableMapper.addTableMapping(mmb, ma);
                    this.oidKeys.add(new OID(oid));
                    continue;
                }
                oid = oid + ".0";
                this.addBindEntry(oid, mmb.getName(), ma.getName(), ma.isReadWrite());
            }
        }
    }

    @Override
    public void removeAttributeMappings(List<ManagedBean> mappings) {
        for (ManagedBean mmb : mappings) {
            ObjectName oname = null;
            try {
                oname = new ObjectName(mmb.getName());
            }
            catch (Exception e) {
                // empty catch block
            }
            if (oname.isPattern()) {
                this.tableMapper.removeTableMapping(mmb, oname);
                continue;
            }
            String oidPrefix = mmb.getOidPrefix();
            List<MappedAttribute> attrs = mmb.getAttributes();
            for (MappedAttribute ma : attrs) {
                String oid = oidPrefix != null ? oidPrefix + ma.getOid() : ma.getOid();
                if (ma.isAttributeTable()) {
                    this.attributeTableMapper.removeTableMapping(mmb, ma);
                    this.oidKeys.remove(new OID(oid));
                    continue;
                }
                oid = oid + ".0";
                OID coid = new OID(oid);
                this.oidKeys.remove(coid);
                this.bindings.remove(coid);
            }
        }
    }

    private void addBindEntry(String oid, String mmb, String ma, boolean rw) {
        OID coid = new OID(oid);
        BindEntry be = new BindEntry(coid, mmb, ma);
        be.setReadWrite(rw);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("New bind entry   " + be));
        }
        if (this.bindings.containsKey(coid)) {
            this.log.info((Object)("Duplicate oid " + oid + SKIP_ENTRY));
        }
        if (mmb == null || mmb.equals("")) {
            this.log.info((Object)("Invalid mbean name for oid " + oid + SKIP_ENTRY));
        }
        if (ma == null || ma.equals("")) {
            this.log.info((Object)("Invalid attribute name " + ma + " for oid " + oid + SKIP_ENTRY));
        }
        this.bindings.put(coid, be);
        this.oidKeys.add(coid);
    }

    private boolean checkObject(OID oid) {
        boolean exists;
        boolean bl = exists = this.bindings.get(oid) != null;
        if (!exists && !(exists = this.tableMapper.belongsToTable(oid))) {
            exists = this.attributeTableMapper.belongsToTables(oid);
        }
        return exists;
    }

    @Override
    public Variable getValueFor(OID oid) throws NoSuchInstanceException, VariableTypeException {
        BindEntry be = this.findBindEntryForOid(oid);
        Variable ssy = null;
        if (be != null) {
            if (this.log.isTraceEnabled()) {
                this.log.debug((Object)("getValueFor: Found entry " + be.toString() + " for oid " + oid));
            }
            try {
                Object val = this.server.getAttribute(be.getMbean(), be.getAttr().getName());
                OID tableIndexOID = null;
                if (be.isTable()) {
                    tableIndexOID = be.getTableIndexOID();
                }
                ssy = RequestHandlerImpl.prepForPdu(val, tableIndexOID);
            }
            catch (VariableTypeException e) {
                this.log.debug((Object)"getValueFor: didn't find a suitable data type for the requested data");
                throw e;
            }
            catch (Exception e) {
                this.log.warn((Object)("getValueFor: (" + be.getMbean().toString() + ", " + be.getAttr().getName() + ": " + e.toString()));
            }
        } else {
            ssy = this.tableMapper.getObjectNameIndexValue(oid);
            if (ssy != null) {
                return ssy;
            }
            ssy = this.attributeTableMapper.getIndexValue(oid);
            if (ssy != null) {
                return ssy;
            }
            this.log.debug((Object)("getValueFor: No bind entry found for oid " + oid));
            throw new NoSuchInstanceException();
        }
        return ssy;
    }

    public static Variable prepForPdu(Object val, OID tableIndexOID) throws VariableTypeException {
        OctetString result = null;
        Object value = val;
        if (val == null) {
            return new Null();
        }
        if (tableIndexOID != null) {
            String key;
            int index;
            if (val instanceof List) {
                index = Integer.valueOf(tableIndexOID.toString().substring(2)) - 1;
                if (index < 0) {
                    return Null.noSuchObject;
                }
                if (index < ((List)val).size()) {
                    value = ((List)val).get(index);
                } else {
                    return Null.noSuchObject;
                }
            }
            if (val instanceof Map && (value = ((Map)val).get(key = new String(new OID(tableIndexOID.toString().substring(2)).toByteArray()))) == null) {
                return Null.noSuchObject;
            }
            if (value instanceof int[]) {
                index = Integer.valueOf(tableIndexOID.toString().substring(2)) - 1;
                if (index < 0) {
                    return Null.noSuchObject;
                }
                if (index < ((int[])val).length) {
                    value = ((int[])val)[index];
                } else {
                    return Null.noSuchObject;
                }
            }
            if (value instanceof long[]) {
                index = Integer.valueOf(tableIndexOID.toString().substring(2)) - 1;
                if (index < 0) {
                    return Null.noSuchObject;
                }
                if (index < ((long[])val).length) {
                    value = ((long[])val)[index];
                } else {
                    return Null.noSuchObject;
                }
            }
            if (value instanceof boolean[]) {
                index = Integer.valueOf(tableIndexOID.toString().substring(2)) - 1;
                if (index < 0) {
                    return Null.noSuchObject;
                }
                if (index < ((boolean[])val).length) {
                    value = ((boolean[])val)[index];
                } else {
                    return Null.noSuchObject;
                }
            }
            if (value instanceof Object[]) {
                index = Integer.valueOf(tableIndexOID.toString().substring(2)) - 1;
                if (index < 0) {
                    return Null.noSuchObject;
                }
                if (index < ((Object[])val).length) {
                    value = ((Object[])val)[index];
                } else {
                    return Null.noSuchObject;
                }
            }
        }
        if (value instanceof Long) {
            result = new OctetString(((Long)value).toString());
        } else if (value instanceof AtomicLong) {
            result = new OctetString(((AtomicLong)value).toString());
        } else if (value instanceof Double) {
            result = new OctetString(((Double)value).toString());
        } else if (value instanceof Boolean) {
            result = ((Boolean)value).booleanValue() ? new Integer32(1) : new Integer32(0);
        } else if (value instanceof AtomicBoolean) {
            result = ((AtomicBoolean)value).get() ? new Integer32(1) : new Integer32(0);
        } else if (value instanceof String) {
            result = new OctetString((String)value);
        } else if (value instanceof Integer) {
            result = new Integer32(((Integer)value).intValue());
        } else if (value instanceof AtomicInteger) {
            result = new Integer32(((AtomicInteger)value).get());
        } else if (value instanceof OID) {
            result = new OID((OID)value);
        } else if (value instanceof TimeTicks) {
            result = (TimeTicks)value;
        } else if (value instanceof Counter32) {
            result = (Counter32)value;
        } else {
            throw new VariableTypeException();
        }
        return result;
    }

    private Object convertVariableToValue(Variable val, Object attribute) throws VariableTypeException {
        Object result = null;
        if (val instanceof OctetString) {
            result = attribute instanceof Long ? Long.valueOf(Long.parseLong(val.toString())) : (attribute instanceof AtomicLong ? new AtomicLong(Long.parseLong(val.toString())) : (attribute instanceof Double ? Double.valueOf(Double.parseDouble(val.toString())) : val.toString()));
        } else if (val instanceof Integer32) {
            result = attribute instanceof Boolean ? (((Integer32)val).getValue() == 0 ? Boolean.FALSE : Boolean.TRUE) : (attribute instanceof AtomicBoolean ? (((Integer32)val).getValue() == 0 ? new AtomicBoolean(Boolean.FALSE) : new AtomicBoolean(Boolean.TRUE)) : (attribute instanceof AtomicInteger ? new AtomicInteger(((Integer32)val).getValue()) : Integer.valueOf(((Integer32)val).getValue())));
        } else if (val instanceof Counter32) {
            result = ((Counter32)val).getValue();
        } else if (val instanceof Counter64) {
            result = ((Counter64)val).getValue();
        } else {
            throw new VariableTypeException();
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Variable setValueFor(OID oid, Variable newVal) throws ReadOnlyException, VariableTypeException, NoSuchInstanceException {
        boolean trace = this.log.isTraceEnabled();
        BindEntry be = this.findBindEntryForOid(oid);
        Variable ssy = null;
        if (trace) {
            this.log.trace((Object)("setValueFor: found bind entry for " + oid));
        }
        if (be == null) throw new NoSuchInstanceException();
        if (trace) {
            this.log.trace((Object)("setValueFor: " + be.toString()));
        }
        if (!be.isReadWrite()) {
            if (!trace) throw new ReadOnlyException(oid);
            this.log.trace((Object)"setValueFor: this is marked read only");
            throw new ReadOnlyException(oid);
        }
        try {
            OID tableIndexOID;
            Object other = this.server.getAttribute(be.getMbean(), be.getAttr().getName());
            Object val = this.convertVariableToValue(newVal, other);
            if (other != null && val.getClass() != other.getClass()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"setValueFor: attempt to set an MBean Attribute with the wrong type.");
                }
                ssy = newVal;
            }
            if ((tableIndexOID = be.getTableIndexOID()) == null) {
                Attribute at = new Attribute(be.getAttr().getName(), val);
                this.server.setAttribute(be.getMbean(), at);
            } else {
                if (other instanceof List) {
                    int index = Integer.valueOf(tableIndexOID.toString().substring(2)) - 1;
                    if (index < 0) {
                        return Null.noSuchObject;
                    }
                    if (index >= ((List)other).size()) return Null.noSuchObject;
                    ((List)other).set(index, val);
                }
                if (other instanceof Map) {
                    String key = new String(new OID(tableIndexOID.toString().substring(2)).toByteArray());
                    ((Map)other).put(key, val);
                }
                if (other instanceof int[]) {
                    int index = Integer.valueOf(tableIndexOID.toString().substring(2)) - 1;
                    if (index < 0) {
                        return Null.noSuchObject;
                    }
                    if (index >= ((int[])other).length) return Null.noSuchObject;
                    ((int[])other)[index] = (Integer)val;
                }
                if (other instanceof long[]) {
                    int index = Integer.valueOf(tableIndexOID.toString().substring(2)) - 1;
                    if (index < 0) {
                        return Null.noSuchObject;
                    }
                    if (index >= ((long[])other).length) return Null.noSuchObject;
                    ((long[])other)[index] = (Long)val;
                }
                if (other instanceof boolean[]) {
                    int index = Integer.valueOf(tableIndexOID.toString().substring(2)) - 1;
                    if (index < 0) {
                        return Null.noSuchObject;
                    }
                    if (index >= ((boolean[])other).length) return Null.noSuchObject;
                    ((boolean[])other)[index] = (Boolean)val;
                }
                if (other instanceof Object[]) {
                    int index = Integer.valueOf(tableIndexOID.toString().substring(2)) - 1;
                    if (index < 0) {
                        return Null.noSuchObject;
                    }
                    if (index >= ((Object[])other).length) return Null.noSuchObject;
                    ((Object[])other)[index] = val;
                }
            }
            if (!trace) return ssy;
            this.log.trace((Object)"setValueFor: set attribute in mbean server");
            return ssy;
        }
        catch (VariableTypeException e) {
            this.log.debug((Object)("setValueFor: didn't find a suitable data type for newVal " + newVal));
            throw e;
        }
        catch (Exception e) {
            this.log.debug((Object)("setValueFor: exception " + e.getMessage()));
            return newVal;
        }
    }

    private void undoSets(HashSet<VariableBinding> modified) {
        Iterator<VariableBinding> iter = modified.iterator();
        while (iter.hasNext()) {
            try {
                VariableBinding vb = iter.next();
                OID oid = vb.getOid();
                Variable var = vb.getVariable();
                this.setValueFor(oid, var);
            }
            catch (NoSuchInstanceException e) {
            }
            catch (VariableTypeException e) {
            }
            catch (ReadOnlyException readOnlyException) {}
        }
    }

    private BindEntry findBindEntryForOid(OID oid) {
        OID coid = new OID(oid);
        BindEntry be = (BindEntry)this.bindings.get(coid);
        if (be == null && (be = this.tableMapper.getTableBinding(coid)) == null) {
            be = this.attributeTableMapper.getTableBinding(coid, false);
        }
        return be;
    }

    private OID getNextOid(OID oid) throws EndOfMibViewException {
        OID coid = new OID(oid);
        this.tableMapper.checkTables(oid);
        OID nextOid = this.tableMapper.getNextTable(coid);
        if (nextOid != null) {
            return nextOid;
        }
        nextOid = this.attributeTableMapper.getNextTable(coid);
        if (nextOid != null) {
            return nextOid;
        }
        TreeSet<OID> ret = new TreeSet<OID>(this.oidKeys.tailSet(oid));
        Iterator it = ret.iterator();
        OID roid = null;
        if (!it.hasNext()) {
            this.log.debug((Object)"getNextOid: Placeholder. There is no lexically larger OID than the input.");
            throw new EndOfMibViewException();
        }
        roid = (OID)it.next();
        if (roid.compareTo((Object)coid) == 0) {
            if (it.hasNext()) {
                roid = (OID)it.next();
            } else {
                this.log.debug((Object)"getNextOid: Placeholder. There is no lexically larger OID than the input.");
                throw new EndOfMibViewException();
            }
        }
        if (roid.last() != 0) {
            nextOid = this.tableMapper.getNextTable(roid);
            if (nextOid != null) {
                return nextOid;
            }
            nextOid = this.attributeTableMapper.getNextTable(roid);
            if (nextOid != null) {
                return nextOid;
            }
        }
        return roid;
    }

    private void makeErrorPdu(PDU response, PDU pdu, int errorIndex, int err) {
        response.clear();
        response.addAll(pdu.toArray());
        response.setErrorIndex(errorIndex);
        response.setErrorStatus(err);
    }
}

