/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.varia.counter;

import java.text.DecimalFormat;
import java.util.HashMap;
import javax.naming.InitialContext;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.jboss.naming.NonSerializableFactory;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.varia.counter.CounterServiceMBean;

public class CounterService
extends ServiceMBeanSupport
implements CounterServiceMBean {
    public static final String JNDI_NAME = "java:/CounterService";
    private HashMap counterMap = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void accumulate(String counterName, long add) {
        Counter counter = null;
        HashMap hashMap = this.counterMap;
        synchronized (hashMap) {
            counter = (Counter)this.counterMap.get(counterName);
            if (counter == null) {
                counter = new Counter(counterName);
                this.counterMap.put(counterName, counter);
            }
        }
        counter.addToCount(add);
    }

    protected void startService() throws Exception {
        InitialContext ctx = new InitialContext();
        NonSerializableFactory.bind((String)JNDI_NAME, (Object)this);
        StringRefAddr addr = new StringRefAddr("nns", JNDI_NAME);
        Reference ref = new Reference(this.getClass().getName(), addr, NonSerializableFactory.class.getName(), null);
        ctx.bind(JNDI_NAME, (Object)ref);
    }

    protected void stopService() throws Exception {
        InitialContext ctx = new InitialContext();
        ctx.unbind(JNDI_NAME);
        NonSerializableFactory.unbind((String)JNDI_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String list() {
        DecimalFormat format = new DecimalFormat("####0.0000");
        String retVal = "";
        for (String key : this.counterMap.keySet()) {
            Counter counter = (Counter)this.counterMap.get(key);
            long total = 0L;
            int entries = 0;
            Counter counter2 = counter;
            synchronized (counter2) {
                total = counter.getCount();
                entries = counter.getEntries();
            }
            double avg = (double)total / (double)entries;
            String descrip = key + ": total=" + total + " on " + entries + "entries for " + "an average of " + format.format(avg) + "<br>\n";
            retVal = retVal + descrip;
        }
        return retVal;
    }

    private static class Counter {
        private String name;
        private long count = 0L;
        private int entries = 0;

        public Counter(String n) {
            this.name = n;
        }

        public String getName() {
            return this.name;
        }

        public synchronized long getCount() {
            return this.count;
        }

        public synchronized int getEntries() {
            return this.entries;
        }

        public synchronized void addToCount(long add) {
            this.count += add;
            ++this.entries;
        }
    }
}

