/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jmx.adaptor.snmp.agent;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.management.Notification;
import org.jboss.jmx.adaptor.snmp.agent.Clock;
import org.jboss.jmx.adaptor.snmp.agent.Counter;
import org.jboss.jmx.adaptor.snmp.agent.MappingFailedException;
import org.jboss.jmx.adaptor.snmp.agent.NotificationWrapper;
import org.jboss.jmx.adaptor.snmp.agent.SecurityActions;
import org.jboss.jmx.adaptor.snmp.agent.SnmpVarBindFactory;
import org.jboss.jmx.adaptor.snmp.agent.TrapFactory;
import org.jboss.jmx.adaptor.snmp.config.notification.Mapping;
import org.jboss.jmx.adaptor.snmp.config.notification.VarBind;
import org.jboss.jmx.adaptor.snmp.config.notification.VarBindList;
import org.jboss.logging.Logger;
import org.jboss.xb.binding.GenericObjectModelFactory;
import org.jboss.xb.binding.ObjectModelFactory;
import org.jboss.xb.binding.Unmarshaller;
import org.jboss.xb.binding.UnmarshallerFactory;
import org.jboss.xb.binding.UnmarshallingContext;
import org.opennms.protocols.snmp.SnmpPduPacket;
import org.opennms.protocols.snmp.SnmpPduRequest;
import org.opennms.protocols.snmp.SnmpPduTrap;
import org.xml.sax.Attributes;

public class TrapFactorySupport
implements TrapFactory {
    private static final Logger log = Logger.getLogger(TrapFactorySupport.class);
    private SnmpVarBindFactory snmpVBFactory = new SnmpVarBindFactory();
    private String notificationMapResName = null;
    private Clock clock = null;
    private Counter trapCount = null;
    private ArrayList notificationMapList = null;
    private ArrayList mappingRegExpCache = null;
    private ArrayList notificationWrapperCache = null;

    public void set(String notificationMapResName, Clock clock, Counter count) {
        this.notificationMapResName = notificationMapResName;
        this.clock = clock;
        this.trapCount = count;
    }

    public void start() throws Exception {
        log.debug((Object)("Reading resource: '" + this.notificationMapResName + "'"));
        NotificationBinding omf = new NotificationBinding();
        InputStream is = null;
        try {
            String resName = this.notificationMapResName;
            is = SecurityActions.getThreadContextClassLoaderResource(resName);
            Unmarshaller unmarshaller = UnmarshallerFactory.newInstance().newUnmarshaller();
            this.notificationMapList = (ArrayList)unmarshaller.unmarshal(is, (ObjectModelFactory)omf, null);
        }
        catch (Exception e) {
            log.error((Object)("Accessing resource '" + this.notificationMapResName + "'"));
            throw e;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        log.debug((Object)("Found " + this.notificationMapList.size() + " notification mappings"));
        this.mappingRegExpCache = new ArrayList(this.notificationMapList.size());
        this.notificationWrapperCache = new ArrayList(this.notificationMapList.size());
        for (Mapping mapping : this.notificationMapList) {
            String notificationType = mapping.getNotificationType();
            try {
                Pattern re = Pattern.compile(notificationType);
                this.mappingRegExpCache.add(re);
            }
            catch (PatternSyntaxException e) {
                this.mappingRegExpCache.add(null);
                log.warn((Object)("Error compiling notification mapping for type: " + notificationType), (Throwable)e);
            }
            String wrapperClassName = mapping.getVarBindList().getWrapperClass();
            log.debug((Object)("notification wrapper class: " + wrapperClassName));
            try {
                NotificationWrapper wrapper = (NotificationWrapper)Class.forName(wrapperClassName, true, this.getClass().getClassLoader()).newInstance();
                wrapper.set(this.clock, this.trapCount);
                this.notificationWrapperCache.add(wrapper);
            }
            catch (Exception e) {
                this.notificationWrapperCache.add(null);
                log.warn((Object)("Error compiling notification mapping for type: " + notificationType), (Throwable)e);
            }
        }
        log.debug((Object)"Trap factory going active");
    }

    private int findMappingIndex(Notification n) throws IndexOutOfBoundsException {
        for (int i = 0; i < this.notificationMapList.size(); ++i) {
            Matcher m;
            Pattern p = (Pattern)this.mappingRegExpCache.get(i);
            if (p == null || !(m = p.matcher(n.getType())).matches()) continue;
            if (log.isTraceEnabled()) {
                log.trace((Object)("Match for '" + n.getType() + "' on mapping " + i));
            }
            return i;
        }
        throw new IndexOutOfBoundsException();
    }

    public SnmpPduTrap generateV1Trap(Notification n) throws MappingFailedException {
        if (log.isTraceEnabled()) {
            log.trace((Object)"generateV1Trap");
        }
        int index = -1;
        try {
            index = this.findMappingIndex(n);
        }
        catch (IndexOutOfBoundsException e) {
            throw new MappingFailedException("No mapping found for notification type: '" + n.getType() + "'");
        }
        Mapping m = (Mapping)this.notificationMapList.get(index);
        SnmpPduTrap trapPdu = new SnmpPduTrap();
        trapPdu.setTimeStamp(this.clock.uptime());
        trapPdu.setGeneric(m.getGeneric());
        trapPdu.setSpecific(m.getSpecific());
        trapPdu.setEnterprise(m.getEnterprise());
        NotificationWrapper wrapper = (NotificationWrapper)this.notificationWrapperCache.get(index);
        if (wrapper != null) {
            wrapper.prime(n);
            List vbList = m.getVarBindList().getVarBindList();
            for (int i = 0; i < vbList.size(); ++i) {
                VarBind vb = (VarBind)vbList.get(i);
                trapPdu.addVarBind(this.snmpVBFactory.make(vb.getOid(), wrapper.get(vb.getTag())));
            }
        } else {
            throw new MappingFailedException("Varbind mapping failure: null wrapper defined for  notification type '" + m.getNotificationType() + "'");
        }
        return trapPdu;
    }

    public SnmpPduPacket generateV2Trap(Notification n) throws MappingFailedException {
        if (log.isTraceEnabled()) {
            log.trace((Object)"generateV2Trap");
        }
        int index = -1;
        try {
            index = this.findMappingIndex(n);
        }
        catch (IndexOutOfBoundsException e) {
            throw new MappingFailedException("No mapping found for notification type: '" + n.getType() + "'");
        }
        Mapping m = (Mapping)this.notificationMapList.get(index);
        SnmpPduRequest trapPdu = new SnmpPduRequest(167);
        NotificationWrapper wrapper = (NotificationWrapper)this.notificationWrapperCache.get(index);
        if (wrapper != null) {
            wrapper.prime(n);
            List vbList = m.getVarBindList().getVarBindList();
            for (int i = 0; i < vbList.size(); ++i) {
                VarBind vb = (VarBind)vbList.get(i);
                trapPdu.addVarBind(this.snmpVBFactory.make(vb.getOid(), wrapper.get(vb.getTag())));
            }
        } else {
            log.warn((Object)("Varbind mapping failure: null wrapper defined for  notification type '" + m.getNotificationType() + "'"));
        }
        return trapPdu;
    }

    private static class NotificationBinding
    implements GenericObjectModelFactory {
        private NotificationBinding() {
        }

        public Object completeRoot(Object root, UnmarshallingContext ctx, String uri, String name) {
            return root;
        }

        public Object newRoot(Object root, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
            if (root == null) {
                ArrayList notifList;
                root = notifList = new ArrayList();
            } else {
                ArrayList notifList = root;
            }
            return root;
        }

        public Object newChild(Object parent, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
            Object child = null;
            if ("mapping".equals(localName)) {
                Mapping m = new Mapping();
                child = m;
            } else if ("var-bind-list".equals(localName)) {
                VarBindList vblist = new VarBindList();
                child = vblist;
                if (attrs.getLength() > 0) {
                    for (int i = 0; i < attrs.getLength(); ++i) {
                        if (!"wrapper-class".equals(attrs.getLocalName(i))) continue;
                        vblist.setWrapperClass(attrs.getValue(i));
                    }
                }
                if (vblist.getWrapperClass() == null) {
                    throw new RuntimeException("'wrapper-class' must be set at 'var-bind-list' element");
                }
            } else if ("var-bind".equals(localName)) {
                VarBind vb = new VarBind();
                child = vb;
            }
            return child;
        }

        public void addChild(Object parent, Object child, UnmarshallingContext navigator, String namespaceURI, String localName) {
            if (parent instanceof ArrayList) {
                ArrayList notifList = (ArrayList)parent;
                if (child instanceof Mapping) {
                    notifList.add(child);
                }
            } else if (parent instanceof Mapping) {
                Mapping m = (Mapping)parent;
                if (child instanceof VarBindList) {
                    m.setVarBindList((VarBindList)child);
                }
            } else if (parent instanceof VarBindList) {
                VarBindList vblist = (VarBindList)parent;
                if (child instanceof VarBind) {
                    vblist.addVarBind((VarBind)child);
                }
            }
        }

        public void setValue(Object o, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
            if (o instanceof Mapping) {
                Mapping m = (Mapping)o;
                if ("notification-type".equals(localName)) {
                    m.setNotificationType(value);
                } else if ("generic".equals(localName)) {
                    m.setGeneric(Integer.parseInt(value));
                } else if ("specific".equals(localName)) {
                    m.setSpecific(Integer.parseInt(value));
                } else if ("enterprise".equals(localName)) {
                    m.setEnterprise(value);
                }
            } else if (o instanceof VarBind) {
                VarBind vb = (VarBind)o;
                if ("tag".equals(localName)) {
                    vb.setTag(value);
                } else if ("oid".equals(localName)) {
                    vb.setOid(value);
                }
            }
        }

        public Object completedRoot(Object root, UnmarshallingContext navigator, String namespaceURI, String localName) {
            return root;
        }
    }
}

