/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.varia.stats;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.jboss.naming.NonSerializableFactory;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.varia.stats.DataSourceInterceptorMBean;
import org.jboss.varia.stats.StatisticalItem;
import org.jboss.varia.stats.TxReport;

public abstract class DataSourceInterceptor
extends ServiceMBeanSupport
implements DataSource,
DataSourceInterceptorMBean {
    private String bindName;
    private String targetName;
    protected DataSource target;
    private ObjectName statsCollector;

    public ObjectName getStatsCollector() {
        return this.statsCollector;
    }

    public void setStatsCollector(ObjectName statsCollector) {
        this.statsCollector = statsCollector;
    }

    public String getBindName() {
        return this.bindName;
    }

    public void setBindName(String bindName) throws NamingException {
        this.bindName = bindName;
        if (this.getState() == 3) {
            this.bind();
        }
    }

    public String getTargetName() {
        return this.targetName;
    }

    public void setTargetName(String targetName) throws NamingException {
        this.targetName = targetName;
        if (this.getState() == 3) {
            this.updateTarget();
        }
    }

    public void startService() throws Exception {
        this.updateTarget();
        this.bind();
    }

    public void stopService() throws Exception {
        this.unbind();
    }

    public int getLoginTimeout() throws SQLException {
        return this.target.getLoginTimeout();
    }

    public void setLoginTimeout(int seconds) throws SQLException {
        this.target.setLoginTimeout(seconds);
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.target.getLogWriter();
    }

    public void setLogWriter(PrintWriter out) throws SQLException {
        this.target.setLogWriter(out);
    }

    public abstract Connection getConnection() throws SQLException;

    public abstract Connection getConnection(String var1, String var2) throws SQLException;

    protected void logSql(String sql) {
        try {
            TxReport.SqlStats item = new TxReport.SqlStats(sql);
            this.server.invoke(this.statsCollector, "addStatisticalItem", new Object[]{item}, new String[]{StatisticalItem.class.getName()});
        }
        catch (Exception e) {
            this.log.error((Object)"Failed to add invocation.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bind() throws NamingException {
        InitialContext ic = null;
        try {
            ic = new InitialContext();
            Name name = ic.getNameParser("").parse(this.bindName);
            NonSerializableFactory.rebind((Name)name, (Object)this, (boolean)true);
            this.log.debug((Object)("bound to JNDI name " + this.bindName));
        }
        finally {
            if (ic != null) {
                ic.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unbind() throws NamingException {
        InitialContext ic = null;
        try {
            ic = new InitialContext();
            ic.unbind(this.bindName);
            NonSerializableFactory.unbind((String)this.bindName);
        }
        finally {
            if (ic != null) {
                ic.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTarget() throws NamingException {
        InitialContext ic = null;
        try {
            ic = new InitialContext();
            this.target = (DataSource)ic.lookup(this.targetName);
            this.log.debug((Object)("target updated to " + this.targetName));
        }
        finally {
            if (ic != null) {
                ic.close();
            }
        }
    }
}

