/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.varia.counter;

import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.ejb.Container;
import org.jboss.ejb.plugins.AbstractInterceptor;
import org.jboss.invocation.Invocation;
import org.jboss.varia.counter.CounterService;

public class CounterInterceptor
extends AbstractInterceptor {
    Container container = null;
    CounterService counter = null;
    boolean loggedNoCounter = false;
    StringBuffer baseCounterName = null;
    int baseNameLength = 0;

    public void setContainer(Container container) {
        this.baseCounterName = new StringBuffer(container.getBeanClass().getName());
        this.baseNameLength = this.baseCounterName.length();
        this.container = container;
    }

    public Container getContainer() {
        return this.container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invokeHome(Invocation mi) throws Exception {
        long startTime = System.currentTimeMillis();
        try {
            Object object = super.invokeHome(mi);
            return object;
        }
        finally {
            if (this.getCounter() != null) {
                long endTime = System.currentTimeMillis();
                this.baseCounterName.append("Home.");
                this.baseCounterName.append(mi.getMethod().getName());
                this.counter.accumulate(this.baseCounterName.toString(), endTime - startTime);
                this.baseCounterName.setLength(this.baseNameLength);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Invocation mi) throws Exception {
        long startTime = System.currentTimeMillis();
        try {
            Object object = super.invoke(mi);
            return object;
        }
        finally {
            if (this.getCounter() != null) {
                long endTime = System.currentTimeMillis();
                this.baseCounterName.append('.');
                this.baseCounterName.append(mi.getMethod().getName());
                this.counter.accumulate(this.baseCounterName.toString(), endTime - startTime);
                this.baseCounterName.setLength(this.baseNameLength);
            }
        }
    }

    public void create() throws Exception {
        this.log.debug((Object)"CounterInterceptor initializing");
    }

    private CounterService getCounter() {
        block3: {
            if (this.counter == null) {
                try {
                    InitialContext ctx = new InitialContext();
                    this.counter = (CounterService)ctx.lookup("java:/CounterService");
                }
                catch (NamingException ne) {
                    if (this.loggedNoCounter) break block3;
                    this.log.warn((Object)"CounterInterceptor can't get counter service ", (Throwable)ne);
                    this.loggedNoCounter = true;
                }
            }
        }
        return this.counter;
    }

    public void sample(Object s) {
    }

    public Map retrieveStatistic() {
        return null;
    }

    public void resetStatistic() {
    }
}

