/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.varia.stats;

import org.jboss.varia.stats.StatisticalItem;

public abstract class AbstractStatisticalItem
implements StatisticalItem {
    protected final String name;
    protected String value;
    private int count = 1;
    private int minCountPerTx = Integer.MAX_VALUE;
    private int maxCountPerTx;
    private int mergedItemsTotal = 1;

    public AbstractStatisticalItem(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public int getMinCountPerTx() {
        return this.minCountPerTx == Integer.MAX_VALUE ? this.count : this.minCountPerTx;
    }

    public int getMaxCountPerTx() {
        return this.maxCountPerTx == 0 ? this.count : this.maxCountPerTx;
    }

    public int getCount() {
        return this.count;
    }

    public void add(StatisticalItem item) {
        if (!this.getName().equals(item.getName())) {
            throw new IllegalArgumentException("Can't merge statistical items with different names: " + this.getName() + " and " + item.getName());
        }
        this.count += item.getCount();
    }

    public void merge(StatisticalItem item) {
        this.add(item);
        ++this.mergedItemsTotal;
        int count = item.getCount();
        if (count > this.maxCountPerTx) {
            this.maxCountPerTx = count;
        }
        if (count < this.minCountPerTx) {
            this.minCountPerTx = count;
        }
    }

    public void mergeNull() {
        this.minCountPerTx = 0;
    }

    public int getMergedItemsTotal() {
        return this.mergedItemsTotal;
    }
}

