/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.varia.stats;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.jboss.varia.stats.AbstractStatisticalItem;
import org.jboss.varia.stats.StatisticalItem;

public class TxReport
implements Serializable {
    private static final String DEFAULT_NAME = "UNKNOWN";
    private String name = "UNKNOWN";
    private final Map stats = new HashMap();
    private int count = 1;

    public String getName() {
        return this.name;
    }

    public int getCount() {
        return this.count;
    }

    public Map getStats() {
        return this.stats;
    }

    public boolean addItem(StatisticalItem item) {
        StatisticalItem curItem;
        if (this.name == DEFAULT_NAME) {
            this.name = item.getValue();
        }
        boolean addedNew = false;
        HashMap<String, StatisticalItem> itemMap = (HashMap<String, StatisticalItem>)this.stats.get(item.getName());
        if (itemMap == null) {
            itemMap = new HashMap<String, StatisticalItem>();
            this.stats.put(item.getName(), itemMap);
            addedNew = true;
        }
        if ((curItem = (StatisticalItem)itemMap.get(item.getValue())) == null) {
            itemMap.put(item.getValue(), item);
        } else {
            curItem.add(item);
        }
        return addedNew;
    }

    public void merge(TxReport txReport) {
        for (Map.Entry entry : txReport.stats.entrySet()) {
            String itemName = (String)entry.getKey();
            Map myMap = (Map)this.stats.get(itemName);
            Map itemMap = (Map)entry.getValue();
            if (myMap == null) {
                this.stats.put(itemName, itemMap);
                continue;
            }
            for (StatisticalItem myItem : myMap.values()) {
                StatisticalItem newItem = (StatisticalItem)itemMap.remove(myItem.getValue());
                if (newItem == null) {
                    myItem.mergeNull();
                    continue;
                }
                myItem.merge(newItem);
            }
            if (itemMap.isEmpty()) continue;
            for (StatisticalItem newItem : itemMap.values()) {
                myMap.put(newItem.getValue(), newItem);
            }
        }
        this.count += txReport.count;
    }

    public static class SqlStats
    extends AbstractStatisticalItem {
        public static final String NAME = "SQL Statistics Per Transaction";

        public SqlStats(String sql) {
            super(NAME);
            this.value = sql;
        }
    }

    public static class MethodStats
    extends AbstractStatisticalItem {
        public static final String NAME = "Method Statistics Per Transaction";

        public MethodStats(String method) {
            super(NAME);
            this.value = method;
        }
    }
}

