/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jmx.adaptor.html;

import java.io.IOException;
import java.lang.reflect.Method;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.security.auth.Subject;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.jboss.logging.Logger;
import org.jboss.security.SimpleGroup;

public class JMXOpsAccessControlFilter
implements Filter {
    private static Logger log = Logger.getLogger(JMXOpsAccessControlFilter.class);
    private boolean trace = log.isTraceEnabled();
    private static final String ACTION_PARAM = "action";
    private static final String DISPLAY_MBEANS_ACTION = "displayMBeans";
    private static final String INSPECT_MBEAN_ACTION = "inspectMBean";
    private static final String UPDATE_ATTRIBUTES_ACTION = "updateAttributes";
    private static final String INVOKE_OP_ACTION = "invokeOp";
    private static final String INVOKE_OP_BY_NAME_ACTION = "invokeOpByName";
    private List updateAttributesRoles = null;
    private List invokeOpRoles = null;
    private List invokeMBeanRoles = null;
    private Object authorizationDelegate = null;

    public void init(FilterConfig filterConfig) throws ServletException {
        String delegateStr;
        String inspectMBeanStr;
        String invokeOpStr;
        String updateAttributesStr = filterConfig.getInitParameter(UPDATE_ATTRIBUTES_ACTION);
        if (updateAttributesStr != null && updateAttributesStr.length() > 0) {
            this.updateAttributesRoles = this.getRoles(updateAttributesStr);
        }
        if ((invokeOpStr = filterConfig.getInitParameter(INVOKE_OP_ACTION)) != null && invokeOpStr.length() > 0) {
            this.invokeOpRoles = this.getRoles(invokeOpStr);
        }
        if ((inspectMBeanStr = filterConfig.getInitParameter(INSPECT_MBEAN_ACTION)) != null && inspectMBeanStr.length() > 0) {
            this.invokeMBeanRoles = this.getRoles(inspectMBeanStr);
        }
        if ((delegateStr = filterConfig.getInitParameter("authorizationDelegate")) != null && delegateStr.length() > 0) {
            this.authorizationDelegate = this.instantiate(delegateStr);
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        boolean passThrough = true;
        String action = request.getParameter(ACTION_PARAM);
        if (action == null) {
            action = DISPLAY_MBEANS_ACTION;
        }
        if (action.equals(UPDATE_ATTRIBUTES_ACTION)) {
            passThrough = this.authorize(request, response, this.updateAttributesRoles);
        } else if (action.equals(INVOKE_OP_ACTION) || action.equals(INVOKE_OP_BY_NAME_ACTION)) {
            passThrough = this.authorize(request, response, this.invokeOpRoles);
        } else if (action.equals(INSPECT_MBEAN_ACTION)) {
            passThrough = this.authorize(request, response, this.invokeMBeanRoles);
        }
        if (!passThrough) {
            ((HttpServletResponse)response).setStatus(403);
        } else {
            chain.doFilter(request, response);
        }
    }

    public void destroy() {
    }

    private boolean authorize(ServletRequest request, ServletResponse response, List listToCheck) {
        String subjectRole;
        if (this.authorizationDelegate != null) {
            return this.checkWithDelegate(request, response, listToCheck);
        }
        if (listToCheck == null || listToCheck.size() == 0) {
            return true;
        }
        ArrayList subjectRoles = this.getSubjectRoles();
        boolean result = false;
        int len = subjectRoles.size();
        for (int i = 0; i < len && !(result = listToCheck.contains(subjectRole = (String)subjectRoles.get(i))); ++i) {
        }
        return result;
    }

    private boolean checkWithDelegate(ServletRequest request, ServletResponse response, List listToCheck) {
        Boolean result;
        block2: {
            result = Boolean.FALSE;
            String name = "authorize";
            Class[] args = new Class[]{ServletRequest.class, ServletResponse.class, List.class};
            try {
                Method meth = this.authorizationDelegate.getClass().getMethod(name, args);
                result = (Boolean)meth.invoke(this.authorizationDelegate, request, response, listToCheck);
            }
            catch (Exception e) {
                if (!this.trace) break block2;
                log.error((Object)"Error invoking AuthorizationDelegate:", (Throwable)e);
            }
        }
        return result;
    }

    private List getRoles(String commaSeperatedRoles) {
        StringTokenizer st = new StringTokenizer(commaSeperatedRoles, ",");
        int numTokens = st.countTokens();
        String[] strArr = new String[numTokens];
        for (int i = 0; i < numTokens; ++i) {
            strArr[i] = st.nextToken();
        }
        return Arrays.asList(strArr);
    }

    private ArrayList getSubjectRoles() {
        ArrayList<String> alist;
        block5: {
            alist = new ArrayList<String>();
            String SUBJECT_CONTEXT_KEY = "javax.security.auth.Subject.container";
            try {
                Subject caller = (Subject)PolicyContext.getContext((String)SUBJECT_CONTEXT_KEY);
                Iterator<Principal> iter = caller.getPrincipals().iterator();
                while (iter != null && iter.hasNext()) {
                    SimpleGroup sg;
                    String name;
                    Principal p = iter.next();
                    if (!(p instanceof SimpleGroup) || !"Roles".equals(name = (sg = (SimpleGroup)p).getName())) continue;
                    Enumeration en = sg.members();
                    while (en.hasMoreElements()) {
                        String role = en.nextElement().toString();
                        if (role == null) continue;
                        alist.add(role);
                    }
                }
            }
            catch (PolicyContextException e) {
                if (!this.trace) break block5;
                log.trace((Object)"Error obtaining authenticated subject:", (Throwable)e);
            }
        }
        if (this.trace) {
            log.trace((Object)("Subject Roles=" + alist));
        }
        return alist;
    }

    public Object instantiate(String delegateStr) {
        Object obj;
        block2: {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            obj = null;
            try {
                Class<?> clazz = cl.loadClass(delegateStr);
                obj = clazz.newInstance();
            }
            catch (Exception e) {
                if (!this.trace) break block2;
                log.error((Object)"Error instantiating AuthorizationDelegate:", (Throwable)e);
            }
        }
        return obj;
    }
}

