/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.varia.deployment;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jboss.deployment.DeploymentException;
import org.jboss.deployment.DeploymentInfo;
import org.jboss.deployment.MainDeployerMBean;
import org.jboss.deployment.SubDeployer;
import org.jboss.deployment.SubDeployerSupport;
import org.jboss.mx.util.MBeanProxyExt;
import org.jboss.system.ServiceControllerMBean;
import org.jboss.system.server.ServerConfig;
import org.jboss.system.server.ServerConfigLocator;
import org.jboss.util.Counter;
import org.jboss.util.file.Files;
import org.jboss.util.file.JarUtils;
import org.jboss.varia.deployment.FoeDeployerMBean;
import org.jboss.varia.deployment.convertor.Convertor;

public class FoeDeployer
extends SubDeployerSupport
implements SubDeployer,
FoeDeployerMBean {
    private ServiceControllerMBean serviceController;
    private File scratchDirectory;
    private List converterList = new ArrayList();
    private final Counter id = Counter.makeSynchronized((Counter)new Counter(0));
    private ThreadLocal destinationByDI = new ThreadLocal(){

        protected Object initialValue() {
            return new HashMap();
        }
    };

    public boolean accepts(DeploymentInfo di) {
        for (Convertor converter : this.converterList) {
            if (!converter.accepts(di.url)) continue;
            return true;
        }
        return false;
    }

    public boolean accepts(URL url) {
        for (Convertor converter : this.converterList) {
            if (!converter.accepts(url)) continue;
            return true;
        }
        return false;
    }

    public void init(DeploymentInfo di) throws DeploymentException {
        Map destinations = (Map)this.destinationByDI.get();
        File destination = (File)destinations.get(di.parent);
        if (destination == null) {
            while (destination == null || destination.exists()) {
                destination = new File(this.scratchDirectory, this.id.increment() + "." + di.shortName);
            }
        } else {
            destination = new File(destination, di.shortName);
        }
        destinations.put(di, destination);
        this.destinationByDI.set(destinations);
        try {
            this.log.debug((Object)("unpacking to " + destination));
            this.inflateJar(di.localUrl, destination);
        }
        catch (Exception e) {
            throw new DeploymentException("Unpacking failed: ", (Throwable)e);
        }
        super.init(di);
    }

    public void create(DeploymentInfo di) throws DeploymentException {
        try {
            File deflateDest;
            Map destinations = (Map)this.destinationByDI.get();
            File inflateDest = (File)destinations.get(di);
            for (Convertor converter : this.converterList) {
                if (!converter.accepts(di.url)) continue;
                converter.convert(di, inflateDest);
                break;
            }
            if ((deflateDest = (File)destinations.get(di.parent)) == null) {
                deflateDest = this.scratchDirectory;
            }
            String validName = null;
            validName = di.shortName.endsWith(".wl") ? di.shortName.substring(0, di.shortName.length() - 3) : di.shortName.substring(0, di.shortName.length() - 4) + "jar";
            File convertedUnit = new File(deflateDest, validName);
            this.log.debug((Object)("deflating to " + convertedUnit));
            this.deflateJar(convertedUnit, inflateDest);
            Files.delete((File)inflateDest);
            if (di.parent == null) {
                this.copyFile(convertedUnit, new File(di.url.getFile()).getParentFile());
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Conversion error: ", (Throwable)e);
        }
    }

    public void start(DeploymentInfo di) throws DeploymentException {
        this.stop(di);
        this.destroy(di);
    }

    public void stop(DeploymentInfo di) {
        this.log.debug((Object)("undeploying application: " + di.url));
    }

    public void destroy(DeploymentInfo di) {
        ObjectName name;
        List services = di.mbeans;
        int lastService = services.size();
        ListIterator i = services.listIterator(lastService);
        while (i.hasPrevious()) {
            name = (ObjectName)i.previous();
            this.log.debug((Object)("destroying mbean " + name));
            try {
                this.serviceController.destroy(name);
            }
            catch (Exception e) {
                this.log.error((Object)("Could not destroy mbean: " + name), (Throwable)e);
            }
        }
        i = services.listIterator(lastService);
        while (i.hasPrevious()) {
            name = (ObjectName)i.previous();
            this.log.debug((Object)("removing mbean " + name));
            try {
                this.serviceController.remove(name);
            }
            catch (Exception e) {
                this.log.error((Object)("Could not remove mbean: " + name), (Throwable)e);
            }
        }
    }

    protected void addDeployableJar(DeploymentInfo di, JarFile jarFile) throws DeploymentException {
        String urlPrefix = "jar:" + di.localUrl.toString() + "!/";
        Enumeration<JarEntry> e = jarFile.entries();
        while (e.hasMoreElements()) {
            JarEntry entry = e.nextElement();
            String name = entry.getName();
            try {
                URL url = new URL(urlPrefix + name);
                if (!this.isDeployable(name, url)) continue;
                URL nestedURL = JarUtils.extractNestedJar((URL)url, (File)this.tempDeployDir);
                File file = new File(nestedURL.getFile());
                File wlFile = new File(nestedURL.getFile() + ".wl");
                file.renameTo(wlFile);
                if (this.accepts(wlFile.toURL())) {
                    this.deployUrl(di, wlFile.toURL(), name + ".wl");
                    continue;
                }
                wlFile.renameTo(new File(nestedURL.getFile()));
            }
            catch (MalformedURLException mue) {
                this.log.warn((Object)("Jar entry invalid; ignoring: " + name), (Throwable)mue);
            }
            catch (IOException ex) {
                this.log.warn((Object)("Failed to extract nested jar; ignoring: " + name), (Throwable)ex);
            }
        }
    }

    protected void startService() throws Exception {
        this.mainDeployer = (MainDeployerMBean)MBeanProxyExt.create(MainDeployerMBean.class, (ObjectName)MainDeployerMBean.OBJECT_NAME, (MBeanServer)this.server);
        this.serviceController = (ServiceControllerMBean)MBeanProxyExt.create(ServiceControllerMBean.class, (ObjectName)ServiceControllerMBean.OBJECT_NAME, (MBeanServer)this.server);
        ServerConfig config = ServerConfigLocator.locate();
        File tempDirectory = config.getServerTempDir();
        this.scratchDirectory = new File(tempDirectory, "foe");
        if (!this.scratchDirectory.exists()) {
            this.scratchDirectory.mkdirs();
        }
        super.startService();
    }

    protected ObjectName getObjectName(MBeanServer server, ObjectName name) throws MalformedObjectNameException {
        return name == null ? OBJECT_NAME : name;
    }

    public void addConvertor(Convertor converter) {
        this.converterList.add(converter);
        Collection waitingDeployments = this.mainDeployer.listWaitingForDeployer();
        if (waitingDeployments != null && waitingDeployments.size() > 0) {
            for (DeploymentInfo di : waitingDeployments) {
                if (!converter.accepts(di.url)) continue;
                this.log.debug((Object)("trying to deploy with new converter: " + di.shortName));
                try {
                    this.mainDeployer.redeploy(di);
                }
                catch (DeploymentException e) {
                    this.log.error((Object)"DeploymentException while trying to deploy a package with new converter", (Throwable)e);
                }
            }
        }
    }

    public void removeConvertor(Convertor converter) {
        this.converterList.remove(converter);
    }

    protected void inflateJar(URL fileURL, File destinationDirectory) throws DeploymentException, IOException {
        File destFile = new File(fileURL.getFile());
        FileInputStream input = new FileInputStream(fileURL.getFile());
        JarUtils.unjar((InputStream)input, (File)destinationDirectory);
    }

    private void deflateJar(File jarFile, File root) throws Exception {
        FileOutputStream output = new FileOutputStream(jarFile);
        JarUtils.jar((OutputStream)output, (File[])root.listFiles(), null, null, null);
        ((OutputStream)output).close();
    }

    private void copyFile(File source, File destinationDirectory) throws Exception {
        File target = new File(destinationDirectory, source.getName());
        Files.copy((File)source, (File)target);
    }
}

