/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools;

import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.net.URL;
import java.security.CodeSource;

public class ClassVersionInfo
implements Serializable {
    static final long serialVersionUID = 2036506209171911437L;
    private long serialVersion;
    private String name;
    private boolean hasExplicitSerialVersionUID;
    private transient URL location;

    public ClassVersionInfo(String name, ClassLoader loader) throws ClassNotFoundException {
        ObjectStreamClass osc;
        this.name = name;
        Class<?> c = loader.loadClass(name);
        CodeSource cs = c.getProtectionDomain().getCodeSource();
        if (cs != null) {
            this.location = cs.getLocation();
        }
        if (!c.isInterface() && (osc = ObjectStreamClass.lookup(c)) != null) {
            this.serialVersion = osc.getSerialVersionUID();
            try {
                c.getDeclaredField("serialVersionUID");
                this.hasExplicitSerialVersionUID = true;
            }
            catch (NoSuchFieldException e) {
                this.hasExplicitSerialVersionUID = false;
            }
        }
    }

    public long getSerialVersion() {
        return this.serialVersion;
    }

    public boolean getHasExplicitSerialVersionUID() {
        return this.hasExplicitSerialVersionUID;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        StringBuffer tmp = new StringBuffer("ClassVersionInfo");
        tmp.append('{');
        tmp.append("serialVersion=");
        tmp.append(this.serialVersion);
        tmp.append(", hasExplicitSerialVersionUID=");
        tmp.append(this.hasExplicitSerialVersionUID);
        tmp.append(", name=");
        tmp.append(this.name);
        tmp.append(", location=");
        tmp.append(this.location);
        tmp.append('}');
        return tmp.toString();
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            throw new IllegalStateException("Usage: ...ClassVersionInfo class-name");
        }
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        ClassVersionInfo info = new ClassVersionInfo(args[0], loader);
        System.out.println(info);
    }
}

