/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.profileservice.repository;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.profileservice.spi.DeploymentRepository;
import org.jboss.profileservice.spi.NoSuchDeploymentException;
import org.jboss.profileservice.spi.ProfileDeployment;
import org.jboss.profileservice.spi.ProfileKey;
import org.jboss.system.server.profileservice.repository.AbstractVFSProfileSource;
import org.jboss.vfs.VirtualFile;

public abstract class AbstractDeploymentRepository
extends AbstractVFSProfileSource
implements DeploymentRepository {
    protected static final int ignoreFlags = 5;
    private ProfileKey key;
    private Map<String, Integer> contentFlags = new ConcurrentHashMap<String, Integer>();

    public AbstractDeploymentRepository(ProfileKey key, URI[] uris) {
        super(uris);
        if (key == null) {
            throw new IllegalArgumentException("Null profile key.");
        }
        this.key = key;
    }

    public ProfileKey getProfileKey() {
        return this.key;
    }

    public void create() throws Exception {
    }

    public void unload() {
        super.destroy();
        this.contentFlags.clear();
    }

    protected boolean acceptsDeployment(String name) {
        if (this.hasDeploymentContentFlags(name, 5)) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Ignoring locked application: " + name));
            }
            return false;
        }
        return super.acceptsDeployment(name);
    }

    public ProfileDeployment removeDeployment(String vfsPath) throws Exception {
        if (vfsPath == null) {
            throw new IllegalArgumentException("Null vfsPath");
        }
        ProfileDeployment deployment = super.removeDeployment(vfsPath);
        return deployment;
    }

    protected void cleanupDeployment(String deploymentName) {
        super.cleanupDeployment(deploymentName);
        this.contentFlags.remove(deploymentName);
    }

    public ProfileDeployment getDeployment(String vfsPath) throws NoSuchDeploymentException {
        if (vfsPath == null) {
            throw new IllegalArgumentException("Null vfsPath");
        }
        ProfileDeployment ctx = super.getDeployment(vfsPath);
        if (ctx == null) {
            List<String> names = this.findDeploymentContent(vfsPath);
            if (names.size() == 1) {
                ctx = super.getDeployment(names.get(0));
            } else if (names.size() > 1) {
                throw new NoSuchDeploymentException("Multiple deployments found for: " + vfsPath + ", available: " + names);
            }
        }
        if (ctx == null) {
            this.log.debug((Object)("Failed to find application for: " + vfsPath + ", available: " + this.getDeploymentNames()));
            throw new NoSuchDeploymentException("Failed to find deployment in file: " + vfsPath);
        }
        return ctx;
    }

    public VirtualFile getDeploymentContent(String name) throws IOException {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        VirtualFile vf = this.getCachedVirtualFile(name);
        if (vf == null) {
            List<String> matchingNames = this.findDeploymentContent(name);
            if (matchingNames.size() == 1) {
                vf = this.getCachedVirtualFile(matchingNames.get(0));
            } else if (matchingNames.size() > 1) {
                throw new FileNotFoundException("Multiple names found for name: " + name + ", profile: " + this.key + ", available: " + matchingNames);
            }
        }
        if (vf == null) {
            throw new FileNotFoundException("Failed to find content in profile: " + this.key + " filename: " + name);
        }
        return vf;
    }

    public String[] getRepositoryNames(String ... names) throws IOException {
        if (names == null) {
            throw new IllegalArgumentException("Null names[]");
        }
        HashSet<String> tmp = new HashSet<String>();
        for (String name : names) {
            if (this.getCachedVirtualFile(name) != null) {
                tmp.add(name);
                continue;
            }
            List<String> deploymentNames = this.findDeploymentContent(name);
            if (deploymentNames == null) continue;
            tmp.addAll(deploymentNames);
        }
        return tmp.toArray(new String[tmp.size()]);
    }

    public int lockDeploymentContent(String vfsPath) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("lockDeploymentContent, " + vfsPath));
        }
        int flag = this.setDeploymentContentFlags(vfsPath, 4);
        this.updateLastModfied();
        return flag;
    }

    public int unlockDeploymentContent(String vfsPath) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("unlockDeploymentContent, " + vfsPath));
        }
        int flag = this.clearDeploymentContentFlags(vfsPath, 4);
        this.updateLastModfied();
        return flag;
    }

    public int getDeploymentContentFlags(String vfsPath) {
        Integer flags = this.contentFlags.get(vfsPath);
        return flags != null ? flags : 0;
    }

    public synchronized int clearDeploymentContentFlags(String vfsPath, int flags) {
        Integer dflags = this.contentFlags.get(vfsPath);
        if (dflags != null) {
            dflags = dflags & ~flags;
            this.contentFlags.put(vfsPath, dflags);
        }
        return dflags != null ? dflags : 0;
    }

    public boolean hasDeploymentContentFlags(String vfsPath, int flag) {
        Integer flags = this.contentFlags.get(vfsPath);
        boolean hasFlag = false;
        if (flags != null) {
            hasFlag = (flags & flag) != 0;
        }
        return hasFlag;
    }

    public int setDeploymentContentFlags(String vfsPath, int flags) {
        this.contentFlags.put(vfsPath, flags);
        return flags;
    }
}

