/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.profileservice.repository.clustered.sync;

import org.jboss.logging.Logger;
import org.jboss.system.server.profileservice.repository.clustered.metadata.RepositoryContentMetadata;
import org.jboss.system.server.profileservice.repository.clustered.metadata.RepositoryItemMetadata;
import org.jboss.system.server.profileservice.repository.clustered.metadata.RepositoryRootMetadata;
import org.jboss.system.server.profileservice.repository.clustered.sync.ContentModification;
import org.jboss.system.server.profileservice.repository.clustered.sync.NoOpSynchronizationAction;
import org.jboss.system.server.profileservice.repository.clustered.sync.SynchronizationActionContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemovalMetadataInsertionAction<T extends SynchronizationActionContext>
extends NoOpSynchronizationAction<T> {
    private static final Logger log = Logger.getLogger(RemovalMetadataInsertionAction.class);
    private RepositoryItemMetadata replaced;

    public RemovalMetadataInsertionAction(T context, ContentModification modification) {
        super(context, modification);
        if (!modification.getItem().isRemoved()) {
            throw new IllegalArgumentException("Item " + modification.getItem() + " is not marked as removed");
        }
    }

    @Override
    protected boolean doPrepare() {
        boolean ok = false;
        ContentModification mod = this.getRepositoryContentModification();
        RepositoryContentMetadata toUpdate = ((SynchronizationActionContext)this.getContext()).getInProgressMetadata();
        RepositoryRootMetadata rmd = toUpdate.getRepositoryRootMetadata(mod.getRootName());
        if (rmd != null) {
            this.replaced = rmd.getItemMetadata(mod.getItem().getRelativePathElements());
            rmd.getContent().add(mod.getItem());
            ok = true;
            if (log.isTraceEnabled()) {
                log.trace((Object)("added removal metadata for " + mod.getItem().getRelativePath()));
            }
        }
        return ok;
    }

    @Override
    protected void doRollbackFromComplete() {
        if (this.replaced != null) {
            ContentModification mod = this.getRepositoryContentModification();
            RepositoryContentMetadata toUpdate = ((SynchronizationActionContext)this.getContext()).getInProgressMetadata();
            RepositoryRootMetadata rmd = toUpdate.getRepositoryRootMetadata(mod.getRootName());
            if (rmd != null) {
                rmd.getContent().add(this.replaced);
            }
        }
    }

    @Override
    protected void doRollbackFromPrepared() {
        ContentModification mod = this.getRepositoryContentModification();
        RepositoryContentMetadata toUpdate = ((SynchronizationActionContext)this.getContext()).getInProgressMetadata();
        RepositoryRootMetadata rmd = toUpdate.getRepositoryRootMetadata(mod.getRootName());
        if (rmd != null) {
            rmd.getContent().remove(mod.getItem());
        }
    }
}

