/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.profileservice.bootstrap;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.jboss.bootstrap.api.as.config.JBossASBasedServerConfig;
import org.jboss.bootstrap.spi.as.JBossASBootstrap;
import org.jboss.bootstrap.spi.as.server.MCJBossASBasedServerProvider;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.spi.deployment.KernelDeployment;
import org.jboss.profileservice.bootstrap.AbstractProfileServiceBootstrap;
import org.jboss.profileservice.config.ProfileServiceConfig;
import org.jboss.profileservice.deployment.hotdeploy.HDScannerFactory;
import org.jboss.profileservice.domain.AbstractDomainMetaData;
import org.jboss.profileservice.domain.ManagementDomainMetaData;
import org.jboss.profileservice.domain.ServerMetaData;
import org.jboss.profileservice.domain.spi.DomainMetaData;
import org.jboss.profileservice.domain.spi.DomainMetaDataFragment;
import org.jboss.profileservice.metadata.ProfilesMetaDataFactory;
import org.jboss.profileservice.profile.metadata.FeatureCapability;
import org.jboss.profileservice.profile.metadata.plugin.EmptyProfileMetaData;
import org.jboss.profileservice.spi.metadata.ProfileMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicProfileServiceBootstrap<K extends MCJBossASBasedServerProvider<K, T>, T extends JBossASBasedServerConfig<T>>
extends AbstractProfileServiceBootstrap
implements JBossASBootstrap<K, T> {
    private static final String DOMAIN_NAME = "default";
    private URL profilesLocation;
    private AbstractDomainMetaData domainMetaData;
    private DomainMetaDataFragment profileFactory;
    private HDScannerFactory hdScannerFactory;
    private Map<String, KernelDeployment> bootstrapDeployments;

    public BasicProfileServiceBootstrap(Kernel kernel, ProfileServiceConfig config) {
        super(kernel, config);
    }

    public DomainMetaDataFragment getProfileFactory() {
        return this.profileFactory;
    }

    public void setProfileFactory(DomainMetaDataFragment profileFactory) {
        this.profileFactory = profileFactory;
    }

    public HDScannerFactory getHdScannerFactory() {
        return this.hdScannerFactory;
    }

    public void setHdScannerFactory(HDScannerFactory hdScannerFactory) {
        this.hdScannerFactory = hdScannerFactory;
    }

    public URL getProfilesLocation() {
        return this.profilesLocation;
    }

    public void setProfilesLocation(URL profilesLocation) {
        this.profilesLocation = profilesLocation;
    }

    public Map<String, KernelDeployment> getBootstrapDeployments() {
        return this.bootstrapDeployments;
    }

    public void start(K server) throws Exception {
        this.domainMetaData = this.createDomainMetaData(((JBossASBasedServerConfig)server.getConfiguration()).getServerName());
        this.bootstrapDeployments = server.getDeployments();
        try {
            this.createProfileService(this.domainMetaData);
            this.populateProfileRepository();
            this.createWorkaroundProfile();
            this.start(this.domainMetaData);
            try {
                this.getConfig().getDeployerRegistry().checkAllComplete();
            }
            catch (Exception e) {
                log.error((Object)"Failed to load profile:", (Throwable)e);
            }
            this.hdScannerFactory.enableScanning();
        }
        catch (Throwable t) {
            log.error((Object)"failed to start server", t);
        }
    }

    public void prepareShutdown(K server) {
        super.prepareShutdown();
        this.hdScannerFactory.disabledScanning();
        this.getConfig().getDeployerRegistry().prepareShutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(K server) {
        try {
            this.stop((DomainMetaData)this.domainMetaData);
        }
        finally {
            this.getConfig().getDeployerRegistry().shutdown();
        }
    }

    protected void createWorkaroundProfile() {
        EmptyProfileMetaData metaData = new EmptyProfileMetaData("workaround");
        ArrayList<FeatureCapability> nodes = new ArrayList<FeatureCapability>();
        nodes.add(new FeatureCapability("urn:jboss:profileservice:boostrap:1.0"));
        nodes.add(new FeatureCapability("urn:jboss:profileservice:profile:farming:1.0"));
        nodes.add(new FeatureCapability("urn:jboss:profileservice:profile:hot-deployment:1.0"));
        metaData.setFeatures(nodes);
        this.getMetaDataRegistry().registerProfileMetaData((ProfileMetaData)metaData);
    }

    protected AbstractDomainMetaData createDomainMetaData(String serverName) {
        AbstractDomainMetaData domain = new AbstractDomainMetaData();
        domain.setDomain(new ManagementDomainMetaData(DOMAIN_NAME));
        domain.setServer(new ServerMetaData(serverName));
        domain.setFragments(Collections.singletonList(this.profileFactory));
        return domain;
    }

    protected void populateProfileRepository() throws Exception {
        if (this.getProfilesLocation() != null) {
            ProfilesMetaDataFactory metadataFactory = new ProfilesMetaDataFactory();
            metadataFactory.parse(this.getProfilesLocation());
            Map profiles = metadataFactory.getProfiles();
            for (ProfileMetaData metaData : profiles.values()) {
                this.getMetaDataRegistry().registerProfileMetaData(metaData);
            }
        }
    }
}

