/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.profileservice.persistence;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.jboss.managed.api.ManagedObject;
import org.jboss.managed.api.ManagedProperty;
import org.jboss.managed.api.factory.ManagedObjectFactory;
import org.jboss.system.server.profileservice.persistence.AttachmentPropertyPopulator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagedObjectRecreationHelper {
    private final ThreadLocal<ClassLoader> loader = new ThreadLocal();
    private final ManagedObjectFactory mangedObjectFactory;
    private final AttachmentPropertyPopulator attachmentPopulator;

    public ManagedObjectRecreationHelper(ManagedObjectFactory mangedObjectFactory) {
        if (mangedObjectFactory == null) {
            throw new IllegalArgumentException("null managed object factory");
        }
        this.mangedObjectFactory = mangedObjectFactory;
        this.attachmentPopulator = new AttachmentPropertyPopulator(mangedObjectFactory, this);
    }

    protected ClassLoader getLoader() {
        return this.loader.get();
    }

    protected void setLoader(ClassLoader loader) {
        this.loader.set(loader);
    }

    protected void setValue(String name, ManagedProperty property, Object attachment) throws Throwable {
        this.attachmentPopulator.processManagedProperty(name, property, attachment);
    }

    protected ManagedObject createManagedObjectSkeleton(String className) throws ClassNotFoundException {
        Class<?> clazz = this.loadClass(className);
        return this.mangedObjectFactory.createManagedObject(clazz);
    }

    protected Class<?> loadClass(String className) throws ClassNotFoundException {
        ClassLoader cl = this.getLoader();
        if (cl == null) {
            cl = SecurityActions.getContextClassLoader();
        }
        return cl.loadClass(className);
    }

    private static final class SecurityActions {
        private SecurityActions() {
        }

        public static ClassLoader getContextClassLoader() {
            if (System.getSecurityManager() == null) {
                return Thread.currentThread().getContextClassLoader();
            }
            return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return Thread.currentThread().getContextClassLoader();
                }
            });
        }
    }
}

