/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.plugins.scanner;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.jboss.deployers.client.spi.Deployment;
import org.jboss.deployers.client.spi.main.MainDeployer;
import org.jboss.deployers.vfs.spi.client.VFSDeployment;
import org.jboss.deployers.vfs.spi.client.VFSDeploymentFactory;
import org.jboss.logging.Logger;
import org.jboss.util.StringPropertyReplacer;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.VirtualFileFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VFSDeploymentScannerImpl
implements Runnable {
    private static final Logger log = Logger.getLogger(VFSDeploymentScannerImpl.class);
    private MainDeployer mainDeployer;
    private VFSDeploymentFactory deploymentFactory = VFSDeploymentFactory.getInstance();
    private VirtualFileFilter filter;
    private ScheduledExecutorService scanExecutor;
    private ScheduledFuture activeScan;
    private URI serverHomeURI;
    private List<URI> uriList = Collections.synchronizedList(new ArrayList());
    private List<VirtualFile> vdfList = Collections.synchronizedList(new ArrayList());
    private boolean doRecursiveSearch = true;
    private long scanPeriod = 5000L;
    private int scanCount;
    private Map<VirtualFile, DeploymentInfo> deployedMap = new ConcurrentHashMap<VirtualFile, DeploymentInfo>();

    public void setMainDeployer(MainDeployer deployer) {
        this.mainDeployer = deployer;
    }

    public VirtualFileFilter getFilterInstance() {
        return this.filter;
    }

    public void setFilterInstance(VirtualFileFilter filter) {
        this.filter = filter;
    }

    public ScheduledExecutorService getScanExecutor() {
        return this.scanExecutor;
    }

    public void setScanExecutor(ScheduledExecutorService scanExecutor) {
        this.scanExecutor = scanExecutor;
    }

    public long getScanPeriod() {
        return this.scanPeriod;
    }

    public void setScanPeriod(long period) {
        this.scanPeriod = period;
    }

    public boolean isScanEnabled() {
        return this.activeScan != null;
    }

    public synchronized int getScanCount() {
        return this.scanCount;
    }

    public synchronized void resetScanCount() {
        this.scanCount = 0;
    }

    public synchronized void setScanEnabled(boolean scanEnabled) {
        if (scanEnabled && this.activeScan == null) {
            this.activeScan = this.scanExecutor.scheduleWithFixedDelay(this, 0L, this.scanPeriod, TimeUnit.MILLISECONDS);
        } else if (!scanEnabled && this.activeScan != null) {
            this.activeScan.cancel(true);
            this.activeScan = null;
        }
    }

    public void setURIs(String listspec) throws URISyntaxException, IOException {
        if (listspec == null) {
            this.uriList.clear();
            return;
        }
        LinkedList<URI> list = new LinkedList<URI>();
        StringTokenizer stok = new StringTokenizer(listspec, ",");
        while (stok.hasMoreTokens()) {
            String urispec = stok.nextToken().trim();
            log.debug((Object)("Adding URI from spec: " + urispec));
            URI uri = this.makeURI(urispec);
            log.debug((Object)("URI: " + uri));
            list.add(uri);
        }
        this.setURIList(list);
    }

    public void setURIList(List<URI> list) throws IOException {
        if (list == null) {
            return;
        }
        this.uriList.clear();
        for (int n = 0; n < list.size(); ++n) {
            URI uri = list.get(n);
            if (uri == null) {
                throw new IllegalArgumentException("list element[" + n + "] is null");
            }
            this.addURI(uri);
        }
        log.debug((Object)("URI list: " + this.uriList));
    }

    public List<URI> getURIList() {
        return new ArrayList<URI>(this.uriList);
    }

    public void setRecursiveSearch(boolean recurse) {
        this.doRecursiveSearch = recurse;
    }

    public boolean getRecursiveSearch() {
        return this.doRecursiveSearch;
    }

    public void addURI(URI uri) throws IOException {
        if (uri == null) {
            throw new NullPointerException("uri argument cannot be null");
        }
        if (this.uriList.add(uri)) {
            log.debug((Object)("Added URI: " + uri));
            VirtualFile vf = VFS.getChild((URI)uri);
            this.vdfList.add(vf);
        }
    }

    public void removeURI(URI uri) throws IOException {
        if (uri == null) {
            throw new NullPointerException("uri argument cannot be null");
        }
        VirtualFile vf = VFS.getChild((URI)uri);
        this.vdfList.remove(vf);
        boolean success = this.uriList.remove(uri);
        if (success) {
            log.debug((Object)("Removed URI: " + uri));
        }
    }

    public boolean hasURI(URI uri) {
        if (uri == null) {
            throw new NullPointerException("uri argument cannot be null");
        }
        return this.uriList.contains(uri);
    }

    public void start() throws Exception {
        this.vdfList.clear();
        for (URI uri : this.uriList) {
            VirtualFile vf = VFS.getChild((URI)uri);
            this.vdfList.add(vf);
        }
        if (this.scanExecutor == null) {
            this.scanExecutor = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

                public Thread newThread(Runnable r) {
                    return new Thread(r, "VFSDeploymentScanner");
                }
            });
        }
        this.activeScan = this.scanExecutor.scheduleWithFixedDelay(this, 0L, this.scanPeriod, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.scan();
        }
        catch (Throwable e) {
            log.warn((Object)"Scan failed", e);
        }
        finally {
            this.incScanCount();
        }
    }

    public void stop() {
        if (this.activeScan != null) {
            this.activeScan.cancel(true);
            this.activeScan = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void scan() throws Exception {
        int i;
        VirtualFile vf3;
        Object vf22;
        if (this.vdfList == null) {
            throw new IllegalStateException("not initialized");
        }
        boolean trace = log.isTraceEnabled();
        log.debug((Object)"Begin deployment scan");
        LinkedList<VirtualFile> toDeployList = new LinkedList<VirtualFile>();
        List<VirtualFile> list = this.vdfList;
        synchronized (list) {
            for (Object vf22 : this.vdfList) {
                if (trace) {
                    log.trace((Object)("Checking file: " + vf22));
                }
                if (vf22.isLeaf()) {
                    toDeployList.add((VirtualFile)vf22);
                    continue;
                }
                this.addDeployments((List<VirtualFile>)toDeployList, (VirtualFile)vf22);
            }
        }
        if (trace) {
            log.trace((Object)("toDeployList: " + toDeployList));
        }
        LinkedList<VirtualFile> toRemoveList = new LinkedList<VirtualFile>();
        LinkedList<VirtualFile> toCheckForUpdateList = new LinkedList<VirtualFile>();
        vf22 = this.deployedMap;
        synchronized (vf22) {
            for (VirtualFile vf3 : this.deployedMap.keySet()) {
                if (toDeployList.contains(vf3)) {
                    toCheckForUpdateList.add(vf3);
                    continue;
                }
                toRemoveList.add(vf3);
            }
        }
        for (VirtualFile vf4 : toRemoveList) {
            this.undeploy(vf4);
        }
        ArrayList<VirtualFile> toUpdateList = new ArrayList<VirtualFile>(toCheckForUpdateList.size());
        for (VirtualFile vf3 : toUpdateList) {
            DeploymentInfo info = this.deployedMap.get(vf3);
            long modified = vf3.getLastModified();
            Long prevLastDeployed = info.lastModified;
            if (prevLastDeployed.compareTo(modified) >= 0) continue;
            info.lastModified = modified;
            if (trace) {
                log.trace((Object)("Re-deploying " + vf3));
            }
            toUpdateList.add(vf3);
        }
        for (i = toUpdateList.size() - 1; i >= 0; --i) {
            vf3 = (VirtualFile)toUpdateList.get(i);
            this.undeploy(vf3);
        }
        for (i = 0; i < toUpdateList.size(); ++i) {
            vf3 = (VirtualFile)toUpdateList.get(i);
            this.deploy(vf3);
        }
        Iterator i2 = toDeployList.iterator();
        while (i2.hasNext()) {
            vf3 = (VirtualFile)i2.next();
            if (!this.deployedMap.containsKey(vf3)) {
                this.deploy(vf3);
            }
            i2.remove();
        }
        log.debug((Object)"End deployment scan");
    }

    protected synchronized void incScanCount() {
        ++this.scanCount;
        this.notifyAll();
    }

    private URI makeURI(String urispec) throws URISyntaxException {
        urispec = StringPropertyReplacer.replaceProperties((String)urispec);
        return this.serverHomeURI.resolve(urispec);
    }

    private void addDeployments(List<VirtualFile> list, VirtualFile root) throws IOException {
        List components = root.getChildren();
        for (VirtualFile vf : components) {
            if (vf.isLeaf()) {
                if (this.filter != null && !this.filter.accepts(vf)) continue;
                list.add(vf);
                continue;
            }
            if (vf.getName().indexOf(46) == -1 && this.doRecursiveSearch) {
                this.addDeployments(list, vf);
                continue;
            }
            list.add(vf);
        }
    }

    private void deploy(VirtualFile vf) {
        log.debug((Object)("Deploying: " + vf));
        VFSDeployment deployment = this.deploymentFactory.createVFSDeployment(vf);
        try {
            this.mainDeployer.addDeployment((Deployment)deployment);
            this.mainDeployer.process();
        }
        catch (Exception e) {
            log.warn((Object)("Failed to deploy: " + vf), (Throwable)e);
            return;
        }
        DeploymentInfo info = new DeploymentInfo((Deployment)deployment, vf.getLastModified());
        if (!this.deployedMap.containsKey(vf)) {
            this.deployedMap.put(vf, info);
        }
    }

    private void undeploy(VirtualFile vf) {
        try {
            log.debug((Object)("Undeploying: " + vf));
            DeploymentInfo info = this.deployedMap.remove(vf);
            this.mainDeployer.removeDeployment(info.deployment);
        }
        catch (Exception e) {
            log.error((Object)("Failed to undeploy: " + vf), (Throwable)e);
        }
    }

    private class DeploymentInfo {
        Deployment deployment;
        long lastModified;

        public DeploymentInfo(Deployment deployment, long lastModified) {
            if (deployment == null) {
                throw new IllegalArgumentException("Null deployment");
            }
            this.deployment = deployment;
            this.lastModified = lastModified;
        }
    }
}

