/*
 * JBoss, Home of Professional Open Source
 * Copyright 2009, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.system.server.profile.repository.metadata;

import java.io.Serializable;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlType;

/**
 * @author Scott.Stark@jboss.org
 * @version $Revision:$
 */
@XmlType(name = "requirementType")
public class RequirementMetaData
   implements Serializable
{
   private static final long serialVersionUID = 1;

   private String name;
   private String filter;
   private boolean multiple;
   private boolean optional;
   private boolean extend;
   private String comment;

   @XmlAttribute
   public String getName()
   {
      return name;
   }
   public void setName(String name)
   {
      this.name = name;
   }
   @XmlAttribute
   public String getFilter()
   {
      return filter;
   }
   public void setFilter(String filter)
   {
      this.filter = filter;
   }
   @XmlAttribute
   public boolean isMultiple()
   {
      return multiple;
   }
   public void setMultiple(boolean multiple)
   {
      this.multiple = multiple;
   }
   @XmlAttribute
   public boolean isOptional()
   {
      return optional;
   }
   public void setOptional(boolean optional)
   {
      this.optional = optional;
   }
   @XmlAttribute
   public boolean isExtend()
   {
      return extend;
   }
   public void setExtend(boolean extend)
   {
      this.extend = extend;
   }
   @XmlAttribute
   public String getComment()
   {
      return comment;
   }
   public void setComment(String comment)
   {
      this.comment = comment;
   }   
}
