/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.profileservice.repository;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.deployers.client.plugins.deployment.AbstractDeployment;
import org.jboss.deployers.client.spi.Deployment;
import org.jboss.deployers.spi.attachments.Attachments;
import org.jboss.deployers.spi.attachments.MutableAttachments;
import org.jboss.deployers.spi.attachments.PredeterminedManagedObjectAttachments;
import org.jboss.deployers.spi.structure.ClassPathEntry;
import org.jboss.deployers.spi.structure.ContextInfo;
import org.jboss.deployers.spi.structure.StructureMetaData;
import org.jboss.deployers.structure.spi.DeploymentContext;
import org.jboss.deployers.structure.spi.main.MainDeployerStructure;
import org.jboss.deployers.vfs.spi.client.VFSDeploymentFactory;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentContext;
import org.jboss.logging.Logger;
import org.jboss.managed.api.ManagedCommon;
import org.jboss.managed.api.ManagedComponent;
import org.jboss.managed.api.ManagedDeployment;
import org.jboss.managed.api.ManagedObject;
import org.jboss.profileservice.spi.ProfileDeployment;
import org.jboss.system.server.profileservice.attachments.AttachmentMetaData;
import org.jboss.system.server.profileservice.attachments.AttachmentStore;
import org.jboss.system.server.profileservice.attachments.DeploymentClassPathMetaData;
import org.jboss.system.server.profileservice.attachments.DeploymentStructureMetaData;
import org.jboss.system.server.profileservice.attachments.LazyPredeterminedManagedObjects;
import org.jboss.system.server.profileservice.attachments.RepositoryAttachmentMetaData;
import org.jboss.system.server.profileservice.attachments.RepositoryAttachmentMetaDataFactory;
import org.jboss.system.server.profileservice.persistence.ManagedObjectPeristenceHandler;
import org.jboss.system.server.profileservice.persistence.ManagedObjectRemoveHandler;
import org.jboss.system.server.profileservice.persistence.xml.PersistedManagedObject;
import org.jboss.system.server.profileservice.repository.AbstractFileAttachmentsSerializer;
import org.jboss.virtual.VirtualFile;
import org.jboss.virtual.VirtualFileFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractAttachmentStore
implements AttachmentStore {
    private final URI attatchmentStoreRoot;
    protected AbstractFileAttachmentsSerializer serializer;
    protected VFSDeploymentFactory deploymentFactory = VFSDeploymentFactory.getInstance();
    protected MainDeployerStructure mainDeployer;
    private VirtualFileFilter metaDataFilter;
    public static final String METADATA_NAME = "metadata";
    private static final ManagedObjectPeristenceHandler handler = new ManagedObjectPeristenceHandler();
    private static final Logger log = Logger.getLogger(AbstractAttachmentStore.class);

    public AbstractAttachmentStore(File root) {
        if (root == null) {
            throw new IllegalArgumentException("Null attachmentStoreDir");
        }
        if (root.exists() && !root.isDirectory()) {
            throw new IllegalArgumentException("AttachmentStoreRoot is not a directory.");
        }
        this.attatchmentStoreRoot = root.toURI();
    }

    @Override
    public URI getAttachmentStoreRoot() {
        return this.attatchmentStoreRoot;
    }

    public VFSDeploymentFactory getDeploymentFactory() {
        return this.deploymentFactory;
    }

    public void setDeploymentFactory(VFSDeploymentFactory deploymentFactory) {
        this.deploymentFactory = deploymentFactory;
    }

    public MainDeployerStructure getMainDeployer() {
        return this.mainDeployer;
    }

    public void setMainDeployer(MainDeployerStructure mainDeployer) {
        this.mainDeployer = mainDeployer;
    }

    public AbstractFileAttachmentsSerializer getSerializer() {
        return this.serializer;
    }

    public void setSerializer(AbstractFileAttachmentsSerializer serializer) {
        this.serializer = serializer;
    }

    public VirtualFileFilter getMetaDataFilter() {
        return this.metaDataFilter;
    }

    public void setMetaDataFilter(VirtualFileFilter metaDataFilter) {
        this.metaDataFilter = metaDataFilter;
    }

    public Deployment createMCDeployment(ProfileDeployment profileDeployment) throws Exception {
        if (profileDeployment.getRoot() == null) {
            return new AbstractDeployment(profileDeployment.getName());
        }
        return this.deploymentFactory.createVFSDeployment(profileDeployment.getRoot());
    }

    @Override
    public Deployment loadDeploymentData(ProfileDeployment profileDeployment) throws Exception {
        RepositoryAttachmentMetaData attachmentMetaData;
        if (profileDeployment == null) {
            throw new IllegalArgumentException("Null profile deployment.");
        }
        boolean trace = log.isTraceEnabled();
        Deployment deployment = this.createMCDeployment(profileDeployment);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Created deployment: " + deployment));
        }
        if (profileDeployment.getRoot() == null) {
            return deployment;
        }
        String deploymentPath = this.createRelativeDeploymentPath(profileDeployment);
        if (trace) {
            log.trace((Object)("trying to load attachment from relative path: " + deploymentPath));
        }
        if ((attachmentMetaData = this.loadAttachmentMetaData(deploymentPath)) == null) {
            log.debug((Object)("No persisted attachment found for deployment " + deployment + " with relative path: " + deploymentPath));
            return deployment;
        }
        log.debug((Object)("Persisted attachment found for deployment " + deployment + " with relative path: " + deploymentPath));
        try {
            if (!this.attachPredeterminedObject(profileDeployment.getRoot(), attachmentMetaData)) {
                log.debug((Object)"Not using the persisted metadata, as the deployment was modified.");
                return deployment;
            }
        }
        catch (IOException e) {
            log.error((Object)("failed to get LastModified date for file, not using persisted metadata: " + profileDeployment.getName()));
            return deployment;
        }
        this.rebuildStructureContext(deployment, "", deploymentPath, attachmentMetaData, trace);
        return deployment;
    }

    protected boolean attachPredeterminedObject(VirtualFile root, RepositoryAttachmentMetaData metaData) throws IOException {
        DeploymentStructureMetaData structure;
        boolean attach = true;
        long lastModified = metaData.getLastModified();
        if (!root.isLeaf() && !root.isArchive() ? !this.checkMetaDataModifications(root, structure = metaData.getDeploymentStructure(), lastModified) : lastModified < root.getLastModified()) {
            return false;
        }
        return attach;
    }

    protected boolean checkMetaDataModifications(VirtualFile root, DeploymentStructureMetaData structure, long lastModified) {
        if (structure == null) {
            return true;
        }
        List<String> metaDataPaths = structure.getMetaDataPaths();
        if (metaDataPaths != null && !metaDataPaths.isEmpty()) {
            for (String path : metaDataPaths) {
                try {
                    List children;
                    VirtualFile vf = root.getChild(path);
                    if (vf == null || (children = vf.getChildren(this.metaDataFilter)) == null || children.isEmpty()) continue;
                    for (VirtualFile child : children) {
                        if (lastModified >= child.getLastModified()) continue;
                        return false;
                    }
                }
                catch (Exception e) {
                    log.debug((Object)"Failed to check deployment modifications, ignoring persisted information.");
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public void removeComponent(ProfileDeployment deployment, ManagedComponent comp) throws Exception {
        if (deployment == null) {
            throw new IllegalArgumentException("Null deployment.");
        }
        if (comp == null) {
            throw new IllegalArgumentException("Null managed component.");
        }
        ManagedObjectRemoveHandler removeHandler = new ManagedObjectRemoveHandler((ManagedCommon)comp);
        this.updateDeployment(deployment, comp, removeHandler);
    }

    @Override
    public void updateDeployment(ProfileDeployment deployment, ManagedComponent comp) throws Exception {
        if (comp == null) {
            return;
        }
        this.updateDeployment(deployment, comp, handler);
    }

    public void updateDeployment(ProfileDeployment deployment, ManagedComponent comp, ManagedObjectPeristenceHandler persistenceHandler) throws Exception {
        if (deployment == null) {
            throw new IllegalArgumentException("Null deployment.");
        }
        if (comp == null) {
            throw new IllegalArgumentException("Null managed component.");
        }
        if (persistenceHandler == null) {
            throw new IllegalArgumentException("Null persistence handler.");
        }
        if (deployment.getRoot() == null) {
            log.debug((Object)("Cannot persist attachments for non VFS based deployment: " + deployment));
            return;
        }
        if (comp == null) {
            throw new IllegalArgumentException("ManagedComponent may not be null.");
        }
        boolean trace = log.isTraceEnabled();
        log.debug((Object)("updating deployment: " + deployment + ", component: " + comp));
        String deploymentPath = this.createRelativeDeploymentPath(deployment);
        RepositoryAttachmentMetaData savedMetaData = this.loadAttachmentMetaData(deploymentPath);
        ManagedDeployment md = comp.getDeployment();
        String currentContextName = "";
        if (md.getParent() != null) {
            while (md.getParent() != null) {
                currentContextName = md.getSimpleName() + "/" + currentContextName;
                md = md.getParent();
            }
            currentContextName = this.fixName(currentContextName);
        }
        RepositoryAttachmentMetaData currentContextMetaData = null;
        if (savedMetaData != null) {
            if (trace) {
                log.trace((Object)("Previous metadata found for deployment: " + deployment));
            }
            if ("".equals(currentContextName)) {
                currentContextMetaData = savedMetaData;
            } else {
                for (RepositoryAttachmentMetaData child : savedMetaData.getChildren()) {
                    if (!child.getDeploymentName().equals(currentContextName)) continue;
                    currentContextMetaData = child;
                }
            }
        } else {
            savedMetaData = RepositoryAttachmentMetaDataFactory.createInstance(md);
            currentContextMetaData = this.createRepositoryMetaData(savedMetaData, currentContextName, md);
        }
        if (currentContextMetaData == null) {
            throw new IllegalStateException("Could not create metadata");
        }
        long lastModified = System.currentTimeMillis();
        ManagedComponent parent = comp;
        while (parent.getParent() != null) {
            parent = parent.getParent();
        }
        ManagedObject managedObject = comp.getDeployment().getManagedObject(parent.getName());
        if (managedObject != null) {
            String attachmentName = managedObject.getAttachmentName();
            AttachmentMetaData attachment = RepositoryAttachmentMetaDataFactory.findAttachment(attachmentName, currentContextMetaData.getAttachments());
            if (attachment == null) {
                attachment = new AttachmentMetaData();
                RepositoryAttachmentMetaDataFactory.addAttachment(currentContextMetaData, attachment);
            }
            attachment.setName(attachmentName);
            attachment.setClassName(managedObject.getAttachment().getClass().getName());
            PersistedManagedObject persistedMO = this.createPersistedMetaData(managedObject, persistenceHandler);
            attachment.setAttachment(persistedMO);
            currentContextMetaData.setLastModified(lastModified);
        }
        this.saveAttachmentMetaData(deploymentPath, savedMetaData);
        savedMetaData.setLastModified(lastModified);
        this.serializer.saveAttachment(this.getMetaDataPathName(deploymentPath), (Object)savedMetaData);
    }

    protected RepositoryAttachmentMetaData createRepositoryMetaData(RepositoryAttachmentMetaData parentMetaData, String childPath, ManagedDeployment parentMd) throws Exception {
        RepositoryAttachmentMetaData childMetaData = null;
        StructureMetaData structure = this.getStructureMetaData(parentMd.getName());
        if (structure == null) {
            throw new IllegalStateException("Could not get the StructureMetaData.");
        }
        List contextInfos = structure.getContexts();
        if (contextInfos == null) {
            throw new IllegalStateException("StructureMetaData has no contexts.");
        }
        RepositoryAttachmentMetaDataFactory.applyStructureContext(parentMetaData, structure.getContext(""));
        for (ContextInfo info : contextInfos) {
            if ("".equals(info.getPath())) continue;
            String childContextName = this.fixName(info.getPath());
            RepositoryAttachmentMetaData newChild = RepositoryAttachmentMetaDataFactory.createInstance();
            newChild.setDeploymentName(childContextName);
            RepositoryAttachmentMetaDataFactory.applyStructureContext(newChild, info);
            RepositoryAttachmentMetaDataFactory.addChild(parentMetaData, newChild);
            if (!childPath.equals(childContextName)) continue;
            childMetaData = newChild;
        }
        if ("".equals(childPath)) {
            childMetaData = parentMetaData;
        }
        return childMetaData;
    }

    private void saveAttachmentMetaData(String deploymentPath, RepositoryAttachmentMetaData metaData) throws Exception {
        boolean trace = log.isTraceEnabled();
        if (metaData.getAttachments() != null && !metaData.getAttachments().isEmpty()) {
            for (AttachmentMetaData attachment : metaData.getAttachments()) {
                if (attachment.getAttachment() == null) continue;
                PersistedManagedObject root = (PersistedManagedObject)attachment.getAttachment();
                String attachmentPath = deploymentPath + attachment.getName();
                this.serializer.saveAttachment(attachmentPath, (Object)root);
                if (!trace) continue;
                log.trace((Object)("Stored attachment to : " + attachmentPath));
            }
        }
        if (metaData.getChildren() != null && !metaData.getChildren().isEmpty()) {
            for (RepositoryAttachmentMetaData child : metaData.getChildren()) {
                String childDeploymentPath = deploymentPath + File.separator + child.getDeploymentName() + File.separator;
                this.saveAttachmentMetaData(childDeploymentPath, child);
            }
        }
    }

    protected PersistedManagedObject createPersistedMetaData(ManagedObject mo, ManagedObjectPeristenceHandler handler) {
        return handler.createPersistenceMetaData(mo);
    }

    protected void rebuildStructureContext(Deployment deployment, String contextName, String deploymentPath, RepositoryAttachmentMetaData attachmentMetaData, boolean trace) {
        boolean isRoot = "".equals(contextName);
        if (trace) {
            log.trace((Object)("Rebuilding StructureMetaData for context: " + contextName));
        }
        DeploymentStructureMetaData structure = attachmentMetaData.getDeploymentStructure();
        List<Object> metaDataPaths = new ArrayList();
        ArrayList<ClassPathEntry> classPath = new ArrayList<ClassPathEntry>();
        if (structure != null) {
            if (structure.getClassPaths() != null) {
                for (DeploymentClassPathMetaData md : structure.getClassPaths()) {
                    classPath.add(VFSDeploymentFactory.createClassPathEntry((String)md.getPath(), (String)md.getSuffixes()));
                }
            }
            if (structure.getMetaDataPaths() != null) {
                metaDataPaths = structure.getMetaDataPaths();
            }
        }
        ContextInfo info = this.deploymentFactory.addContext((PredeterminedManagedObjectAttachments)deployment, contextName, metaDataPaths, classPath);
        if (structure != null) {
            info.setComparatorClassName(structure.getComparatorClass());
            info.setRelativeOrder(structure.getRelatativeOrder());
        }
        if (trace) {
            log.trace((Object)("created ContextInfo: " + info + " for deployment: " + deployment));
        }
        if (attachmentMetaData.getAttachments() != null && !attachmentMetaData.getAttachments().isEmpty()) {
            HashSet<String> availableAttachments = new HashSet<String>();
            for (AttachmentMetaData attachment : attachmentMetaData.getAttachments()) {
                availableAttachments.add(attachment.getClassName());
            }
            MutableAttachments mutable = this.createPredeterminedAttachment(deploymentPath, availableAttachments);
            if (isRoot) {
                deployment.setPredeterminedManagedObjects((Attachments)mutable);
            } else {
                info.setPredeterminedManagedObjects((Attachments)mutable);
            }
            if (trace) {
                log.trace((Object)("Added PredetminedManagedObjects: " + availableAttachments + " to context " + contextName));
            }
        } else if (trace) {
            log.trace((Object)("No PredetminedManagedObjects found for context " + contextName));
        }
        List<RepositoryAttachmentMetaData> children = attachmentMetaData.getChildren();
        if (children != null && !children.isEmpty()) {
            for (RepositoryAttachmentMetaData childMetaData : children) {
                String childContextName = contextName + "/" + childMetaData.getDeploymentName();
                String relativePath = deploymentPath + childMetaData.getDeploymentName() + File.separator;
                if (trace) {
                    log.trace((Object)("Processing child context: " + childContextName));
                }
                this.rebuildStructureContext(deployment, this.fixName(childContextName), relativePath, childMetaData, trace);
            }
        }
    }

    protected String createRelativeDeploymentPath(ProfileDeployment deployment) throws Exception {
        if (deployment == null) {
            throw new IllegalStateException("Null deployment.");
        }
        String pathName = deployment.getRoot().toURI().toString();
        String fileName = deployment.getRoot().getName();
        String hash = HashGenerator.createHash(pathName);
        return fileName + "-" + hash + File.separator;
    }

    protected MutableAttachments createPredeterminedAttachment(String deploymentPath, Set<String> availableAttachments) {
        return new LazyPredeterminedManagedObjects(this.serializer, deploymentPath, availableAttachments);
    }

    protected String getMetaDataPathName(String deploymentPath) {
        return deploymentPath.endsWith(File.separator) ? deploymentPath + METADATA_NAME : deploymentPath + File.separator + METADATA_NAME;
    }

    protected RepositoryAttachmentMetaData loadAttachmentMetaData(String relativeDeploymentPath) {
        String fixedMetadataPath = this.getMetaDataPathName(relativeDeploymentPath);
        try {
            return this.serializer.loadAttachment(fixedMetadataPath, RepositoryAttachmentMetaData.class);
        }
        catch (Exception e) {
            log.error((Object)("Failed to load attachment metadata from relative path: " + relativeDeploymentPath), (Throwable)e);
            return null;
        }
    }

    protected StructureMetaData getStructureMetaData(String vfsDeploymentName) {
        VFSDeploymentContext deploymentContext = this.getDeploymentContext(vfsDeploymentName);
        if (deploymentContext == null) {
            throw new IllegalStateException("Could not find deployment context for name: " + vfsDeploymentName);
        }
        return (StructureMetaData)deploymentContext.getDeploymentUnit().getAttachment(StructureMetaData.class);
    }

    protected VFSDeploymentContext getDeploymentContext(String name) {
        if (this.mainDeployer == null) {
            throw new IllegalStateException("Null main deployer.");
        }
        DeploymentContext deploymentContext = this.mainDeployer.getDeploymentContext(name);
        if (deploymentContext == null || !(deploymentContext instanceof VFSDeploymentContext)) {
            return null;
        }
        return (VFSDeploymentContext)deploymentContext;
    }

    private String fixName(String name) {
        if (name == null) {
            return null;
        }
        if (name.equals("")) {
            return name;
        }
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        if (name.endsWith("/")) {
            name = name.substring(0, name.length() - 1);
        }
        return name;
    }

    private static class HashGenerator {
        private static MessageDigest digest;

        private HashGenerator() {
        }

        public static String createHash(String pathName) throws NoSuchAlgorithmException, MalformedURLException, URISyntaxException {
            byte[] bytez;
            StringBuffer buffer = new StringBuffer();
            Formatter f = new Formatter(buffer);
            for (byte b : bytez = HashGenerator.internalCreateHash(pathName)) {
                f.format("%02x", b);
            }
            return f.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected static byte[] internalCreateHash(String pathName) throws NoSuchAlgorithmException {
            MessageDigest digest = HashGenerator.getDigest();
            try {
                digest.update(pathName.getBytes());
                byte[] byArray = digest.digest();
                return byArray;
            }
            finally {
                digest.reset();
            }
        }

        public static MessageDigest getDigest() throws NoSuchAlgorithmException {
            if (digest == null) {
                digest = MessageDigest.getInstance("MD5");
            }
            return digest;
        }
    }
}

