/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.system.server.profileservice.persistence.deployer;

import java.util.Set;

import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.spi.deployer.helpers.AbstractRealDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.logging.Logger;
import org.jboss.managed.api.ManagedObject;
import org.jboss.managed.api.factory.ManagedObjectFactory;
import org.jboss.metadata.spi.MetaData;
import org.jboss.system.server.profileservice.persistence.ManagedGenericOverrideHandler;
import org.jboss.system.server.profileservice.persistence.xml.PersistedManagedObject;

/**
 * The ProfileService Persistence Deployer. This deployer applies the
 * persisted changes to an attachment.
 * 
 * @author <a href="mailto:emuckenh@redhat.com">Emanuel Muckenhuber</a>
 * @version $Revision: 87161 $
 */
public class ProfileServicePersistenceDeployer extends AbstractRealDeployer
{

   /** The managed prefix. */
   public static final String PERSISTED_ATTACHMENT_PREFIX = "PERISTED";
   
   /** The managed object override handler. */
   private ManagedGenericOverrideHandler overrideHandler = new ManagedGenericOverrideHandler();
   
   /** The managed object factory. */
   private ManagedObjectFactory factory = ManagedObjectFactory.getInstance();
   
   /** The Logger. */
   private static final Logger log = Logger.getLogger(ProfileServicePersistenceDeployer.class);
   
   public ProfileServicePersistenceDeployer()
   {
      super();
      setAllInputs(true);
      setStage(DeploymentStages.PRE_REAL);
   }
   
   public ManagedObjectFactory getManagedObjectFactory()
   {
      return factory;
   }
   
   public void setManagedObjectFactory(ManagedObjectFactory factory)
   {
      this.factory = factory;
   }
   
   @Override
   protected void internalDeploy(DeploymentUnit unit) throws DeploymentException
   {
      // Check all attachments, if they have a managed attachment
      // TODO there might be a better way to do that ? :)
      Set<String> attachments = unit.getTransientManagedObjects().getAttachments().keySet();
      for(String attachment : attachments)
      {
         PersistedManagedObject persistedManagedObject = (PersistedManagedObject) unit.getAttachment(PERSISTED_ATTACHMENT_PREFIX + attachment);
         
         if(persistedManagedObject != null)
         {
            // Get the transient attachment
            Object instance = unit.getTransientManagedObjects().getAttachment(attachment);
            try
            {
               MetaData metaData = unit.getMetaData();
               ManagedObject original = factory.initManagedObject(instance, metaData);
               
               // Update the attachment
               overrideHandler.updateManagedObject(original, persistedManagedObject, instance);
               
               // Override
               unit.addAttachment(attachment, original.getAttachment());
            }
            catch(Throwable e)
            {
               log.debug("Failed to update the persisted attachment information", e);
            }
         }
      }
   }

}
