/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */ 
package org.jboss.system.server.profileservice.persistence;

import org.jboss.managed.api.ManagedCommon;
import org.jboss.managed.api.ManagedObject;
import org.jboss.system.server.profileservice.persistence.xml.ModificationInfo;
import org.jboss.system.server.profileservice.persistence.xml.PersistedManagedObject;

/**
 * 
 * @author <a href="mailto:emuckenh@redhat.com">Emanuel Muckenhuber</a>
 * @version $Revision$
 */
public class ManagedObjectRemoveHandler extends ManagedObjectPeristenceHandler
{

   /** The item to remove. */
   private ManagedCommon removeItem = null;
   
   private ManagedObjectPersistencePlugin plugin;
   
   public ManagedObjectRemoveHandler(ManagedCommon removeItem)
   {
      super();
      if(removeItem == null)
         throw new IllegalArgumentException("Null component to remove.");
      this.removeItem = removeItem;
      this.plugin = new DelegatingPersistencePlugin(new RemovePlugin());
   }

   @Override
   protected ManagedObjectPersistencePlugin getPlugin()
   {
      return this.plugin;
   }

   public class RemovePlugin extends DefaultManagedObjectPlugin
   {
      
      @Override
      public PersistedManagedObject createPersistedManagedObject(PersistedManagedObject persisted, ManagedObject mo)
      {
         if(mo != null)
         {
            if(mo.getName() == removeItem.getName())
            {
               persisted.setModificationInfo(ModificationInfo.REMOVED);
               return persisted;
            }
            else
            {
               return super.createPersistedManagedObject(persisted, mo);
            }
         }
         else
         {
            return super.createPersistedManagedObject(persisted, mo);
         }
      }

      @Override
      public String getType()
      {
         return null;
      }      
   }
   
}
