/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.profileservice.repository;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.profileservice.spi.ProfileKey;
import org.jboss.profileservice.spi.metadata.ProfileMetaData;
import org.jboss.profileservice.spi.metadata.ProfileSourceMetaData;
import org.jboss.profileservice.spi.metadata.SubProfileMetaData;
import org.jboss.system.server.profile.repository.metadata.AbstractProfileSourceMetaData;
import org.jboss.system.server.profile.repository.metadata.BasicProfileMetaData;
import org.jboss.system.server.profile.repository.metadata.BasicSubProfileMetaData;
import org.jboss.system.server.profile.repository.metadata.HotDeploymentProfileSourceMetaData;
import org.jboss.system.server.profile.repository.metadata.ImmutableProfileSourceMetaData;
import org.jboss.system.server.profileservice.repository.AbstractBootstrapProfileFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StaticProfileFactory
extends AbstractBootstrapProfileFactory {
    private String bootstrapName = "bootstrap";
    private String deployersName = "deployers";
    private String applicationsName = "applications";
    private URI bootstrapURI;
    private URI deployersURI;
    private File attachmentStoreRoot;
    private List<URI> applicationURIs;

    public String getBootstrapName() {
        return this.bootstrapName;
    }

    public void setBootstrapName(String bootstrapName) {
        this.bootstrapName = bootstrapName;
    }

    public String getDeployersName() {
        return this.deployersName;
    }

    public void setDeployersName(String deployersName) {
        this.deployersName = deployersName;
    }

    public String getApplicationsName() {
        return this.applicationsName;
    }

    public void setApplicationsName(String applicationsName) {
        this.applicationsName = applicationsName;
    }

    public URI getBootstrapURI() {
        return this.bootstrapURI;
    }

    public void setBootstrapURI(URI bootstrapURI) {
        this.bootstrapURI = bootstrapURI;
    }

    public URI getDeployersURI() {
        return this.deployersURI;
    }

    public void setDeployersURI(URI deployersURI) {
        this.deployersURI = deployersURI;
    }

    public File getAttachmentStoreRoot() {
        return this.attachmentStoreRoot;
    }

    public void setAttachmentStoreRoot(File attachmentStoreRoot) {
        this.attachmentStoreRoot = attachmentStoreRoot;
    }

    public List<URI> getApplicationURIs() {
        if (this.applicationURIs == null) {
            return Collections.emptyList();
        }
        return this.applicationURIs;
    }

    public void setApplicationURIs(List<URI> applicationURIs) {
        this.applicationURIs = applicationURIs;
    }

    public void create() throws Exception {
        if (this.bootstrapURI == null) {
            throw new IllegalStateException("Null bootstrap uri.");
        }
        if (this.deployersURI == null) {
            throw new IllegalStateException("Null deployers uri.");
        }
        if (this.applicationURIs == null) {
            throw new IllegalStateException("Null application uris.");
        }
    }

    @Override
    protected void createProfileMetaData(ProfileKey rootKey, URL url) throws Exception {
        if (rootKey == null) {
            throw new IllegalArgumentException("Null root profile key.");
        }
        ProfileKey bootstrapKey = new ProfileKey(this.bootstrapName);
        ProfileMetaData bootstrap = this.createProfileMetaData(this.bootstrapName, false, new URI[]{this.bootstrapURI}, new String[0]);
        this.addProfile(bootstrapKey, bootstrap);
        ProfileKey deployersKey = new ProfileKey(this.deployersName);
        ProfileMetaData deployers = this.createProfileMetaData(this.deployersName, false, new URI[]{this.deployersURI}, new String[]{this.bootstrapName});
        this.addProfile(deployersKey, deployers);
        ProfileKey applicationsKey = new ProfileKey(this.applicationsName);
        URI[] applicationURIs = this.getApplicationURIs().toArray(new URI[this.getApplicationURIs().size()]);
        String[] applicationsSubProfiles = new String[]{this.bootstrapName, this.deployersName};
        ProfileMetaData applications = this.createProfileMetaData(this.applicationsName, true, applicationURIs, applicationsSubProfiles);
        this.addProfile(applicationsKey, applications);
        String[] rootSubProfiles = new String[]{this.applicationsName};
        ProfileMetaData root = this.createProfileMetaData(rootKey.getName(), false, new URI[0], rootSubProfiles);
        this.addProfile(rootKey, root);
    }

    protected ProfileMetaData createProfileMetaData(String name, boolean hotDeployment, URI[] uris, String[] subProfiles) {
        BasicProfileMetaData metaData = new BasicProfileMetaData();
        metaData.setName(name);
        ProfileSourceMetaData source = this.createSource(uris, hotDeployment);
        metaData.setSource(source);
        ArrayList<SubProfileMetaData> profileList = new ArrayList<SubProfileMetaData>();
        for (String subProfile : subProfiles) {
            BasicSubProfileMetaData md = new BasicSubProfileMetaData();
            md.setName(subProfile);
            profileList.add(md);
        }
        metaData.setSubprofiles(profileList);
        return metaData;
    }

    protected ProfileSourceMetaData createSource(URI[] uris, boolean hotDeployment) {
        AbstractProfileSourceMetaData source = null;
        source = hotDeployment ? new HotDeploymentProfileSourceMetaData() : new ImmutableProfileSourceMetaData();
        ArrayList<String> sources = new ArrayList<String>();
        for (URI uri : uris) {
            sources.add(uri.toString());
        }
        source.setSources(sources);
        return source;
    }
}

