/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.profileservice.repository;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SyncFailedException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jboss.deployers.vfs.spi.structure.modified.StructureModificationChecker;
import org.jboss.profileservice.spi.ModificationInfo;
import org.jboss.profileservice.spi.ProfileDeployment;
import org.jboss.profileservice.spi.ProfileKey;
import org.jboss.system.server.profileservice.repository.AbstractDeploymentRepository;
import org.jboss.virtual.VFS;
import org.jboss.virtual.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MutableDeploymentRepository
extends AbstractDeploymentRepository {
    private boolean failIfAlreadyExists = false;
    private StructureModificationChecker checker;
    private ReentrantReadWriteLock contentLock = new ReentrantReadWriteLock(true);

    public MutableDeploymentRepository(ProfileKey key, URI[] uris) {
        super(key, uris);
    }

    protected StructureModificationChecker getChecker() {
        if (this.checker == null) {
            throw new IllegalArgumentException("Checker must be set");
        }
        return this.checker;
    }

    public void setChecker(StructureModificationChecker checker) {
        this.checker = checker;
    }

    public void load() throws Exception {
        for (URI uri : this.getRepositoryURIs()) {
            VirtualFile root = this.getCachedVirtualFile(uri);
            this.loadApplications(root);
        }
        this.updateLastModfied();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String addDeploymentContent(String vfsPath, InputStream contentIS) throws IOException {
        boolean trace = this.log.isTraceEnabled();
        if (trace) {
            this.log.trace((Object)"Aquiring content write lock");
        }
        this.contentLock.writeLock().lock();
        String repositoryName = null;
        try {
            if (this.getRepositoryURIs().length == 0) {
                throw new IllegalStateException("No uris associated with this repository.");
            }
            File contentRoot = new File(this.getRepositoryURIs()[0]);
            if (contentRoot == null) {
                throw new FileNotFoundException("Failed to obtain content dir for phase: " + vfsPath);
            }
            File contentFile = new File(contentRoot, vfsPath);
            if (this.failIfAlreadyExists && contentFile.exists()) {
                throw new SyncFailedException("Deployment content already exists: " + contentFile.getAbsolutePath());
            }
            FileOutputStream fos = new FileOutputStream(contentFile);
            try {
                int read;
                byte[] tmp = new byte[4096];
                while ((read = contentIS.read(tmp)) > 0) {
                    if (trace) {
                        this.log.trace((Object)("write, " + read));
                    }
                    fos.write(tmp, 0, read);
                }
                fos.flush();
                VirtualFile contentVF = VFS.getRoot((URI)contentFile.toURI());
                try {
                    contentVF = this.getCachedVirtualFile(contentVF.toURI());
                    repositoryName = contentVF.toURI().toString();
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException(e);
                }
            }
            finally {
                try {
                    fos.close();
                }
                catch (IOException ignored) {}
            }
            this.lockDeploymentContent(repositoryName);
        }
        finally {
            this.contentLock.writeLock().unlock();
            if (trace) {
                this.log.trace((Object)"Released content write lock");
            }
        }
        return repositoryName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Collection<ModificationInfo> getModifiedDeployments() throws Exception {
        ArrayList<ModificationInfo> modified = new ArrayList<ModificationInfo>();
        Collection<ProfileDeployment> apps = this.getDeployments();
        boolean trace = this.log.isTraceEnabled();
        if (trace) {
            this.log.trace((Object)"Checking applications for modifications");
        }
        if (trace) {
            this.log.trace((Object)"Aquiring content read lock");
        }
        this.contentLock.readLock().lock();
        try {
            if (apps != null) {
                Iterator<ProfileDeployment> iter = apps.iterator();
                while (iter.hasNext()) {
                    ModificationInfo info;
                    long rootLastModified;
                    ProfileDeployment ctx = iter.next();
                    VirtualFile root = ctx.getRoot();
                    String pathName = ctx.getName();
                    if (this.hasDeploymentContentFlags(pathName, 5)) {
                        if (!trace) continue;
                        this.log.trace((Object)("Ignoring locked application: " + root));
                        continue;
                    }
                    if (!root.exists()) {
                        rootLastModified = root.getLastModified();
                        info = new ModificationInfo(ctx, rootLastModified, ModificationInfo.ModifyStatus.REMOVED);
                        modified.add(info);
                        iter.remove();
                        this.getChecker().removeStructureRoot(root);
                        if (!trace) continue;
                        this.log.trace((Object)(pathName + " was removed"));
                        continue;
                    }
                    if (!this.getChecker().hasStructureBeenModified(root) && !this.hasDeploymentContentFlags(pathName, 8)) continue;
                    rootLastModified = root.getLastModified();
                    if (trace) {
                        this.log.trace((Object)(pathName + " was modified: " + rootLastModified));
                    }
                    info = new ModificationInfo(ctx, rootLastModified, ModificationInfo.ModifyStatus.MODIFIED);
                    modified.add(info);
                }
                for (URI applicationDir : this.getRepositoryURIs()) {
                    VirtualFile deployDir = this.getCachedVirtualFile(applicationDir);
                    ArrayList<VirtualFile> added = new ArrayList<VirtualFile>();
                    this.addedDeployments(added, deployDir);
                    for (VirtualFile vf : added) {
                        ProfileDeployment ctx = this.createDeployment(vf);
                        ModificationInfo info = new ModificationInfo(ctx, vf.getLastModified(), ModificationInfo.ModifyStatus.ADDED);
                        modified.add(info);
                        this.addDeployment(ctx.getName(), ctx);
                        this.getChecker().addStructureRoot(vf);
                    }
                }
            }
        }
        finally {
            this.contentLock.readLock().unlock();
            if (trace) {
                this.log.trace((Object)"Released content read lock");
            }
        }
        if (modified.size() > 0) {
            this.updateLastModfied();
        }
        return modified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProfileDeployment removeDeployment(String vfsPath) throws Exception {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)"Aquiring content write lock");
        }
        this.contentLock.writeLock().lock();
        try {
            ProfileDeployment deployment = this.getDeployment(vfsPath);
            VirtualFile root = deployment.getRoot();
            if (!root.delete()) {
                throw new IOException("Failed to delete: " + root);
            }
            ProfileDeployment profileDeployment = super.removeDeployment(deployment.getName());
            return profileDeployment;
        }
        finally {
            this.contentLock.writeLock().unlock();
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)"Released content write lock");
            }
        }
    }

    public void remove() throws Exception {
    }
}

