/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.profileservice.repository;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jboss.dependency.plugins.AbstractController;
import org.jboss.dependency.spi.Controller;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerContextActions;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.dependency.spi.ControllerStateModel;
import org.jboss.dependency.spi.DependencyInfo;
import org.jboss.dependency.spi.DependencyItem;
import org.jboss.deployers.spi.management.ManagementView;
import org.jboss.deployers.spi.management.deploy.DeploymentManager;
import org.jboss.logging.Logger;
import org.jboss.profileservice.spi.NoSuchProfileException;
import org.jboss.profileservice.spi.Profile;
import org.jboss.profileservice.spi.ProfileKey;
import org.jboss.profileservice.spi.ProfileService;
import org.jboss.profileservice.spi.metadata.ProfileMetaData;
import org.jboss.system.server.profileservice.repository.AbstractProfileAction;
import org.jboss.system.server.profileservice.repository.MainDeployerAdapter;
import org.jboss.system.server.profileservice.repository.ProfileContext;
import org.jboss.system.server.profileservice.repository.ProfileCreateAction;
import org.jboss.system.server.profileservice.repository.ProfileDeployAction;
import org.jboss.system.server.profileservice.repository.ProfileStartAction;
import org.jboss.system.server.profileservice.repository.ScopedProfileServiceController;
import org.jboss.util.JBossStringBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractProfileService
implements ProfileService,
ControllerContextActions {
    private ProfileKey defaultProfile;
    private Map<ProfileKey, ProfileContext> registeredProfiles = new ConcurrentHashMap<ProfileKey, ProfileContext>();
    private List<ProfileKey> activeProfiles = new CopyOnWriteArrayList<ProfileKey>();
    private DeploymentManager deploymentManager;
    private ManagementView managementView;
    private MainDeployerAdapter deployer;
    private Controller controller;
    public static final ControllerState DEPLOY_STATE = new ControllerState("Deploy");
    private Map<ControllerState, AbstractProfileAction> profileActions = new HashMap<ControllerState, AbstractProfileAction>();
    private static final Logger log = Logger.getLogger(AbstractProfileService.class);

    public AbstractProfileService(AbstractController controller) {
        if (controller == null) {
            throw new IllegalArgumentException("Null controller.");
        }
        this.controller = new ScopedProfileServiceController(controller);
    }

    public ProfileKey getDefaultProfile() {
        return this.defaultProfile;
    }

    public void setDefaultProfile(ProfileKey defaultProfile) {
        this.defaultProfile = defaultProfile;
    }

    public MainDeployerAdapter getDeployer() {
        return this.deployer;
    }

    public void setDeployer(MainDeployerAdapter deployer) {
        this.deployer = deployer;
    }

    public DeploymentManager getDeploymentManager() {
        return this.deploymentManager;
    }

    public void setDeploymentManager(DeploymentManager deploymentManager) {
        this.deploymentManager = deploymentManager;
    }

    public ManagementView getViewManager() {
        return this.managementView;
    }

    public void setViewManager(ManagementView managementView) {
        this.managementView = managementView;
    }

    public String[] getDomains() {
        ArrayList<String> domains = new ArrayList<String>();
        for (ProfileKey key : this.activeProfiles) {
            domains.add(key.getDomain());
        }
        return domains.toArray(new String[domains.size()]);
    }

    public String[] getProfileDeploymentNames(ProfileKey key) throws NoSuchProfileException {
        Profile profile = this.getActiveProfile(key);
        Set deploymentNames = profile.getDeploymentNames();
        return deploymentNames.toArray(new String[deploymentNames.size()]);
    }

    public Collection<ProfileKey> getProfileKeys() {
        return new ArrayList<ProfileKey>(this.registeredProfiles.keySet());
    }

    public Profile getProfile(ProfileKey key) throws NoSuchProfileException {
        if (key == null) {
            throw new IllegalArgumentException("Null profile key.");
        }
        ProfileContext profile = this.registeredProfiles.get(key);
        if (profile == null) {
            throw new NoSuchProfileException("No such profile: " + key);
        }
        return profile.getProfile();
    }

    public Collection<ProfileKey> getActiveProfileKeys() {
        return Collections.unmodifiableCollection(this.activeProfiles);
    }

    public Profile getActiveProfile(ProfileKey key) throws NoSuchProfileException {
        if (key == null) {
            throw new IllegalArgumentException("Null profile key.");
        }
        ProfileContext profile = null;
        if (this.activeProfiles.contains(key)) {
            profile = (ProfileContext)this.controller.getInstalledContext((Object)key);
        }
        if (key.isDefaultKey() && this.defaultProfile != null) {
            profile = (ProfileContext)this.controller.getInstalledContext((Object)this.defaultProfile);
        }
        if (profile == null) {
            throw new NoSuchProfileException("Profile not installed: " + key);
        }
        return profile.getProfile();
    }

    public void create() throws Exception {
        if (this.controller == null) {
            throw new IllegalStateException("Null controller.");
        }
        if (this.deployer == null) {
            throw new IllegalStateException("Null main deployer.");
        }
        this.profileActions.put(ControllerState.CREATE, new ProfileCreateAction());
        this.profileActions.put(ControllerState.START, new ProfileStartAction());
        this.profileActions.put(DEPLOY_STATE, new ProfileDeployAction(this.deployer));
        this.profileActions.put(ControllerState.INSTALLED, new ProfileInstallAction());
    }

    public void destroy() {
        this.profileActions.clear();
    }

    public ProfileKey createProfile(ProfileMetaData metaData) throws Exception {
        if (metaData == null) {
            throw new IllegalArgumentException("Null meta data");
        }
        throw new IllegalStateException("NYI");
    }

    public void registerProfile(Profile profile) throws Exception {
        if (profile == null) {
            throw new IllegalArgumentException("Null profile.");
        }
        ProfileKey key = profile.getKey();
        if (key == null) {
            throw new IllegalArgumentException("Null profile key.");
        }
        if (this.registeredProfiles.get(profile.getKey()) != null) {
            return;
        }
        if (this.controller.isShutdown()) {
            throw new IllegalStateException("Controller is shutdown.");
        }
        log.debug((Object)("registering profile: " + profile));
        ProfileContext context = new ProfileContext(profile, this);
        try {
            this.controller.install((ControllerContext)context);
            this.registeredProfiles.put(key, context);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public void activateProfile(ProfileKey key) throws Exception {
        if (key == null) {
            throw new IllegalArgumentException("Null profile key.");
        }
        if (this.controller.isShutdown()) {
            throw new IllegalStateException("Controller is shutdown.");
        }
        if (this.activeProfiles.contains(key)) {
            return;
        }
        ProfileContext context = this.registeredProfiles.get(key);
        if (context == null) {
            throw new NoSuchProfileException("No such profile: " + key);
        }
        try {
            log.debug((Object)("Activating profile: " + context.getProfile()));
            this.controller.change((ControllerContext)context, ControllerState.INSTALLED);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        this.validate((ControllerContext)context);
    }

    public void validateProfile(ProfileKey key) throws Exception {
        ProfileContext profile = this.registeredProfiles.get(key);
        if (profile == null) {
            throw new NoSuchProfileException("No such profile registered: " + key);
        }
        this.validate((ControllerContext)profile);
    }

    protected void validate(ControllerContext context) throws Exception {
        HashSet<String> errors = new HashSet<String>();
        HashMap<Object, String> map = new HashMap<Object, String>();
        this.internalValidateContext(context, errors, map);
        this.logErrors(errors, map.values());
    }

    public void install(ControllerContext context, ControllerState fromState, ControllerState toState) throws Throwable {
        if (!(context instanceof ProfileContext)) {
            return;
        }
        AbstractProfileAction action = this.profileActions.get(toState);
        if (action != null) {
            action.install((ProfileContext)context);
        }
    }

    public void uninstall(ControllerContext context, ControllerState fromState, ControllerState toState) {
        if (!(context instanceof ProfileContext)) {
            return;
        }
        AbstractProfileAction action = this.profileActions.get(fromState);
        if (action != null) {
            action.uninstall((ProfileContext)context);
        }
    }

    public void deactivateProfile(ProfileKey key) throws NoSuchProfileException {
        if (key == null) {
            throw new IllegalArgumentException("Null profile key.");
        }
        if (!this.activeProfiles.contains(key)) {
            throw new NoSuchProfileException("No active profile for: " + key);
        }
        if (this.controller.isShutdown()) {
            return;
        }
        ControllerContext context = this.controller.getContext((Object)key, ControllerState.INSTALLED);
        if (context == null) {
            throw new IllegalStateException("Profile not installed: " + key);
        }
        try {
            log.debug((Object)("deactivating profile: " + key));
            this.controller.change(context, ControllerState.NOT_INSTALLED);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public void unregisterProfile(ProfileKey key) throws NoSuchProfileException {
        if (key == null) {
            throw new IllegalArgumentException("Null profile key.");
        }
        if (this.activeProfiles.contains(key)) {
            throw new IllegalStateException("Cannot unregister active profile: " + key);
        }
        if (!this.registeredProfiles.containsKey(key)) {
            throw new NoSuchProfileException("Profile not registered: " + key);
        }
        log.debug((Object)("unregistering profile: " + key));
        this.registeredProfiles.remove(key);
        if (this.controller.isShutdown()) {
            return;
        }
        this.controller.uninstall((Object)key);
    }

    public void unregisterProfile(Profile profile) throws NoSuchProfileException {
        if (profile == null) {
            throw new IllegalArgumentException("Null profile.");
        }
        this.unregisterProfile(profile.getKey());
    }

    protected void internalValidateContext(ControllerContext ctx, Set<String> errors, Map<Object, String> incomplete) {
        if (ctx.getState().equals((Object)ControllerState.ERROR)) {
            JBossStringBuilder builder = new JBossStringBuilder();
            builder.append("Profile: ").append(ctx.getName());
            builder.append(" in error due to ").append(ctx.getError().toString());
            errors.add(builder.toString());
        } else {
            Object name = ctx.getName();
            if (incomplete.containsKey(name)) {
                return;
            }
            DependencyInfo dependsInfo = ctx.getDependencyInfo();
            Set depends = dependsInfo.getIDependOn(null);
            for (DependencyItem item : depends) {
                ControllerStateModel states;
                ControllerState dependentState = item.getDependentState();
                if (dependentState == null) {
                    dependentState = ControllerState.INSTALLED;
                }
                ControllerState otherState = null;
                ControllerContext other = null;
                Object iDependOn = item.getIDependOn();
                if (name.equals(iDependOn)) continue;
                if (iDependOn != null && (other = this.controller.getContext(iDependOn, null)) != null) {
                    otherState = other.getState();
                }
                boolean print = true;
                if (otherState != null && !otherState.equals((Object)ControllerState.ERROR) && !(states = this.controller.getStates()).isBeforeState(otherState, dependentState)) {
                    print = false;
                }
                if (!print) continue;
                JBossStringBuilder buffer = new JBossStringBuilder();
                buffer.append(name).append(" is missing following dependencies: ");
                buffer.append(iDependOn).append('{').append(dependentState.getStateString());
                buffer.append(':');
                if (iDependOn == null) {
                    buffer.append("** UNRESOLVED " + item.toHumanReadableString() + " **");
                } else if (other == null) {
                    buffer.append("** NOT FOUND **");
                } else {
                    buffer.append(otherState.getStateString());
                }
                buffer.append('}');
                incomplete.put(name, buffer.toString());
                if (other == null || incomplete.containsKey(other)) continue;
                this.internalValidateContext(other, errors, incomplete);
            }
        }
    }

    protected void logErrors(Set<String> errors, Collection<String> incomplete) throws Exception {
        if (errors.isEmpty() && incomplete.isEmpty()) {
            return;
        }
        JBossStringBuilder buffer = new JBossStringBuilder();
        buffer.append("Incompletely deployed:\n");
        if (errors.size() != 0) {
            buffer.append("\n*** PROFILES IN ERROR: Name -> Error\n");
            for (String error : errors) {
                buffer.append(error).append('\n');
            }
        }
        if (incomplete.size() != 0) {
            buffer.append("\n*** PROFILES MISSING DEPENDENCIES: Name -> Dependency{Required State:Actual State}\n");
            for (String missing : incomplete) {
                buffer.append(missing).append('\n');
            }
        }
        throw new IllegalStateException(buffer.toString());
    }

    private class ProfileInstallAction
    extends AbstractProfileAction {
        private ProfileInstallAction() {
        }

        public void install(Profile profile) throws Exception {
            AbstractProfileService.this.activeProfiles.add(0, profile.getKey());
        }

        public void uninstall(Profile profile) {
            AbstractProfileService.this.activeProfiles.remove(profile.getKey());
        }
    }
}

