/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.profileservice.persistence;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jboss.beans.info.spi.PropertyInfo;
import org.jboss.logging.Logger;
import org.jboss.managed.api.ManagedObject;
import org.jboss.managed.api.ManagedProperty;
import org.jboss.managed.api.annotation.ViewUse;
import org.jboss.metatype.api.types.ArrayMetaType;
import org.jboss.metatype.api.types.CompositeMetaType;
import org.jboss.metatype.api.types.MetaType;
import org.jboss.metatype.api.values.ArrayValue;
import org.jboss.metatype.api.values.CollectionValue;
import org.jboss.metatype.api.values.CompositeValue;
import org.jboss.metatype.api.values.EnumValue;
import org.jboss.metatype.api.values.GenericValue;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.metatype.api.values.MetaValueFactory;
import org.jboss.metatype.api.values.PropertiesMetaValue;
import org.jboss.metatype.api.values.SimpleValue;
import org.jboss.metatype.api.values.TableValue;
import org.jboss.system.server.profileservice.persistence.xml.ModificationInfo;
import org.jboss.system.server.profileservice.persistence.xml.NullValue;
import org.jboss.system.server.profileservice.persistence.xml.PersistedArrayValue;
import org.jboss.system.server.profileservice.persistence.xml.PersistedCollectionValue;
import org.jboss.system.server.profileservice.persistence.xml.PersistedCompositeValue;
import org.jboss.system.server.profileservice.persistence.xml.PersistedEnumValue;
import org.jboss.system.server.profileservice.persistence.xml.PersistedGenericValue;
import org.jboss.system.server.profileservice.persistence.xml.PersistedManagedObject;
import org.jboss.system.server.profileservice.persistence.xml.PersistedPair;
import org.jboss.system.server.profileservice.persistence.xml.PersistedPropertiesValue;
import org.jboss.system.server.profileservice.persistence.xml.PersistedProperty;
import org.jboss.system.server.profileservice.persistence.xml.PersistedSimpleValue;
import org.jboss.system.server.profileservice.persistence.xml.PersistedTableValue;
import org.jboss.system.server.profileservice.persistence.xml.PersistedValue;

public class ManagedObjectPeristenceHandler {
    private MetaValueFactory metaValueFactory = MetaValueFactory.getInstance();
    private static final Logger log = Logger.getLogger(ManagedObjectPeristenceHandler.class);

    public PersistedManagedObject createPersistenceMetaData(ManagedObject mo) {
        if (mo == null) {
            throw new IllegalArgumentException("Null managedObject.");
        }
        PersistedManagedObject moElement = new PersistedManagedObject();
        this.processManagedObject(moElement, mo);
        return moElement;
    }

    public void processManagedObject(PersistedManagedObject moElement, ManagedObject mo) {
        Class<?> attachment;
        if (moElement == null) {
            throw new IllegalArgumentException("Null rootElement.");
        }
        if (mo == null) {
            throw new IllegalArgumentException("null managedObject");
        }
        boolean trace = log.isTraceEnabled();
        String className = mo.getAttachmentName();
        if (mo.getAttachment() != null && !(className = (attachment = mo.getAttachment().getClass()).getName()).equals(mo.getAttachmentName())) {
            moElement.setTemplateName(mo.getAttachmentName());
        }
        moElement.setName(mo.getName());
        moElement.setClassName(className);
        List<PersistedProperty> properties = moElement.getProperties();
        if (properties == null) {
            properties = new ArrayList<PersistedProperty>();
            moElement.setProperties(properties);
        }
        for (String propertyName : mo.getPropertyNames()) {
            ManagedProperty property = mo.getProperty(propertyName);
            if (property == null) {
                throw new IllegalStateException("unable to find propery: " + property);
            }
            if (!property.hasViewUse(ViewUse.CONFIGURATION)) continue;
            PropertyInfo propertyInfo = (PropertyInfo)property.getField("propertyInfo", PropertyInfo.class);
            if (propertyInfo != null && !propertyInfo.isReadable()) {
                if (!trace) continue;
                log.trace((Object)("skipping property " + propertyName + "is not readable"));
                continue;
            }
            PersistedProperty propertyElement = this.createPersistedProperty(propertyName, property.getValue(), property.getMetaType(), trace);
            properties.add(propertyElement);
        }
    }

    protected PersistedProperty createPersistedProperty(String name, MetaValue value, MetaType metaType, boolean trace) {
        if (name == null) {
            throw new IllegalArgumentException("Null name.");
        }
        if (metaType == null) {
            throw new IllegalArgumentException("Null meta type.");
        }
        if (trace) {
            log.trace((Object)("processing property name=" + name + "[metaValue=" + value + ", metaType=" + metaType + "]"));
        }
        PersistedProperty property = new PersistedProperty(name);
        PersistedValue persistedValue = this.createPersistedValue(value, metaType);
        persistedValue.setModificationInfo(ModificationInfo.MODIFIED);
        property.setValue(persistedValue);
        return property;
    }

    protected PersistedValue createPersistedValue(MetaValue value, MetaType metaType) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("creating persisted value for : " + value + " with metaType " + metaType));
        }
        if (value == null) {
            return new NullValue();
        }
        metaType = value.getMetaType();
        PersistedValue persistedValue = null;
        if (metaType.isSimple()) {
            persistedValue = this.createSimpleValue((SimpleValue)value);
        } else if (metaType.isEnum()) {
            persistedValue = this.createEnumValue((EnumValue)value);
        } else if (metaType.isCollection()) {
            persistedValue = this.createCollectionValue((CollectionValue)value);
        } else if (metaType.isGeneric()) {
            persistedValue = this.createGenericValue((GenericValue)value);
        } else if (metaType.isComposite()) {
            persistedValue = this.createCompositeValue((CompositeValue)value, (CompositeMetaType)metaType);
        } else if (metaType.isArray()) {
            persistedValue = this.createArrayValue((ArrayValue)value, (ArrayMetaType)metaType);
        } else if (metaType.isTable()) {
            persistedValue = this.createTableValue((TableValue)value);
        } else if (metaType.isProperties()) {
            persistedValue = this.createPropertiesValue((PropertiesMetaValue)value);
        } else {
            throw new IllegalStateException("unknown metaType");
        }
        return persistedValue;
    }

    private PersistedEnumValue createEnumValue(EnumValue value) {
        PersistedEnumValue persistedValue = new PersistedEnumValue();
        persistedValue.setValue(value.getValue());
        return persistedValue;
    }

    private PersistedSimpleValue createSimpleValue(SimpleValue value) {
        PersistedSimpleValue persistedValue = new PersistedSimpleValue();
        persistedValue.setValue(this.convertSimple2String(value));
        return persistedValue;
    }

    private PersistedCollectionValue createCollectionValue(CollectionValue value) {
        PersistedCollectionValue collection = new PersistedCollectionValue();
        for (MetaValue child : value.getElements()) {
            PersistedValue persistedValue = this.createPersistedValue(child, child.getMetaType());
            collection.addValue(persistedValue);
        }
        return collection;
    }

    private PersistedGenericValue createGenericValue(GenericValue value) {
        PersistedGenericValue generic = new PersistedGenericValue();
        Serializable o = value.getValue();
        if (o == null) {
            return generic;
        }
        if (!(o instanceof ManagedObject)) {
            throw new IllegalStateException("The value of GenericValue must be a ManagedObject: " + value);
        }
        PersistedManagedObject mo = this.createPersistenceMetaData((ManagedObject)o);
        generic.setManagedObject(mo);
        return generic;
    }

    private PersistedArrayValue createArrayValue(ArrayValue value, ArrayMetaType metaType) {
        PersistedArrayValue array = new PersistedArrayValue();
        MetaType elementType = metaType.getElementType();
        for (int i = 0; i < value.getLength(); ++i) {
            PersistedValue persistedValue = null;
            Object subElement = value.getValue(i);
            if (subElement instanceof MetaValue) {
                persistedValue = this.createPersistedValue((MetaValue)subElement, elementType);
            } else if (subElement != null && subElement.getClass().isArray()) {
                persistedValue = this.unwrapArray(array, subElement, elementType);
            }
            array.addValue(persistedValue);
        }
        return array;
    }

    protected PersistedArrayValue unwrapArray(PersistedArrayValue array, Object element, MetaType type) {
        PersistedArrayValue newElement = new PersistedArrayValue();
        int subSize = Array.getLength(element);
        for (int i = 0; i < subSize; ++i) {
            PersistedValue persistedValue = null;
            Object subElement = Array.get(element, i);
            if (subElement instanceof MetaValue) {
                persistedValue = this.createPersistedValue((MetaValue)subElement, type);
            } else if (subElement != null && subElement.getClass().isArray()) {
                persistedValue = this.unwrapArray(newElement, subElement, type);
            }
            newElement.addValue(persistedValue);
        }
        return newElement;
    }

    private PersistedCompositeValue createCompositeValue(CompositeValue value, CompositeMetaType metaType) {
        PersistedCompositeValue composite = new PersistedCompositeValue();
        List<PersistedValue> values = composite.getValues();
        if (values == null) {
            values = new ArrayList<PersistedValue>();
            composite.setValues(values);
        }
        for (String item : metaType.itemSet()) {
            MetaType itemType = metaType.getType(item);
            MetaValue itemValue = value.get(item);
            PersistedValue persistedValue = this.createPersistedValue(itemValue, itemType);
            persistedValue.setName(item);
            values.add(persistedValue);
        }
        return composite;
    }

    private PersistedTableValue createTableValue(TableValue value) {
        PersistedTableValue table = new PersistedTableValue();
        List<PersistedCompositeValue> entries = table.getEntries();
        if (entries == null) {
            entries = new ArrayList<PersistedCompositeValue>();
            table.setEntries(entries);
        }
        Collection values = value.values();
        for (CompositeValue entry : values) {
            entries.add(this.createCompositeValue(entry, entry.getMetaType()));
        }
        return table;
    }

    private PersistedValue createPropertiesValue(PropertiesMetaValue value) {
        PersistedPropertiesValue properties = new PersistedPropertiesValue();
        List<PersistedPair> pairs = properties.getEntries();
        if (pairs == null) {
            pairs = new ArrayList<PersistedPair>();
            properties.setEntries(pairs);
        }
        for (Object key : value.keySet()) {
            Object kvalue = value.get(key);
            PersistedPair pair = new PersistedPair(key.toString(), kvalue.toString());
            pairs.add(pair);
        }
        return properties;
    }

    protected static PersistedValue emtpyPersistedValue(MetaType metaType) {
        if (metaType.isSimple()) {
            return new PersistedSimpleValue();
        }
        if (metaType.isEnum()) {
            return new PersistedEnumValue();
        }
        if (metaType.isCollection()) {
            return new PersistedCollectionValue();
        }
        if (metaType.isGeneric()) {
            return new PersistedGenericValue();
        }
        if (metaType.isComposite()) {
            return new PersistedCompositeValue();
        }
        if (metaType.isTable()) {
            return new PersistedTableValue();
        }
        if (metaType.isArray()) {
            return new PersistedArrayValue();
        }
        throw new IllegalStateException("unknown metaType");
    }

    protected String convertSimple2String(SimpleValue value) {
        if (value == null) {
            throw new IllegalArgumentException("Null value.");
        }
        Object unwrappedValue = this.metaValueFactory.unwrap((MetaValue)value);
        if (unwrappedValue == null) {
            return null;
        }
        return "" + unwrappedValue;
    }
}

