/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.profileservice.persistence;

import java.io.Serializable;
import org.jboss.logging.Logger;
import org.jboss.managed.api.ManagedObject;
import org.jboss.managed.api.ManagedProperty;
import org.jboss.metatype.api.types.MetaType;
import org.jboss.metatype.api.values.ArrayValue;
import org.jboss.metatype.api.values.CollectionValue;
import org.jboss.metatype.api.values.CompositeValue;
import org.jboss.metatype.api.values.GenericValue;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.metatype.api.values.TableValue;
import org.jboss.system.server.profileservice.persistence.AttachmentPropertyPopulator;
import org.jboss.system.server.profileservice.persistence.ManagedObjectRecreation;
import org.jboss.system.server.profileservice.persistence.xml.PersistedGenericValue;
import org.jboss.system.server.profileservice.persistence.xml.PersistedManagedObject;
import org.jboss.system.server.profileservice.persistence.xml.PersistedProperty;
import org.jboss.system.server.profileservice.persistence.xml.PersistedValue;

public class ManagedObjectOverride
extends ManagedObjectRecreation {
    protected static final Logger log = Logger.getLogger(ManagedObjectOverride.class);
    private AttachmentPropertyPopulator populator = new AttachmentPropertyPopulator();

    public ManagedObject update(Object attachment, PersistedManagedObject element) throws Throwable {
        if (attachment == null) {
            throw new IllegalArgumentException("Null attachment");
        }
        if (element == null) {
            throw new IllegalArgumentException("Null persisted information.");
        }
        ManagedObject mo = this.buildManagedObject(attachment);
        if (mo == null) {
            return null;
        }
        this.updateManagedObject(mo, element, attachment);
        return mo;
    }

    public void updateManagedObject(ManagedObject mo, PersistedManagedObject element, Object attachment) throws Throwable {
        if (mo == null) {
            throw new IllegalArgumentException("Null managed object.");
        }
        if (element == null) {
            throw new IllegalArgumentException("Null persisted information.");
        }
        if (attachment == null) {
            attachment = mo.getAttachment();
        }
        if (attachment == null) {
            throw new IllegalArgumentException("Null attachment.");
        }
        boolean trace = log.isTraceEnabled();
        for (PersistedProperty persisted : element.getProperties()) {
            ManagedProperty property = mo.getProperty(persisted.getName());
            this.processProperty(property, persisted, attachment, trace);
        }
    }

    protected void processProperty(ManagedProperty property, PersistedProperty propertyElement, Object attachment, boolean trace) throws Throwable {
        PersistedValue valueElement;
        if (property == null) {
            throw new IllegalStateException("Null property");
        }
        MetaValue metaValue = property.getValue();
        MetaType metaType = property.getMetaType();
        if (metaValue != null) {
            metaType = metaValue.getMetaType();
        }
        if ((valueElement = propertyElement.getValue()).getModificationInfo() == null) {
            // empty if block
        }
        MetaValue override = this.createMetaValue(valueElement, metaType);
        MetaValue value = this.processMetaValue(metaValue, override, trace);
        this.setValue(property, value, attachment);
    }

    protected void setValue(ManagedProperty property, MetaValue value, Object attachment) throws Throwable {
        if (value == null) {
            return;
        }
        property.setField("value", (Serializable)value);
        property.setField("metaType", (Serializable)value.getMetaType());
        this.populator.processManagedProperty(property.getName(), property, attachment);
    }

    protected MetaValue processMetaValue(MetaValue original, MetaValue override, boolean trace) throws Throwable {
        if (override == null) {
            return original;
        }
        if (original == null) {
            return override;
        }
        if (original.getMetaType() == null) {
            throw new IllegalStateException("Original meta value is null " + original);
        }
        MetaType metaType = original.getMetaType();
        MetaValue metaValue = null;
        if (metaType.isSimple()) {
            metaValue = override;
        } else if (metaType.isEnum()) {
            metaValue = override;
        } else if (metaType.isCollection()) {
            metaValue = this.mergeCollection((CollectionValue)original, (CollectionValue)override, trace);
        } else if (metaType.isGeneric()) {
            metaValue = this.mergeGenericValue((GenericValue)original, (GenericValue)override, trace);
        } else if (metaType.isComposite()) {
            metaValue = this.mergeCompositeValue((CompositeValue)original, (CompositeValue)override, trace);
        } else if (metaType.isTable()) {
            metaValue = this.mergeTableValue((TableValue)original, (TableValue)override, trace);
        } else if (metaType.isArray()) {
            metaValue = this.mergeArray((ArrayValue)original, (ArrayValue)override, trace);
        } else {
            throw new IllegalStateException("unknown metaType");
        }
        return metaValue;
    }

    protected CompositeValue mergeCompositeValue(CompositeValue original, CompositeValue override, boolean trace) {
        return override;
    }

    protected TableValue mergeTableValue(TableValue original, TableValue override, boolean trace) {
        return override;
    }

    protected ArrayValue mergeArray(ArrayValue original, ArrayValue override, boolean trace) {
        return override;
    }

    protected CollectionValue mergeCollection(CollectionValue original, CollectionValue override, boolean trace) throws Throwable {
        return override;
    }

    protected GenericValue mergeGenericValue(GenericValue original, GenericValue override, boolean trace) throws Throwable {
        Serializable v = override.getValue();
        if (v instanceof PersistedGenericValue) {
            PersistedGenericValue moElement = (PersistedGenericValue)override.getValue();
            return this.processGenericValue(original, moElement, trace);
        }
        return null;
    }

    protected GenericValue processGenericValue(GenericValue original, PersistedGenericValue override, boolean trace) throws Throwable {
        if (override.getManagedObject() == null) {
            return null;
        }
        Serializable o = original.getValue();
        if (o instanceof ManagedObject) {
            ManagedObject originalMO = (ManagedObject)o;
            this.updateManagedObject(originalMO, override.getManagedObject(), originalMO.getAttachment());
            return original;
        }
        throw new RuntimeException("Cannot merge original: " + original + ", override: " + override);
    }
}

