/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */ 
package org.jboss.system.server.profileservice.repository;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;

import org.jboss.profileservice.spi.ModificationInfo;
import org.jboss.profileservice.spi.ProfileKey;
import org.jboss.virtual.VirtualFile;

/**
 * A immutable deployment repository.
 * 
 * @author <a href="mailto:emuckenh@redhat.com">Emanuel Muckenhuber</a>
 * @version $Revision: 85526 $
 */
public class ImmutableDeploymentRepository extends AbstractDeploymentRepository
{

   public ImmutableDeploymentRepository(ProfileKey key, URI[] uris)
   {
      super(key, uris);
   }

   public void load() throws Exception
   {
      for(URI uri : getRepositoryURIs())
      {
         VirtualFile root = getCachedVirtualFile(uri);
         loadApplications(root);
      }
      updateLastModfied();
   }
   
   public Collection<ModificationInfo> getModifiedDeployments() throws Exception
   {
      return Collections.emptySet();
   }

   public String addDeploymentContent(String vfsPath, InputStream contentIS) throws IOException
   {
      throw new IllegalStateException("Cannot add content to an immutable repository.");
   }

   public void remove() throws Exception
   {
      throw new IllegalStateException("Cannot remove immutable repository.");
   }

}

