/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.profile.basic;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.deployers.vfs.spi.client.VFSDeployment;
import org.jboss.deployers.vfs.spi.client.VFSDeploymentFactory;
import org.jboss.managed.api.ManagedComponent;
import org.jboss.managed.api.ManagedDeployment;
import org.jboss.profileservice.spi.ModificationInfo;
import org.jboss.profileservice.spi.NoSuchDeploymentException;
import org.jboss.profileservice.spi.Profile;
import org.jboss.profileservice.spi.ProfileKey;
import org.jboss.util.JBossObject;
import org.jboss.virtual.VFS;
import org.jboss.virtual.VirtualFile;
import org.jboss.virtual.VirtualFileFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfileImpl
extends JBossObject
implements Profile {
    private VFSDeploymentFactory deploymentFactory = VFSDeploymentFactory.getInstance();
    private ProfileKey key;
    private File profileRoot;
    private LinkedHashMap<String, VFSDeployment> bootstraps = new LinkedHashMap();
    private LinkedHashMap<String, VFSDeployment> applications = new LinkedHashMap();
    private LinkedHashMap<String, VFSDeployment> deployers = new LinkedHashMap();
    private volatile boolean hotdeployEnabled;
    private long lastModified;
    private VirtualFileFilter deploymentFilter;

    public ProfileImpl(String profileRoot, ProfileKey key) {
        this.key = key;
        this.profileRoot = new File(profileRoot);
        this.log.info((Object)("Using profile root:" + this.profileRoot.getAbsolutePath()));
    }

    public String getName() {
        return this.key.getName();
    }

    public ProfileKey getKey() {
        return this.key;
    }

    public String getVersion() {
        return null;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public VirtualFileFilter getDeploymentFilter() {
        return this.deploymentFilter;
    }

    public void setDeploymentFilter(VirtualFileFilter deploymentFilter) {
        this.deploymentFilter = deploymentFilter;
    }

    public Set<String> getDeploymentNames() {
        HashSet<String> names = new HashSet<String>();
        names.addAll(this.bootstraps.keySet());
        names.addAll(this.deployers.keySet());
        names.addAll(this.applications.keySet());
        return names;
    }

    public VirtualFile getRootFile(ManagedDeployment.DeploymentPhase phase) throws Exception {
        VirtualFile root = VFS.getRoot((URI)this.profileRoot.toURI());
        switch (phase) {
            case BOOTSTRAP: {
                root = root.findChild("conf");
                break;
            }
            case DEPLOYER: {
                root = root.findChild("deployers");
                break;
            }
            case APPLICATION: {
                root = root.findChild("deploy");
            }
        }
        return root;
    }

    public void addDeployment(VFSDeployment d, ManagedDeployment.DeploymentPhase phase) throws Exception {
        switch (phase) {
            case BOOTSTRAP: {
                this.addBootstrap(d);
                break;
            }
            case DEPLOYER: {
                this.addDeployer(d);
                break;
            }
            case APPLICATION: {
                this.addApplication(d);
            }
        }
        this.lastModified = System.currentTimeMillis();
    }

    public void updateDeployment(VFSDeployment d, ManagedDeployment.DeploymentPhase phase, ManagedComponent comp) throws Exception {
    }

    private VFSDeployment findDeployment(String name, ManagedDeployment.DeploymentPhase phase) {
        VFSDeployment d = null;
        if (phase == null) {
            d = this.getBootstrap(name);
            if (d == null) {
                d = this.getDeployer(name);
            }
            if (d == null) {
                d = this.getApplication(name);
            }
        } else {
            switch (phase) {
                case BOOTSTRAP: {
                    d = this.getBootstrap(name);
                    break;
                }
                case DEPLOYER: {
                    d = this.getDeployer(name);
                    break;
                }
                case APPLICATION: {
                    d = this.getApplication(name);
                }
            }
        }
        return d;
    }

    public VFSDeployment getDeployment(String name, ManagedDeployment.DeploymentPhase phase) throws NoSuchDeploymentException {
        VFSDeployment d = this.findDeployment(name, phase);
        if (d == null) {
            throw new NoSuchDeploymentException("name=" + name + ", phase=" + phase);
        }
        return d;
    }

    public boolean hasDeployment(String name, ManagedDeployment.DeploymentPhase phase) {
        return this.findDeployment(name, phase) != null;
    }

    public Set<String> getDeploymentNames(ManagedDeployment.DeploymentPhase phase) {
        HashSet<String> names = new HashSet<String>();
        switch (phase) {
            case BOOTSTRAP: {
                names.addAll(this.bootstraps.keySet());
                break;
            }
            case DEPLOYER: {
                names.addAll(this.deployers.keySet());
                break;
            }
            case APPLICATION: {
                names.addAll(this.applications.keySet());
            }
        }
        return names;
    }

    public Set<String> getDeploymentNamesForType(String type) {
        throw new UnsupportedOperationException("getDeploymentNamesForType");
    }

    public Collection<VFSDeployment> getDeployments() {
        HashSet<VFSDeployment> deployments = new HashSet<VFSDeployment>();
        deployments.addAll(this.bootstraps.values());
        deployments.addAll(this.deployers.values());
        deployments.addAll(this.applications.values());
        return Collections.unmodifiableCollection(deployments);
    }

    public Collection<ModificationInfo> getModifiedDeployments() throws Exception {
        if (!this.hotdeployEnabled) {
            return Collections.emptyList();
        }
        ArrayList<ModificationInfo> modified = new ArrayList<ModificationInfo>();
        Collection<VFSDeployment> apps = this.applications.values();
        boolean trace = this.log.isTraceEnabled();
        if (trace) {
            this.log.trace((Object)"Checking applications for modifications");
        }
        VirtualFile applicationDir = null;
        if (apps != null) {
            Iterator<VFSDeployment> iter = apps.iterator();
            while (iter.hasNext()) {
                long rootLastModified;
                VFSDeployment d = iter.next();
                VirtualFile root = d.getRoot();
                VirtualFile parent = root.getParent();
                if (parent != null && (applicationDir == null || parent.getPathName().compareTo(applicationDir.getPathName()) < 0)) {
                    applicationDir = parent;
                }
                if (!root.exists()) {
                    rootLastModified = root.getLastModified();
                    ModificationInfo info = new ModificationInfo(d, rootLastModified, ModificationInfo.ModifyStatus.REMOVED);
                    modified.add(info);
                    iter.remove();
                    if (trace) {
                        this.log.trace((Object)(root.getPathName() + " was removed"));
                    }
                    this.postRemove(d);
                    continue;
                }
                if (!this.hasBeenModified(root)) continue;
                rootLastModified = root.getLastModified();
                if (trace) {
                    this.log.trace((Object)(root.getPathName() + " was modified: " + rootLastModified));
                }
                VFSDeployment deployment2 = this.deploymentFactory.createVFSDeployment(root);
                ModificationInfo info = new ModificationInfo(deployment2, rootLastModified, ModificationInfo.ModifyStatus.MODIFIED);
                modified.add(info);
            }
            if (applicationDir == null) {
                applicationDir = this.getRootFile(ManagedDeployment.DeploymentPhase.APPLICATION);
            }
            ArrayList<VirtualFile> added = new ArrayList<VirtualFile>();
            this.addDeployments(added, applicationDir);
            for (VirtualFile vf : added) {
                VFSDeployment d = this.deploymentFactory.createVFSDeployment(vf);
                ModificationInfo info = new ModificationInfo(d, vf.getLastModified(), ModificationInfo.ModifyStatus.ADDED);
                modified.add(info);
                this.applications.put(d.getName(), d);
            }
        }
        if (modified.size() > 0) {
            this.lastModified = System.currentTimeMillis();
        }
        return modified;
    }

    protected boolean hasBeenModified(VirtualFile root) throws Exception {
        return root.hasBeenModified();
    }

    protected void postRemove(VFSDeployment deployment) throws Exception {
    }

    public void enableModifiedDeploymentChecks(boolean flag) {
        this.hotdeployEnabled = flag;
    }

    public Collection<VFSDeployment> getDeployments(ManagedDeployment.DeploymentPhase phase) {
        Collection<VFSDeployment> deployments = null;
        switch (phase) {
            case BOOTSTRAP: {
                deployments = this.getBootstraps();
                break;
            }
            case DEPLOYER: {
                deployments = this.getDeployers();
                break;
            }
            case APPLICATION: {
                deployments = this.getApplications();
            }
        }
        return deployments;
    }

    public VFSDeployment removeDeployment(String name, ManagedDeployment.DeploymentPhase phase) throws Exception {
        VFSDeployment d = null;
        switch (phase) {
            case BOOTSTRAP: {
                d = this.removeBootstrap(name);
                break;
            }
            case DEPLOYER: {
                d = this.removeDeployer(name);
                break;
            }
            case APPLICATION: {
                d = this.removeApplication(name);
            }
        }
        return d;
    }

    public Map<String, Object> getConfig() {
        return null;
    }

    protected void addBootstrap(VFSDeployment d) {
        this.bootstraps.put(d.getName(), d);
    }

    protected VFSDeployment removeBootstrap(String name) {
        return (VFSDeployment)this.bootstraps.remove(name);
    }

    protected VFSDeployment getBootstrap(String name) {
        return this.bootstraps.get(name);
    }

    protected Collection<VFSDeployment> getBootstraps() {
        return Collections.unmodifiableCollection(this.bootstraps.values());
    }

    protected void addDeployer(VFSDeployment d) {
        this.deployers.put(d.getName(), d);
    }

    protected VFSDeployment removeDeployer(String name) {
        return (VFSDeployment)this.deployers.remove(name);
    }

    protected VFSDeployment getDeployer(String name) {
        return this.deployers.get(name);
    }

    protected Collection<VFSDeployment> getDeployers() {
        return Collections.unmodifiableCollection(this.deployers.values());
    }

    protected void addApplication(VFSDeployment d) {
        this.applications.put(d.getName(), d);
    }

    protected VFSDeployment removeApplication(String name) {
        return (VFSDeployment)this.applications.remove(name);
    }

    protected VFSDeployment getApplication(String name) {
        return this.applications.get(name);
    }

    protected Collection<VFSDeployment> getApplications() {
        return Collections.unmodifiableCollection(this.applications.values());
    }

    private void addDeployments(List<VirtualFile> list, VirtualFile root) throws Exception {
        List components = root.getChildren();
        for (VirtualFile component : components) {
            if (!this.deploymentFilter.accepts(component)) {
                this.log.trace((Object)("ignoring " + component));
                continue;
            }
            String key = component.toURI().toString();
            if (this.applications.containsKey(key)) continue;
            if (component.isLeaf()) {
                list.add(component);
                continue;
            }
            if (component.getName().indexOf(46) == -1) {
                this.addDeployments(list, component);
                continue;
            }
            list.add(component);
        }
    }
}

