/*
 * JBoss, Home of Professional Open Source
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.system.server.profileservice.repository;

import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;

import org.jboss.logging.Logger;

/**
 * An AttachmentsSerializer that uses the java bean long term xml serialization
 * format.
 * 
 * @author Scott.Stark@jboss.org
 * @version $Revision: 81070 $
 */
public class JavaBeanXmlAttachmentsSerializer extends AbstractFileAttachmentsSerializer
{
   private static final Logger log = Logger.getLogger(JavaBeanXmlAttachmentsSerializer.class);

   @Override
   @SuppressWarnings("unchecked")
   protected <T> T loadAttachment(File attachmentsStore, Class<T> expected) throws Exception
   {
      T object = null;
      FileInputStream fis = new FileInputStream(attachmentsStore);
      XMLDecoder ois = new XMLDecoder(fis);
      try
      {
         object = (T) ois.readObject();
      }
      finally
      {
         try
         {
            ois.close();
         }
         catch(Exception igore)
         {            
         }
         try
         {
            fis.close();
         }
         catch(Exception igore)
         {            
         }
      }
      return object;
   }

   @Override
   protected void saveAttachment(File attachmentsStore, Object attachment) throws Exception
   {
      log.trace("saveAttachments, attachmentsStore="+attachmentsStore+ ", attachment="+attachment);
      FileOutputStream fos = new FileOutputStream(attachmentsStore);
      XMLEncoder oos = new XMLEncoder(fos);
      try
      {
         oos.writeObject(attachment);
      }
      finally
      {
         try
         {
            oos.close();
         }
         catch(Exception igore)
         {            
         }
         try
         {
            fos.close();
         }
         catch(Exception igore)
         {            
         }
      }
   }
}
