/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.profile.repository;

import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jboss.deployers.vfs.spi.client.VFSDeployment;
import org.jboss.managed.api.ManagedDeployment;
import org.jboss.profileservice.spi.DeploymentRepository;
import org.jboss.profileservice.spi.ModificationInfo;
import org.jboss.profileservice.spi.NoSuchDeploymentException;
import org.jboss.profileservice.spi.Profile;
import org.jboss.profileservice.spi.ProfileKey;
import org.jboss.util.JBossObject;
import org.jboss.util.JBossStringBuilder;
import org.jboss.virtual.VFS;
import org.jboss.virtual.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfileImpl
extends JBossObject
implements Profile {
    private ProfileKey key;
    private String version;
    private DeploymentRepository repository;
    private volatile boolean hotdeployEnabled;

    public ProfileImpl(DeploymentRepository repository, ProfileKey key) {
        this.key = key;
        this.repository = repository;
        this.log.info((Object)("Using repository:" + repository));
    }

    public String getName() {
        return this.key.getName();
    }

    @Override
    public ProfileKey getKey() {
        return this.key;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public long getLastModified() {
        return this.repository.getLastModified();
    }

    @Override
    public Set<String> getDeploymentNames() {
        return this.repository.getDeploymentNames();
    }

    @Override
    public Set<String> getDeploymentNames(ManagedDeployment.DeploymentPhase phase) {
        return this.repository.getDeploymentNames(phase);
    }

    @Override
    public Set<String> getDeploymentNamesForType(String type) {
        return this.repository.getDeploymentNamesForType(type);
    }

    @Override
    public VirtualFile getRootFile(ManagedDeployment.DeploymentPhase phase) throws Exception {
        URI uri = this.repository.getDeploymentURI(phase);
        VirtualFile root = VFS.getRoot((URI)uri);
        return root;
    }

    @Override
    public Collection<VFSDeployment> getDeployments(ManagedDeployment.DeploymentPhase phase) throws Exception {
        return this.repository.getDeployments(phase);
    }

    @Override
    public Collection<VFSDeployment> getDeployments() throws Exception {
        return this.repository.getDeployments();
    }

    @Override
    public Collection<ModificationInfo> getModifiedDeployments() throws Exception {
        Collection<ModificationInfo> modified = Collections.emptyList();
        if (this.hotdeployEnabled) {
            modified = this.repository.getModifiedDeployments();
        }
        return modified;
    }

    @Override
    public synchronized void enableModifiedDeploymentChecks(boolean flag) {
        this.hotdeployEnabled = flag;
    }

    @Override
    public void addDeployment(VFSDeployment d, ManagedDeployment.DeploymentPhase phase) throws Exception {
        String name = d.getName();
        this.repository.addDeployment(name, d, phase);
    }

    @Override
    public void updateDeployment(VFSDeployment d, ManagedDeployment.DeploymentPhase phase) throws Exception {
        this.repository.updateDeployment(d.getName(), d, phase);
    }

    @Override
    public VFSDeployment getDeployment(String name, ManagedDeployment.DeploymentPhase phase) throws Exception, NoSuchDeploymentException {
        return this.repository.getDeployment(name, phase);
    }

    @Override
    public VFSDeployment removeDeployment(String name, ManagedDeployment.DeploymentPhase phase) throws Exception {
        return this.repository.removeDeployment(name, phase);
    }

    @Override
    public Map<String, Object> getConfig() {
        return null;
    }

    @Override
    public boolean hasDeployment(String name, ManagedDeployment.DeploymentPhase phase) {
        try {
            this.getDeployment(name, phase);
            return true;
        }
        catch (NoSuchDeploymentException e) {
            return false;
        }
        catch (Exception e) {
            this.log.warn((Object)"getDeployment return exception", (Throwable)e);
            return false;
        }
    }

    protected void toString(JBossStringBuilder buffer) {
        buffer.append("key=");
        buffer.append((Object)this.key);
    }
}

