/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.microcontainer.jmx;

import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.jboss.aop.microcontainer.aspects.jmx.JMX;
import org.jboss.classloading.spi.RealClassLoader;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.dispatch.InvokeDispatchContext;
import org.jboss.logging.Logger;
import org.jboss.system.microcontainer.jmx.AbstractServiceControllerLifecycleCallback;

public class ServiceControllerRegistrationLifecycleCallback
extends AbstractServiceControllerLifecycleCallback {
    private static final Logger log = Logger.getLogger(ServiceControllerRegistrationLifecycleCallback.class);

    public void install(ControllerContext context) throws Exception {
        JMX jmx = this.readJmxAnnotation(context);
        ObjectName objectName = this.createObjectName(context, jmx);
        Class intfClass = null;
        boolean registerDirectly = false;
        if (jmx != null) {
            intfClass = jmx.exposedInterface();
            registerDirectly = jmx.registerDirectly();
        }
        Object mbean = registerDirectly ? context.getTarget() : new StandardMBean(context.getTarget(), intfClass);
        MBeanServer server = this.getServiceController().getMBeanServer();
        ClassLoader cl = null;
        if (context instanceof InvokeDispatchContext) {
            try {
                cl = ((InvokeDispatchContext)context).getClassLoader();
            }
            catch (Throwable t) {
                log.debug((Object)("Unable to get classloader from " + context + " " + t));
            }
            if (cl == null) {
                cl = Thread.currentThread().getContextClassLoader();
            }
        }
        ObjectName classLoaderName = null;
        while (cl != null) {
            if (cl instanceof RealClassLoader) {
                classLoaderName = ((RealClassLoader)cl).getObjectName();
                break;
            }
            cl = cl.getParent();
        }
        if (classLoaderName != null) {
            Object[] args = new Object[]{mbean, objectName, this.setUpClassLoaderProperty(cl)};
            String[] sig = new String[]{Object.class.getName(), ObjectName.class.getName(), Map.class.getName()};
            server.invoke(MBEAN_REGISTRY, "registerMBean", args, sig);
        } else {
            server.registerMBean(mbean, objectName);
        }
        try {
            this.getServiceController().register(objectName, null, false, context.getTarget());
        }
        catch (Exception e) {
            try {
                server.unregisterMBean(objectName);
            }
            catch (Exception t) {
                log.debug((Object)"Error unregistering mbean", (Throwable)t);
            }
            throw e;
        }
        log.debug((Object)("Registered MBean " + objectName));
    }

    public void uninstall(ControllerContext context) throws Exception {
        ObjectName objectName = this.determineObjectName(context);
        try {
            this.getServiceController().remove(objectName);
        }
        catch (Exception e) {
            log.debug((Object)"Error unregistering mbean", (Throwable)e);
        }
        log.debug((Object)("Unregistered MBean " + objectName));
    }

    protected HashMap setUpClassLoaderProperty(ClassLoader cl) {
        HashMap<String, ClassLoader> valueMap = new HashMap<String, ClassLoader>();
        valueMap.put("org.jboss.mx.classloader", cl);
        return valueMap;
    }
}

