/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import javax.management.ObjectName;
import org.jboss.system.Service;

public class ServiceContext
implements Serializable {
    private static final long serialVersionUID = 7461263042948325633L;
    private static final String[] stateNames = new String[]{"INSTALLED", "CONFIGURED", "CREATED", "RUNNING", "FAILED", "STOPPED", "DESTROYED", "NOTYETINSTALLED"};
    public static final int INSTALLED = 0;
    public static final int CONFIGURED = 1;
    public static final int CREATED = 2;
    public static final int RUNNING = 3;
    public static final int FAILED = 4;
    public static final int STOPPED = 5;
    public static final int DESTROYED = 6;
    public static final int NOTYETINSTALLED = 7;
    public ObjectName objectName;
    public int state = 7;
    public List<ServiceContext> iDependOn = new LinkedList<ServiceContext>();
    public List<ServiceContext> dependsOnMe = new LinkedList<ServiceContext>();
    public transient Service proxy;
    public Throwable problem;

    public String getStateString() {
        return ServiceContext.getStateString(this.state);
    }

    public static String getStateString(int stateInt) {
        return stateNames[stateInt];
    }

    public Throwable getProblem() {
        return this.problem;
    }

    public void setProblem(Throwable problem) {
        this.problem = problem;
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer(512);
        sbuf.append("ObjectName: ").append(this.objectName);
        sbuf.append("\n  State: ").append(stateNames[this.state]);
        if (this.state == 4 && this.problem != null) {
            sbuf.append("\n  Reason: ").append(this.problem.toString());
        }
        this.printList(sbuf, "\n  I Depend On:", this.iDependOn);
        this.printList(sbuf, "\n  Depends On Me:", this.dependsOnMe);
        sbuf.append("\n");
        return sbuf.toString();
    }

    private void printList(StringBuffer sbuf, String msg, List ctxs) {
        if (ctxs.size() > 0) {
            sbuf.append(msg);
            for (ServiceContext sc : ctxs) {
                sbuf.append("\n    ");
                sbuf.append(sc.objectName);
            }
        }
    }
}

