/***************************************
 *                                     *
 *  JBoss: The OpenSource J2EE WebOS   *
 *                                     *
 *  Distributable under LGPL license.  *
 *  See terms of license at gnu.org.   *
 *                                     *
 ***************************************/

package org.jboss.spring.kernel;

import javax.management.ObjectName;

import org.jboss.spring.deployment.SpringDeployer;
import org.jboss.spring.loader.BeanFactoryLoader;

/**
 * @author <a href="mailto:ales.justin@genera-lynx.com">Ales Justin</a>
 * @jmx:mbean name="jboss.spring:service=SpringApplicationContextDeployer"
 * extends="org.jboss.deployment.SubDeployerMBean"
 */
public class SpringMicrocontainerDeployer extends SpringDeployer
{

   //default object name
   public static final ObjectName OBJECT_NAME =
         org.jboss.mx.util.ObjectNameFactory.create("jboss.spring:service=SpringMicrocontainerDeployer");

   public SpringMicrocontainerDeployer()
   {
      super();
   }

   protected BeanFactoryLoader createBeanFactoryLoader()
   {
      return new MicrocontainerLoaderImpl();
   }

   protected ObjectName getDefaultObjectName()
   {
      return OBJECT_NAME;
   }

}
