/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.executor;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadPoolExecutorFactory {
    static final ThreadFactory DEFAULT_THREAD_FACTORY = Executors.defaultThreadFactory();
    static final RejectedExecutionHandler DEFAULT_REJECTED_EXECUTION_HANDLER = new ThreadPoolExecutor.AbortPolicy();
    static final int DEFAULT_KEEP_ALIVE_TIME = 30;
    static final TimeUnit DEFAULT_KEEP_ALIVE_TIME_UNIT = TimeUnit.SECONDS;
    float corePoolSizeBase;
    float corePoolSizePerCpu;
    float maxPoolSizeBase;
    float maxPoolSizePerCpu;
    int keepAliveTime;
    TimeUnit keepAliveTimeUnit = TimeUnit.SECONDS;
    BlockingQueue<Runnable> workQueue;
    ThreadFactory threadFactory;
    RejectedExecutionHandler rejectedExecutionHandler;
    Executor executor;

    public int getKeepAliveTime() {
        return this.keepAliveTime;
    }

    public void setKeepAliveTime(int keepAliveTime) {
        this.keepAliveTime = keepAliveTime;
    }

    public TimeUnit getKeepAliveTimeUnit() {
        return this.keepAliveTimeUnit;
    }

    public void setKeepAliveTimeUnit(TimeUnit keepAliveTimeUnit) {
        this.keepAliveTimeUnit = keepAliveTimeUnit;
    }

    public BlockingQueue<Runnable> getWorkQueue() {
        return this.workQueue;
    }

    public void setWorkQueue(BlockingQueue<Runnable> workQueue) {
        this.workQueue = workQueue;
    }

    public ThreadFactory getThreadFactory() {
        return this.threadFactory;
    }

    public void setThreadFactory(ThreadFactory threadFactory) {
        this.threadFactory = threadFactory;
    }

    public float getCorePoolSizeBase() {
        return this.corePoolSizeBase;
    }

    public void setCorePoolSizeBase(float corePoolSizeBase) {
        this.corePoolSizeBase = corePoolSizeBase;
    }

    public float getCorePoolSizePerCpu() {
        return this.corePoolSizePerCpu;
    }

    public void setCorePoolSizePerCpu(float corePoolSizePerCpu) {
        this.corePoolSizePerCpu = corePoolSizePerCpu;
    }

    public float getMaxPoolSizeBase() {
        return this.maxPoolSizeBase;
    }

    public void setMaxPoolSizeBase(float maxPoolSizeBase) {
        this.maxPoolSizeBase = maxPoolSizeBase;
    }

    public float getMaxPoolSizePerCpu() {
        return this.maxPoolSizePerCpu;
    }

    public void setMaxPoolSizePerCpu(float maxPoolSizePerCpu) {
        this.maxPoolSizePerCpu = maxPoolSizePerCpu;
    }

    public RejectedExecutionHandler getRejectedExecutionHandler() {
        return this.rejectedExecutionHandler;
    }

    public void setRejectedExecutionHandler(RejectedExecutionHandler rejectedExecutionHandler) {
        this.rejectedExecutionHandler = rejectedExecutionHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Executor getExecutor() {
        ThreadPoolExecutorFactory threadPoolExecutorFactory = this;
        synchronized (threadPoolExecutorFactory) {
            if (this.executor == null) {
                this.executor = this.createExecutor();
            }
        }
        return this.executor;
    }

    private ThreadPoolExecutor createExecutor() {
        int coreSize = Math.max(ThreadPoolExecutorFactory.calcPoolSize(this.corePoolSizeBase, this.corePoolSizePerCpu), 0);
        if (coreSize == 0) {
            throw new IllegalStateException("Core size was calculated to 0");
        }
        int maxSize = Math.max(ThreadPoolExecutorFactory.calcPoolSize(this.maxPoolSizeBase, this.maxPoolSizePerCpu), 0);
        if (maxSize == 0) {
            throw new IllegalStateException("Max size was calculated to 0");
        }
        LinkedBlockingQueue<Runnable> queue = this.workQueue == null ? new LinkedBlockingQueue() : this.workQueue;
        ThreadFactory factory = this.threadFactory == null ? DEFAULT_THREAD_FACTORY : this.threadFactory;
        RejectedExecutionHandler handler = this.rejectedExecutionHandler == null ? DEFAULT_REJECTED_EXECUTION_HANDLER : this.rejectedExecutionHandler;
        return new ThreadPoolExecutor(coreSize, maxSize, this.keepAliveTime, this.keepAliveTimeUnit, queue, factory, handler);
    }

    private static int calcPoolSize(float count, float perCpu) {
        if (Float.isNaN(count) || Float.isInfinite(count) || count < 0.0f) {
            count = 0.0f;
        }
        if (Float.isNaN(perCpu) || Float.isInfinite(perCpu) || perCpu < 0.0f) {
            perCpu = 0.0f;
        }
        return Math.round(count + (float)Runtime.getRuntime().availableProcessors() * perCpu);
    }
}

