/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.plugins;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Key;
import java.security.KeyStore;
import java.security.Provider;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.crypto.CryptoUtil;
import org.jboss.managed.api.ManagedOperation;
import org.jboss.managed.api.annotation.ManagementComponent;
import org.jboss.managed.api.annotation.ManagementObject;
import org.jboss.managed.api.annotation.ManagementObjectID;
import org.jboss.managed.api.annotation.ManagementOperation;
import org.jboss.managed.api.annotation.ManagementParameter;
import org.jboss.managed.api.annotation.ManagementProperties;
import org.jboss.managed.api.annotation.ManagementProperty;
import org.jboss.managed.api.annotation.ViewUse;
import org.jboss.mx.util.MBeanServerLocator;
import org.jboss.security.ISecurityManagement;
import org.jboss.security.SecurityDomain;
import org.jboss.security.Util;
import org.jboss.security.auth.callback.JBossCallbackHandler;
import org.jboss.security.integration.JNDIBasedSecurityManagement;
import org.jboss.security.plugins.JaasSecurityDomainMBean;
import org.jboss.security.plugins.JaasSecurityManager;
import org.jboss.security.plugins.JaasSecurityManagerServiceMBean;
import org.jboss.security.plugins.SecurityKeyManager;
import org.jboss.security.plugins.SubjectActions;

@ManagementObject(componentType=@ManagementComponent(type="MCBean", subtype="Security"), properties=ManagementProperties.EXPLICIT)
public class JaasSecurityDomain
extends JaasSecurityManager
implements SecurityDomain,
JaasSecurityDomainMBean {
    private static final RuntimePermission encodePermission = new RuntimePermission("org.jboss.security.plugins.JaasSecurityDomain.encode");
    private static final RuntimePermission decodePermission = new RuntimePermission("org.jboss.security.plugins.JaasSecurityDomain.decode");
    private KeyStore keyStore;
    private KeyManagerFactory keyMgr;
    private String keyStoreType = "JKS";
    private URL keyStoreURL;
    private char[] keyStorePassword;
    private String keyStoreAlias;
    private SecretKey cipherKey;
    private String cipherAlgorithm = "PBEwithMD5andDES";
    private byte[] salt = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
    private int iterationCount = 103;
    private PBEParameterSpec cipherSpec;
    private ObjectName managerServiceName = JaasSecurityManagerServiceMBean.OBJECT_NAME;
    private KeyStore trustStore;
    private String trustStoreType = "JKS";
    private char[] trustStorePassword;
    private URL trustStoreURL;
    private TrustManagerFactory trustMgr;
    private String keyStoreProvider;
    private String trustStoreProvider;
    private String keyMgrFactoryProvider;
    private String trustMgrFactoryProvider;
    private String keyMgrFactoryAlgorithm;
    private String trustMgrFactoryAlgorithm;
    private String keyStoreProviderArgument;
    private String trustStoreProviderArgument;
    private ISecurityManagement securityManagement = new JNDIBasedSecurityManagement();

    public JaasSecurityDomain() {
    }

    public JaasSecurityDomain(String securityDomain) {
        this(securityDomain, (CallbackHandler)new JBossCallbackHandler());
    }

    public JaasSecurityDomain(String securityDomain, CallbackHandler handler) {
        super(securityDomain, handler);
    }

    @ManagementObjectID(type="SecurityDomain")
    @ManagementProperty(use={ViewUse.CONFIGURATION}, description="The security domain name")
    public String getSecurityDomain() {
        return super.getSecurityDomain();
    }

    @ManagementProperty(use={ViewUse.CONFIGURATION}, description="The keystore implementation type - default is JKS")
    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    public void setKeyStoreType(String type) {
        this.keyStoreType = type;
    }

    @ManagementProperty(use={ViewUse.CONFIGURATION}, description="The keystore location")
    public String getKeyStoreURL() {
        String url = null;
        if (this.keyStoreURL != null) {
            url = this.keyStoreURL.toExternalForm();
        }
        return url;
    }

    public void setKeyStoreURL(String storeURL) throws IOException {
        this.keyStoreURL = this.validateStoreURL(storeURL);
        this.log.debug((Object)("Using KeyStore=" + this.keyStoreURL.toExternalForm()));
    }

    @ManagementProperty(use={ViewUse.CONFIGURATION}, description="The keystore password", mandatory=true)
    public void setKeyStorePass(String password) throws Exception {
        this.keyStorePassword = Util.loadPassword(password);
    }

    @ManagementProperty(use={ViewUse.CONFIGURATION}, description="The keystore alias with the certificate to be used")
    public String getKeyStoreAlias() {
        return this.keyStoreAlias;
    }

    public void setKeyStoreAlias(String alias) {
        this.keyStoreAlias = alias;
    }

    @ManagementProperty(use={ViewUse.CONFIGURATION}, description="The truststore implementation type - default is JKS")
    public String getTrustStoreType() {
        return this.trustStoreType;
    }

    public void setTrustStoreType(String type) {
        this.trustStoreType = type;
    }

    @ManagementProperty(use={ViewUse.CONFIGURATION}, description="The truststore location")
    public String getTrustStoreURL() {
        String url = null;
        if (this.trustStoreURL != null) {
            url = this.trustStoreURL.toExternalForm();
        }
        return url;
    }

    public void setTrustStoreURL(String storeURL) throws IOException {
        this.trustStoreURL = this.validateStoreURL(storeURL);
    }

    @ManagementProperty(use={ViewUse.CONFIGURATION}, description="The truststore password")
    public void setTrustStorePass(String password) throws Exception {
        this.trustStorePassword = Util.loadPassword(password);
    }

    @ManagementProperty(use={ViewUse.CONFIGURATION}, description="The salt for password-based encryption (PBE)")
    public void setSalt(String salt) {
        this.salt = salt.getBytes();
    }

    @ManagementProperty(use={ViewUse.CONFIGURATION}, description="The iteration count for password-based encryption (PBE)")
    public void setIterationCount(int iterationCount) {
        this.iterationCount = iterationCount;
    }

    @ManagementProperty(use={ViewUse.CONFIGURATION}, description="The cipher algorithm used in the encode/decode operations - default is PBEwithMD5andDES")
    public String getCipherAlgorithm() {
        return this.cipherAlgorithm;
    }

    public void setCipherAlgorithm(String cipherAlgorithm) {
        this.cipherAlgorithm = cipherAlgorithm;
    }

    @ManagementProperty(use={ViewUse.CONFIGURATION}, description="The object name of the security manager service")
    public ObjectName getManagerServiceName() {
        return this.managerServiceName;
    }

    public void setManagerServiceName(ObjectName managerServiceName) {
        this.managerServiceName = managerServiceName;
    }

    @ManagementProperty(use={ViewUse.CONFIGURATION}, description="The security manager service bean where this domain is registered")
    public ISecurityManagement getSecurityManagement() {
        return this.securityManagement;
    }

    public void setSecurityManagement(ISecurityManagement securityManagement) {
        this.securityManagement = securityManagement;
    }

    public String getName() {
        return "JaasSecurityDomain(" + this.getSecurityDomain() + ")";
    }

    @ManagementOperation(description="Get the KeyStore constructed by this domain", impact=ManagedOperation.Impact.ReadOnly)
    public KeyStore getKeyStore() throws SecurityException {
        return this.keyStore;
    }

    @ManagementOperation(description="Get the KeyManagerFactory constructed by this domain", impact=ManagedOperation.Impact.ReadOnly)
    public KeyManagerFactory getKeyManagerFactory() throws SecurityException {
        return this.keyMgr;
    }

    @ManagementOperation(description="Get the TrustStore constructed by this domain", impact=ManagedOperation.Impact.ReadOnly)
    public KeyStore getTrustStore() throws SecurityException {
        return this.trustStore;
    }

    @ManagementOperation(description="Get the TrustManagerFactory constructed by this domain", impact=ManagedOperation.Impact.ReadOnly)
    public TrustManagerFactory getTrustManagerFactory() throws SecurityException {
        return this.trustMgr;
    }

    @ManagementOperation(description="Encode a secret using the cipher algorithm and the KeyStore password", params={@ManagementParameter(name="secret", description="The secret to be encoded")}, impact=ManagedOperation.Impact.ReadOnly)
    public byte[] encode(byte[] secret) throws Exception {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Checking: " + encodePermission));
            }
            sm.checkPermission(encodePermission);
        }
        Cipher cipher = Cipher.getInstance(this.cipherAlgorithm);
        cipher.init(1, (Key)this.cipherKey, this.cipherSpec);
        byte[] encoding = cipher.doFinal(secret);
        return encoding;
    }

    @ManagementOperation(description="Decode a secret using the cipher algorithm and the KeyStore password", params={@ManagementParameter(name="secret", description="The secret to be encoded")}, impact=ManagedOperation.Impact.ReadOnly)
    public byte[] decode(byte[] secret) throws Exception {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(decodePermission);
        }
        Cipher cipher = Cipher.getInstance(this.cipherAlgorithm);
        cipher.init(2, (Key)this.cipherKey, this.cipherSpec);
        byte[] decode = cipher.doFinal(secret);
        return decode;
    }

    @ManagementOperation(description="Encode a secret as a base64 string using the cipher algorithm and the KeyStore password", params={@ManagementParameter(name="secret", description="The secret to be encoded")}, impact=ManagedOperation.Impact.ReadOnly)
    public String encode64(byte[] secret) throws Exception {
        byte[] encoding = this.encode(secret);
        String b64 = CryptoUtil.tob64((byte[])encoding);
        return b64;
    }

    @ManagementOperation(description="Decode a base64 secret using the cipher algorithm and the KeyStore password", params={@ManagementParameter(name="secret", description="The secret to be encoded")}, impact=ManagedOperation.Impact.ReadOnly)
    public byte[] decode64(String secret) throws Exception {
        byte[] encoding = CryptoUtil.fromb64((String)secret);
        if (encoding.length % 8 != 0) {
            int length = encoding.length;
            int newLength = (length / 8 + 1) * 8;
            int pad = newLength - length;
            byte[] old = encoding;
            encoding = new byte[newLength];
            for (int i = old.length - 1; i >= 0; --i) {
                encoding[i + pad] = old[i];
            }
        }
        byte[] decode = this.decode(encoding);
        return decode;
    }

    @ManagementProperty(use={ViewUse.CONFIGURATION}, description="The security provider of the KeyManagerFactory")
    public String getKeyManagerFactoryProvider() {
        return this.keyMgrFactoryProvider;
    }

    public void setKeyManagerFactoryProvider(String provider) {
        this.keyMgrFactoryProvider = provider;
    }

    @ManagementProperty(use={ViewUse.CONFIGURATION}, description="The security provider of the KeyStore")
    public String getKeyStoreProvider() {
        return this.keyStoreProvider;
    }

    public void setKeyStoreProvider(String provider) {
        this.keyStoreProvider = provider;
    }

    @ManagementProperty(use={ViewUse.CONFIGURATION}, description="The security provider of the TrustManagerFactory")
    public String getTrustManagerFactoryProvider() {
        return this.trustMgrFactoryProvider;
    }

    public void setTrustManagerFactoryProvider(String provider) {
        this.trustMgrFactoryProvider = provider;
    }

    @ManagementProperty(use={ViewUse.CONFIGURATION}, description="The security provider of the TrustStore")
    public String getTrustStoreProvider() {
        return this.trustStoreProvider;
    }

    public void setTrustStoreProvider(String provider) {
        this.trustStoreProvider = provider;
    }

    @ManagementProperty(use={ViewUse.CONFIGURATION}, description="The algorithm of the KeyManagerFactory")
    public String getKeyManagerFactoryAlgorithm() {
        return this.keyMgrFactoryAlgorithm;
    }

    public void setKeyManagerFactoryAlgorithm(String algorithm) {
        this.keyMgrFactoryAlgorithm = algorithm;
    }

    @ManagementProperty(use={ViewUse.CONFIGURATION}, description="The algorithm of the TrustManagerFactory")
    public String getTrustManagerFactoryAlgorithm() {
        return this.trustMgrFactoryAlgorithm;
    }

    public void setTrustManagerFactoryAlgorithm(String algorithm) {
        this.trustMgrFactoryAlgorithm = algorithm;
    }

    @ManagementProperty(use={ViewUse.CONFIGURATION}, description="The argument of the KeyStore provider constructor")
    public String getKeyStoreProviderArgument() {
        return this.keyStoreProviderArgument;
    }

    public void setKeyStoreProviderArgument(String argument) {
        this.keyStoreProviderArgument = argument;
    }

    @ManagementProperty(use={ViewUse.CONFIGURATION}, description="The argument of the TrustStore provider constructor")
    public String getTrustStoreProviderArgument() {
        return this.trustStoreProviderArgument;
    }

    public void setTrustStoreProviderArgument(String argument) {
        this.trustStoreProviderArgument = argument;
    }

    @ManagementOperation(description="Reload the key and trust stores", impact=ManagedOperation.Impact.WriteOnly)
    public void reloadKeyAndTrustStore() throws Exception {
        this.loadKeyAndTrustStore();
    }

    @ManagementOperation(description="Service lifecycle operation", impact=ManagedOperation.Impact.WriteOnly)
    protected void startService() throws Exception {
        this.loadPBESecretKey();
        this.loadKeyAndTrustStore();
        if (this.managerServiceName != null) {
            MBeanServer server = MBeanServerLocator.locateJBoss();
            Object[] params = new Object[]{this.getSecurityDomain(), this};
            String[] signature = new String[]{"java.lang.String", "org.jboss.security.SecurityDomain"};
            server.invoke(this.managerServiceName, "registerSecurityDomain", params, signature);
        }
        if (this.securityManagement instanceof JNDIBasedSecurityManagement) {
            JNDIBasedSecurityManagement jbs = (JNDIBasedSecurityManagement)this.securityManagement;
            jbs.registerJaasSecurityDomainInstance(this);
        }
    }

    @ManagementOperation(description="Service lifecycle operation", impact=ManagedOperation.Impact.WriteOnly)
    protected void stopService() {
        if (this.keyStorePassword != null) {
            Arrays.fill(this.keyStorePassword, '\u0000');
            this.keyStorePassword = null;
        }
        this.cipherKey = null;
        if (this.securityManagement instanceof JNDIBasedSecurityManagement) {
            JNDIBasedSecurityManagement jbs = (JNDIBasedSecurityManagement)this.securityManagement;
            jbs.deregisterJaasSecurityDomainInstance(this.getSecurityDomain());
        }
    }

    private void loadPBESecretKey() throws Exception {
        this.cipherSpec = new PBEParameterSpec(this.salt, this.iterationCount);
        PBEKeySpec keySpec = new PBEKeySpec(this.keyStorePassword);
        SecretKeyFactory factory = SecretKeyFactory.getInstance("PBEwithMD5andDES");
        this.cipherKey = factory.generateSecret(keySpec);
    }

    private void loadKeyAndTrustStore() throws Exception {
        String algorithm;
        InputStream is;
        Provider provider;
        Object[] ctorArgs;
        Constructor<?> ctor;
        Class[] ctorSig;
        Class<?> clazz;
        ClassLoader loader;
        if (this.keyStorePassword != null) {
            if (this.keyStoreProvider != null) {
                if (this.keyStoreProviderArgument != null) {
                    loader = Thread.currentThread().getContextClassLoader();
                    clazz = loader.loadClass(this.keyStoreProvider);
                    ctorSig = new Class[]{String.class};
                    ctor = clazz.getConstructor(ctorSig);
                    ctorArgs = new Object[]{this.keyStoreProviderArgument};
                    provider = (Provider)ctor.newInstance(ctorArgs);
                    this.keyStore = KeyStore.getInstance(this.keyStoreType, provider);
                } else {
                    this.keyStore = KeyStore.getInstance(this.keyStoreType, this.keyStoreProvider);
                }
            } else {
                this.keyStore = KeyStore.getInstance(this.keyStoreType);
            }
            is = null;
            if (!("PKCS11".equalsIgnoreCase(this.keyStoreType) && "PKCS11IMPLKS".equalsIgnoreCase(this.keyStoreType) || this.keyStoreURL == null)) {
                is = this.keyStoreURL.openStream();
            }
            this.keyStore.load(is, this.keyStorePassword);
            if (this.keyStoreAlias != null && !this.keyStore.isKeyEntry(this.keyStoreAlias)) {
                throw new IOException("Cannot find key entry with alias " + this.keyStoreAlias + " in the keyStore");
            }
            algorithm = null;
            algorithm = this.keyMgrFactoryAlgorithm != null ? this.keyMgrFactoryAlgorithm : KeyManagerFactory.getDefaultAlgorithm();
            this.keyMgr = this.keyMgrFactoryProvider != null ? KeyManagerFactory.getInstance(algorithm, this.keyMgrFactoryProvider) : KeyManagerFactory.getInstance(algorithm);
            this.keyMgr.init(this.keyStore, this.keyStorePassword);
            if (this.keyStoreAlias != null) {
                KeyManager[] keyManagers = this.keyMgr.getKeyManagers();
                for (int i = 0; i < keyManagers.length; ++i) {
                    keyManagers[i] = new SecurityKeyManager((X509KeyManager)keyManagers[i], this.keyStoreAlias);
                }
            }
        }
        if (this.trustStorePassword != null) {
            if (this.trustStoreProvider != null) {
                if (this.trustStoreProviderArgument != null) {
                    loader = Thread.currentThread().getContextClassLoader();
                    clazz = loader.loadClass(this.trustStoreProvider);
                    ctorSig = new Class[]{String.class};
                    ctor = clazz.getConstructor(ctorSig);
                    ctorArgs = new Object[]{this.trustStoreProviderArgument};
                    provider = (Provider)ctor.newInstance(ctorArgs);
                    this.trustStore = KeyStore.getInstance(this.trustStoreType, provider);
                } else {
                    this.trustStore = KeyStore.getInstance(this.trustStoreType, this.trustStoreProvider);
                }
            } else {
                this.trustStore = KeyStore.getInstance(this.trustStoreType);
            }
            is = null;
            if (!("PKCS11".equalsIgnoreCase(this.trustStoreType) && "PKCS11IMPLKS".equalsIgnoreCase(this.trustStoreType) || this.trustStoreURL == null)) {
                is = this.trustStoreURL.openStream();
            }
            this.trustStore.load(is, this.trustStorePassword);
            algorithm = null;
            algorithm = this.trustMgrFactoryAlgorithm != null ? this.trustMgrFactoryAlgorithm : TrustManagerFactory.getDefaultAlgorithm();
            this.trustMgr = this.trustMgrFactoryProvider != null ? TrustManagerFactory.getInstance(algorithm, this.trustStoreProvider) : TrustManagerFactory.getInstance(algorithm);
            this.trustMgr.init(this.trustStore);
        } else if (this.keyStore != null) {
            this.trustStore = this.keyStore;
            String algorithm2 = null;
            algorithm2 = this.trustMgrFactoryAlgorithm != null ? this.trustMgrFactoryAlgorithm : TrustManagerFactory.getDefaultAlgorithm();
            this.trustMgr = TrustManagerFactory.getInstance(algorithm2);
            this.trustMgr.init(this.trustStore);
        }
    }

    private URL validateStoreURL(String storeURL) throws IOException {
        File tst;
        URL url = null;
        try {
            url = new URL(storeURL);
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        if (url == null && (tst = new File(storeURL)).exists()) {
            url = tst.toURL();
        }
        if (url == null) {
            ClassLoader loader = SubjectActions.getContextClassLoader();
            url = loader.getResource(storeURL);
        }
        if (url == null) {
            String msg = "Failed to find url=" + storeURL + " as a URL, file or resource";
            throw new MalformedURLException(msg);
        }
        return url;
    }
}

