/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.management.upload.remoting;

import java.io.InputStream;
import java.util.Map;
import javax.management.MBeanServer;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.InvocationResponse;
import org.jboss.aspects.remoting.AOPRemotingInvocationHandler;
import org.jboss.deployers.spi.management.deploy.DeploymentID;
import org.jboss.logging.Logger;
import org.jboss.profileservice.management.client.upload.SerializableDeploymentID;
import org.jboss.profileservice.management.upload.remoting.DeployHandlerDelegate;
import org.jboss.profileservice.management.upload.remoting.SecurityActions;
import org.jboss.profileservice.remoting.SecurityContainer;
import org.jboss.remoting.InvocationRequest;
import org.jboss.remoting.ServerInvoker;
import org.jboss.remoting.callback.InvokerCallbackHandler;
import org.jboss.remoting.stream.StreamInvocationHandler;
import org.jboss.security.ISecurityManagement;
import org.jboss.security.SecurityContext;

public class DeployHandler
extends AOPRemotingInvocationHandler
implements StreamInvocationHandler {
    static final Logger log = Logger.getLogger(DeployHandler.class);
    private String securityDomain = "jmx-console";
    private ISecurityManagement securityManagement;
    private DeployHandlerDelegate delegate;

    public DeployHandler(DeployHandlerDelegate delegate) {
        this.delegate = delegate;
    }

    public String getSecurityDomain() {
        return this.securityDomain;
    }

    public void setSecurityDomain(String securityDomain) {
        this.securityDomain = securityDomain;
    }

    public ISecurityManagement getSecurityManagement() {
        return this.securityManagement;
    }

    public void setSecurityManagement(ISecurityManagement securityManagement) {
        this.securityManagement = securityManagement;
    }

    public void addListener(InvokerCallbackHandler arg0) {
    }

    public void removeListener(InvokerCallbackHandler arg0) {
    }

    public void setInvoker(ServerInvoker arg0) {
    }

    public void setMBeanServer(MBeanServer arg0) {
    }

    public Object invoke(InvocationRequest request) throws Throwable {
        this.establishSecurityContext(request);
        Object parameter = request.getParameter();
        String[] returnValue = null;
        if (parameter instanceof Invocation) {
            Invocation inv = (Invocation)parameter;
            SecurityContainer.setInvocation(inv);
            returnValue = super.invoke(request);
        } else {
            Map payload = request.getRequestPayload();
            DeploymentID dtID = (DeploymentID)payload.get("DeploymentTargetID");
            if (dtID == null) {
                throw new IllegalStateException("Null deployment target ID.");
            }
            log.info((Object)("invoke, payload: " + payload + ", parameter: " + parameter));
            try {
                if (parameter.equals("getRepositoryNames")) {
                    returnValue = this.delegate.resolveDeploymentNames(dtID.getNames());
                } else if (parameter.equals("distribute")) {
                    returnValue = this.delegate.distribute(dtID, null);
                } else if (!parameter.equals("prepare")) {
                    if (parameter.equals("start")) {
                        this.delegate.startDeployments(dtID.getNames());
                    } else if (parameter.equals("stop")) {
                        this.delegate.stopDeployments(dtID.getNames());
                    } else if (parameter.equals("remove")) {
                        this.delegate.removeDeployments(dtID.getNames());
                    } else if (parameter.equals("undeploy")) {
                        this.delegate.removeDeployments(dtID.getNames());
                    } else if (parameter.equals("redeploy")) {
                        String[] names = dtID.getNames();
                        this.delegate.stopDeployments(names);
                        this.delegate.startDeployments(names);
                    }
                }
            }
            catch (Exception e) {
                log.warn((Object)("Failed to complete command: [" + parameter + "] for deployment: " + dtID), (Throwable)e);
                throw e;
            }
        }
        return returnValue;
    }

    public InvocationResponse handleStream(InputStream contentIS, InvocationRequest request) throws Throwable {
        SerializableDeploymentID deploymentTarget = (SerializableDeploymentID)request.getParameter();
        String[] names = this.delegate.distribute(deploymentTarget, contentIS);
        deploymentTarget.setRepositoryNames(names);
        return new InvocationResponse((Object)names[0]);
    }

    private void establishSecurityContext(InvocationRequest invocation) throws Exception {
        SecurityContext newSC = SecurityActions.createAndSetSecurityContext(this.securityDomain);
        SecurityActions.setSecurityManagement(newSC, this.securityManagement);
        log.trace((Object)("establishSecurityIdentity:SecCtx=" + SecurityActions.trace(newSC)));
    }
}

