/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.management.upload.remoting;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jboss.aop.joinpoint.InvocationResponse;
import org.jboss.deployers.spi.management.deploy.DeploymentID;
import org.jboss.deployers.spi.management.deploy.DeploymentTarget;
import org.jboss.logging.Logger;
import org.jboss.managed.api.ManagedDeployment;
import org.jboss.profileservice.management.upload.SerializableDeploymentID;
import org.jboss.remoting.Client;
import org.jboss.remoting.InvokerLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StreamingDeploymentTarget
implements DeploymentTarget,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(StreamingDeploymentTarget.class);
    private InvokerLocator locator;
    private String name;
    private String subsystem;

    public StreamingDeploymentTarget(InvokerLocator locator, String name, String subsystem) {
        log.debug((Object)("new StreamingTarget: " + locator));
        this.name = name;
        this.subsystem = subsystem;
        this.locator = locator;
    }

    public String getDescription() {
        return this.name + "(" + this.locator + ")";
    }

    public String getName() {
        return this.name;
    }

    public InvokerLocator getInvokerLocator() {
        return this.locator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void distribute(DeploymentID deployment) throws Exception {
        URL contentURL = deployment.getContentURL();
        SerializableDeploymentID sdtID = new SerializableDeploymentID(deployment);
        Client client = this.getClient();
        try {
            InputStream contentIS = contentURL.openStream();
            sdtID.setContentIS(contentIS);
            log.debug((Object)("Begin distribute: " + deployment));
            String repositoryName = this.transferDeployment(client, sdtID);
            String[] rnames = new String[]{repositoryName};
            deployment.setRepositoryNames(rnames);
            log.debug((Object)("End distribute, repositoryName: " + repositoryName));
        }
        finally {
            client.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getRepositoryNames(String[] names, ManagedDeployment.DeploymentPhase phase) throws Exception {
        Client client = this.getClient();
        try {
            log.debug((Object)("Begin getRepositoryNames: " + Arrays.asList(names)));
            HashMap<String, Object> args = new HashMap<String, Object>();
            args.put("names", names);
            args.put("phase", phase);
            String[] rnames = (String[])this.invoke(client, "getRepositoryNames", args);
            log.debug((Object)("End getRepositoryNames: " + Arrays.asList(rnames)));
            String[] stringArray = rnames;
            return stringArray;
        }
        finally {
            client.disconnect();
        }
    }

    public void redeploy(DeploymentID deployment) throws Exception {
        throw new IllegalStateException("redeploy is not yet implemented");
    }

    public void prepare(DeploymentID deployment) throws Exception {
        throw new IllegalStateException("prepare is not yet implemented");
    }

    protected Map<?, ?> createArgs(DeploymentID dtID) {
        return new HashMap<String, DeploymentID>(Collections.singletonMap("DeploymentTargetID", dtID));
    }

    public void start(DeploymentID dtID) throws Exception {
        Client client = this.getClient();
        log.debug((Object)("Start: " + dtID));
        this.invoke(client, "start", this.createArgs(dtID));
        log.debug((Object)("End start: " + dtID));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(DeploymentID dtID) throws Exception {
        Client client = this.getClient();
        try {
            log.debug((Object)("Begin stop: " + dtID));
            this.invoke(client, "stop", this.createArgs(dtID));
            log.debug((Object)"End stop");
        }
        finally {
            client.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undeploy(DeploymentID dtID) throws Exception {
        Client client = this.getClient();
        try {
            log.debug((Object)("Begin undeploy: " + dtID));
            this.invoke(client, "undeploy", this.createArgs(dtID));
            log.debug((Object)"End undeploy");
        }
        finally {
            client.disconnect();
        }
    }

    public String toString() {
        StringBuilder tmp = new StringBuilder();
        tmp.append("name=");
        tmp.append(this.name);
        tmp.append(",locator=");
        tmp.append(this.locator);
        tmp.append(",subsystem=");
        tmp.append(this.subsystem);
        return tmp.toString();
    }

    private Client getClient() throws Exception {
        log.debug((Object)("Calling remoting server with locator of: " + this.locator));
        Client remotingClient = new Client(this.locator, this.subsystem);
        remotingClient.connect();
        return remotingClient;
    }

    private String transferDeployment(Client client, SerializableDeploymentID sdtID) throws Exception {
        InputStream is = sdtID.getContentIS();
        try {
            String repositoryName;
            InvocationResponse response = (InvocationResponse)client.invoke(is, (Object)sdtID);
            String string = repositoryName = (String)response.getResponse();
            return string;
        }
        catch (Error e) {
            throw new RuntimeException(e);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException ignored) {}
        }
    }

    private Object invoke(Client client, String name, Map<?, ?> args) throws Exception {
        try {
            return client.invoke((Object)name, args);
        }
        catch (Error e) {
            throw new RuntimeException(e);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }
}

