/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.management.upload.remoting;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Map;
import javax.management.MBeanServer;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.InvocationResponse;
import org.jboss.aspects.remoting.AOPRemotingInvocationHandler;
import org.jboss.deployers.client.spi.Deployment;
import org.jboss.deployers.client.spi.main.MainDeployer;
import org.jboss.deployers.spi.management.deploy.DeploymentID;
import org.jboss.deployers.vfs.spi.client.VFSDeployment;
import org.jboss.deployers.vfs.spi.client.VFSDeploymentFactory;
import org.jboss.logging.Logger;
import org.jboss.managed.api.ManagedDeployment;
import org.jboss.profileservice.management.upload.SerializableDeploymentID;
import org.jboss.profileservice.spi.DeploymentRepository;
import org.jboss.remoting.InvocationRequest;
import org.jboss.remoting.ServerInvoker;
import org.jboss.remoting.callback.InvokerCallbackHandler;
import org.jboss.remoting.stream.StreamInvocationHandler;
import org.jboss.virtual.VirtualFile;

public class DeployHandler
extends AOPRemotingInvocationHandler
implements StreamInvocationHandler {
    static Logger log = Logger.getLogger(DeployHandler.class);
    private DeploymentRepository deploymentRepository;
    private VFSDeploymentFactory deploymentFactory = VFSDeploymentFactory.getInstance();
    private MainDeployer mainDeployer;

    public DeploymentRepository getDeploymentRepository() {
        return this.deploymentRepository;
    }

    public void setDeploymentRepository(DeploymentRepository deploymentRepository) {
        this.deploymentRepository = deploymentRepository;
    }

    public VFSDeploymentFactory getDeploymentFactory() {
        return this.deploymentFactory;
    }

    public void setDeploymentFactory(VFSDeploymentFactory deploymentFactory) {
        this.deploymentFactory = deploymentFactory;
    }

    public MainDeployer getMainDeployer() {
        return this.mainDeployer;
    }

    public void setMainDeployer(MainDeployer mainDeployer) {
        this.mainDeployer = mainDeployer;
    }

    public Object handleStream(InputStream contentIS, InvocationRequest request) throws Throwable {
        SerializableDeploymentID deploymentTarget = (SerializableDeploymentID)request.getParameter();
        log.debug((Object)("handleStream, deploymentTarget: " + deploymentTarget));
        deploymentTarget.setContentIS(contentIS);
        ManagedDeployment.DeploymentPhase phase = deploymentTarget.getPhase();
        String[] names = deploymentTarget.getNames();
        String repositoryName = this.deploymentRepository.addDeploymentContent(names[0], contentIS, phase);
        String[] rnames = new String[]{repositoryName};
        deploymentTarget.setRepositoryNames(rnames);
        return new InvocationResponse((Object)repositoryName);
    }

    public void addListener(InvokerCallbackHandler arg0) {
    }

    public Object invoke(InvocationRequest request) throws Throwable {
        Object parameter = request.getParameter();
        String[] returnValue = null;
        if (parameter instanceof Invocation) {
            returnValue = super.invoke(request);
        } else {
            Map payload = request.getRequestPayload();
            DeploymentID dtID = (DeploymentID)payload.get("DeploymentTargetID");
            log.debug((Object)("invoke, payload: " + payload));
            if (parameter.equals("getRepositoryNames")) {
                String[] names = (String[])payload.get("names");
                ManagedDeployment.DeploymentPhase phase = (ManagedDeployment.DeploymentPhase)payload.get("phase");
                returnValue = this.getRepositoryNames(names, phase);
            }
            if (parameter.equals("start")) {
                this.start(dtID);
            }
            if (parameter.equals("stop")) {
                this.stop(dtID);
            }
            if (parameter.equals("undeploy")) {
                this.undeploy(dtID);
            }
        }
        return returnValue;
    }

    public void removeListener(InvokerCallbackHandler arg0) {
    }

    public void setInvoker(ServerInvoker arg0) {
    }

    public void setMBeanServer(MBeanServer arg0) {
    }

    protected String[] getRepositoryNames(String[] names, ManagedDeployment.DeploymentPhase phase) throws IOException {
        return this.deploymentRepository.getRepositoryNames(names, phase);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void start(DeploymentID dtID) throws Exception {
        String[] names = dtID.getNames();
        log.info((Object)("Begin start, " + Arrays.asList(names)));
        this.deploymentRepository.acquireDeploymentContentLock();
        try {
            for (String name : names) {
                VirtualFile vf = this.deploymentRepository.getDeploymentContent(name, dtID.getPhase());
                VFSDeployment vfsd = this.createDeployment(vf);
                this.deploymentRepository.addDeployment(name, vfsd, dtID.getPhase());
                this.deploymentRepository.unlockDeploymentContent(vf.getPathName(), dtID.getPhase());
                this.mainDeployer.addDeployment((Deployment)vfsd);
                log.info((Object)("Scheduling start for: " + vfsd));
            }
            this.mainDeployer.process();
            this.mainDeployer.checkComplete();
        }
        finally {
            this.deploymentRepository.releaseDeploymentContentLock();
        }
        log.info((Object)("End start, " + Arrays.asList(names)));
    }

    protected void stop(DeploymentID dtID) throws Exception {
        String[] names = dtID.getNames();
        log.info((Object)("stop, " + Arrays.asList(names)));
        for (String name : names) {
            VFSDeployment vfsd = this.deploymentRepository.getDeployment(name, dtID.getPhase());
            this.mainDeployer.removeDeployment((Deployment)vfsd);
            log.info((Object)("Scheduling stop for: " + vfsd));
        }
        this.mainDeployer.process();
        this.mainDeployer.checkComplete();
    }

    protected void undeploy(DeploymentID dtID) throws Exception {
        String[] names = dtID.getNames();
        log.info((Object)("undeploy, " + Arrays.asList(names)));
        for (String name : names) {
            this.deploymentRepository.removeDeployment(name, dtID.getPhase());
            log.info((Object)("Undeployed: " + name));
        }
    }

    protected VFSDeployment createDeployment(VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Null file");
        }
        return this.deploymentFactory.createVFSDeployment(file);
    }
}

