/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.metadata;

import javax.management.DynamicMBean;
import javax.management.NotCompliantMBeanException;

public class MBeanCapability {
    public static final int DYNAMIC_MBEAN = 801;
    public static final int STANDARD_MBEAN = 291;
    public static final int NOT_AN_MBEAN = 49374;
    private static final MBeanCapability DYNAMIC_CONST = new MBeanCapability(801);
    private static final MBeanCapability STANDARD_CONST = new MBeanCapability(291);
    protected int mbeanType = 49374;

    private MBeanCapability(int type) {
        this.mbeanType = type;
    }

    public int getMBeanType() {
        return this.mbeanType;
    }

    public static MBeanCapability of(Class mbeanClass) throws NotCompliantMBeanException {
        if (null == mbeanClass) {
            throw new IllegalArgumentException("MBean class cannot be null");
        }
        if (DynamicMBean.class.isAssignableFrom(mbeanClass)) {
            return DYNAMIC_CONST;
        }
        Class<?>[] interfaces = mbeanClass.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            Class<?> anInterface = interfaces[i];
            if (!anInterface.getName().equals(mbeanClass.getName() + "MBean")) continue;
            return STANDARD_CONST;
        }
        Class superClass = mbeanClass.getSuperclass();
        if (superClass != null) {
            return MBeanCapability.of(superClass);
        }
        throw new NotCompliantMBeanException("Class does not expose a management interface: " + mbeanClass.getName());
    }
}

