/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.test;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import javax.jms.JMSException;
import javax.jms.Message;
import org.jboss.logging.Logger;
import org.jboss.mq.AcknowledgementRequest;
import org.jboss.mq.TransactionRequest;
import org.jboss.mq.server.JMSServerInterceptor;
import org.jboss.mq.server.jmx.InterceptorMBeanSupport;
import org.jboss.mq.test.LogInterceptorMBean;

public class LogInterceptor
extends InterceptorMBeanSupport
implements InvocationHandler,
LogInterceptorMBean {
    private static final Logger log = Logger.getLogger(LogInterceptor.class);
    private JMSServerInterceptor nextInterceptor;

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getName().equals("setNext")) {
            this.nextInterceptor = (JMSServerInterceptor)args[0];
            return null;
        }
        StringBuffer buffer = new StringBuffer("invoke ");
        this.describe(buffer, method, args);
        log.debug((Object)buffer);
        try {
            Object result = method.invoke((Object)this.nextInterceptor, args);
            buffer = new StringBuffer("return (");
            this.dump(buffer, result);
            buffer.append(") ");
            this.describe(buffer, method, args);
            log.debug((Object)buffer);
            return result;
        }
        catch (Throwable t) {
            if (t instanceof InvocationTargetException) {
                t = ((InvocationTargetException)t).getTargetException();
            }
            buffer = new StringBuffer("error ");
            this.describe(buffer, method, args);
            log.debug((Object)buffer, t);
            throw t;
        }
    }

    public String getInterceptorClass() throws Exception {
        return null;
    }

    public void setInterceptorClass(String c) throws Exception {
    }

    public JMSServerInterceptor getInterceptor() {
        Class[] interfaces = new Class[]{JMSServerInterceptor.class};
        return (JMSServerInterceptor)Proxy.newProxyInstance(LogInterceptor.class.getClassLoader(), interfaces, (InvocationHandler)this);
    }

    protected void describe(StringBuffer buffer, Method method, Object[] args) throws JMSException {
        buffer.append(method.getName());
        if (args == null) {
            buffer.append("()");
        } else {
            buffer.append("(");
            for (int i = 0; i < args.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                this.dump(buffer, args[i]);
            }
            buffer.append(")");
        }
    }

    protected void dump(StringBuffer buffer, Object obj) throws JMSException {
        if (obj instanceof Message) {
            buffer.append("Message:");
            buffer.append(((Message)obj).getJMSMessageID());
        } else if (obj instanceof TransactionRequest) {
            int i;
            TransactionRequest tr = (TransactionRequest)obj;
            buffer.append("Transaction Request xid=").append(tr.xid);
            buffer.append(" type=");
            switch (tr.requestType) {
                case 0: {
                    buffer.append("1Pcommit");
                    break;
                }
                case 1: {
                    buffer.append("2Pprepare");
                    break;
                }
                case 2: {
                    buffer.append("2Pcommit");
                    break;
                }
                case 3: {
                    buffer.append("2Prollback");
                    break;
                }
                default: {
                    buffer.append("UNKNOWN");
                }
            }
            if (tr.messages != null && tr.messages.length != 0) {
                buffer.append(" msgs=");
                ArrayList<String> msgs = new ArrayList<String>(tr.messages.length);
                for (i = 0; i < tr.messages.length; ++i) {
                    msgs.add(tr.messages[i].getJMSMessageID());
                }
                buffer.append(msgs);
            }
            if (tr.acks != null && tr.acks.length != 0) {
                buffer.append(" acks=");
                ArrayList<AcknowledgementRequest> acks = new ArrayList<AcknowledgementRequest>(tr.acks.length);
                for (i = 0; i < tr.acks.length; ++i) {
                    acks.add(tr.acks[i]);
                }
                buffer.append(acks);
            }
        } else {
            buffer.append(obj);
        }
    }
}

