/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.selectors;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Vector;
import org.jboss.mq.selectors.ISelectorParser;
import org.jboss.mq.selectors.Identifier;
import org.jboss.mq.selectors.Operator;
import org.jboss.mq.selectors.ParseException;
import org.jboss.mq.selectors.SelectorParserConstants;
import org.jboss.mq.selectors.SelectorParserTokenManager;
import org.jboss.mq.selectors.SimpleCharStream;
import org.jboss.mq.selectors.Token;

public class SelectorParser
implements ISelectorParser,
SelectorParserConstants {
    private static final String LOFFER_L = "l";
    private static final String UPPER_L = "L";
    private static final String OX = "0X";
    private static final String Ox = "0x";
    private static final String ZERRO = "0";
    private HashMap identifierMap;
    public SelectorParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    public boolean lookingAhead = false;
    private boolean jj_semLA;
    private int jj_gen;
    private final int[] jj_la1 = new int[26];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private final JJCalls[] jj_2_rtns = new JJCalls[8];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public SelectorParser() {
        this(new StringReader(""));
    }

    public Object parse(String selector, HashMap identifierMap) throws ParseException {
        return this.parse(selector, identifierMap, false);
    }

    public Object parse(String selector, HashMap identifierMap, boolean trace) throws ParseException {
        StringReader sr = new StringReader(selector);
        this.ReInit(sr);
        if (trace) {
            this.enable_tracing();
        } else {
            this.disable_tracing();
        }
        this.identifierMap = identifierMap;
        return this.expression();
    }

    private String stripQuotes(String image) {
        StringBuffer result = new StringBuffer(image.length() - 2);
        boolean escaped = false;
        for (int i = 1; i < image.length() - 1; ++i) {
            if (escaped) {
                if (image.charAt(i) != '\'') {
                    throw new RuntimeException("Invalid uses of quotes: " + image);
                }
                result.append('\'');
                escaped = false;
                continue;
            }
            if (image.charAt(i) == '\'') {
                escaped = true;
                continue;
            }
            result.append(image.charAt(i));
        }
        return result.toString();
    }

    public static Object doParse(String selector, HashMap identifierMap) throws ParseException {
        return SelectorParser.doParse(selector, identifierMap, false);
    }

    public static Object doParse(String selector, HashMap identifierMap, boolean trace) throws ParseException {
        SelectorParser parser = new SelectorParser();
        return parser.parse(selector, identifierMap, trace);
    }

    public final Object expression() throws ParseException {
        Object exp1 = null;
        exp1 = this.selectorExpression();
        this.jj_consume_token(0);
        return exp1;
    }

    public final Object selectorExpression() throws ParseException {
        Object exp1 = null;
        Object exp2 = null;
        exp1 = this.selectorTerm();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 11: {
                    break;
                }
                default: {
                    this.jj_la1[0] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(11);
            exp2 = this.selectorTerm();
            exp1 = new Operator(3, exp1, exp2);
        }
        return exp1;
    }

    public final Object selectorTerm() throws ParseException {
        Object exp1 = null;
        Object exp2 = null;
        exp1 = this.selectorFactor();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 9: {
                    break;
                }
                default: {
                    this.jj_la1[1] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(9);
            exp2 = this.selectorFactor();
            exp1 = new Operator(2, exp1, exp2);
        }
        return exp1;
    }

    public final Object selectorFactor() throws ParseException {
        Object exp1 = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 6: 
            case 7: 
            case 17: 
            case 23: 
            case 24: 
            case 31: 
            case 35: 
            case 37: 
            case 38: {
                exp1 = this.conditionalExpression();
                return exp1;
            }
            case 10: {
                this.jj_consume_token(10);
                exp1 = this.conditionalExpression();
                exp1 = new Operator(1, exp1);
                return exp1;
            }
        }
        this.jj_la1[2] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Object conditionalExpression() throws ParseException {
        Object exp1 = null;
        if (this.jj_2_1(3)) {
            this.jj_consume_token(17);
            exp1 = this.selectorExpression();
            this.jj_consume_token(18);
            return exp1;
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 6: 
            case 7: 
            case 17: 
            case 23: 
            case 24: 
            case 31: 
            case 35: 
            case 37: 
            case 38: {
                exp1 = this.comparisonExpression();
                return exp1;
            }
        }
        this.jj_la1[3] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Object comparisonExpression() throws ParseException {
        int op = -1;
        HashSet set = null;
        Object exp1 = null;
        Object exp2 = null;
        Object exp3 = null;
        Object id = null;
        Token not = null;
        if (this.jj_2_2(Integer.MAX_VALUE)) {
            exp1 = this.identifier();
            this.jj_consume_token(15);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 10: {
                    not = this.jj_consume_token(10);
                    break;
                }
                default: {
                    this.jj_la1[4] = this.jj_gen;
                }
            }
            this.jj_consume_token(8);
            int opCode = not == null ? 20 : 21;
            return new Operator(opCode, exp1);
        }
        if (this.jj_2_3(Integer.MAX_VALUE)) {
            id = this.identifier();
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 10: {
                    not = this.jj_consume_token(10);
                    break;
                }
                default: {
                    this.jj_la1[5] = this.jj_gen;
                }
            }
            this.jj_consume_token(14);
            this.jj_consume_token(17);
            set = new HashSet();
            this.stringList(set);
            this.jj_consume_token(18);
            if (not == null) {
                return new Operator(22, id, set);
            }
            return new Operator(23, id, set);
        }
        if (this.jj_2_4(Integer.MAX_VALUE)) {
            id = this.identifier();
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 10: {
                    not = this.jj_consume_token(10);
                    break;
                }
                default: {
                    this.jj_la1[6] = this.jj_gen;
                }
            }
            this.jj_consume_token(13);
            exp1 = this.patternExpression(id);
            if (not != null) {
                exp1 = new Operator(1, exp1);
            }
            return exp1;
        }
        if (this.jj_2_5(Integer.MAX_VALUE)) {
            exp1 = this.stringExpression();
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 30: {
                    this.jj_consume_token(30);
                    op = 0;
                    break;
                }
                case 29: {
                    this.jj_consume_token(29);
                    op = 8;
                    break;
                }
                default: {
                    this.jj_la1[7] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            exp2 = this.stringExpression();
            return new Operator(op, exp1, exp2);
        }
        if (this.jj_2_6(Integer.MAX_VALUE)) {
            exp1 = this.booleanExpression();
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 30: {
                    this.jj_consume_token(30);
                    op = 0;
                    break;
                }
                case 29: {
                    this.jj_consume_token(29);
                    op = 8;
                    break;
                }
                default: {
                    this.jj_la1[8] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            exp2 = this.booleanExpression();
            return new Operator(op, exp1, exp2);
        }
        if (this.jj_2_7(Integer.MAX_VALUE)) {
            exp1 = this.arithExpression();
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 30: {
                    this.jj_consume_token(30);
                    op = 0;
                    break;
                }
                case 29: {
                    this.jj_consume_token(29);
                    op = 8;
                    break;
                }
                case 25: {
                    this.jj_consume_token(25);
                    op = 4;
                    break;
                }
                case 26: {
                    this.jj_consume_token(26);
                    op = 5;
                    break;
                }
                case 27: {
                    this.jj_consume_token(27);
                    op = 6;
                    break;
                }
                case 28: {
                    this.jj_consume_token(28);
                    op = 7;
                    break;
                }
                default: {
                    this.jj_la1[9] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            exp2 = this.arithExpression();
            return new Operator(op, exp1, exp2);
        }
        if (this.jj_2_8(Integer.MAX_VALUE)) {
            exp1 = this.arithExpression();
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 10: {
                    not = this.jj_consume_token(10);
                    break;
                }
                default: {
                    this.jj_la1[10] = this.jj_gen;
                }
            }
            this.jj_consume_token(12);
            exp2 = this.arithExpression();
            this.jj_consume_token(9);
            exp3 = this.arithExpression();
            exp1 = new Operator(14, exp1, exp2, exp3);
            if (not != null) {
                exp1 = new Operator(1, exp1);
            }
            return exp1;
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 6: 
            case 7: 
            case 38: {
                exp1 = this.booleanExpression();
                return exp1;
            }
        }
        this.jj_la1[11] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final void stringList(HashSet set) throws ParseException {
        this.stringToken(set);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 20: {
                    break;
                }
                default: {
                    this.jj_la1[12] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(20);
            this.stringToken(set);
        }
    }

    public final void stringToken(HashSet set) throws ParseException {
        Token t = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 37: {
                t = this.jj_consume_token(37);
                break;
            }
            default: {
                this.jj_la1[13] = this.jj_gen;
            }
        }
        if (t != null) {
            set.add(this.stripQuotes(t.image));
        }
    }

    public final Object patternExpression(Object exp1) throws ParseException {
        Object exp2 = null;
        Token esc = null;
        Object escChar = null;
        exp2 = this.stringLiteral();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 16: {
                esc = this.jj_consume_token(16);
                escChar = this.stringLiteral();
                break;
            }
            default: {
                this.jj_la1[14] = this.jj_gen;
            }
        }
        Operator op = null;
        op = esc == null ? new Operator(16, exp1, exp2) : new Operator(18, exp1, exp2, escChar);
        return op;
    }

    public final Object arithExpression() throws ParseException {
        Object exp1;
        block8: {
            exp1 = null;
            Object exp2 = null;
            exp1 = this.arithTerm();
            block7: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 23: 
                    case 24: {
                        break;
                    }
                    default: {
                        this.jj_la1[15] = this.jj_gen;
                        break block8;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 24: {
                        this.jj_consume_token(24);
                        exp2 = this.arithTerm();
                        exp1 = new Operator(9, exp1, exp2);
                        continue block7;
                    }
                    case 23: {
                        this.jj_consume_token(23);
                        exp2 = this.arithTerm();
                        exp1 = new Operator(10, exp1, exp2);
                        continue block7;
                    }
                }
                break;
            }
            this.jj_la1[16] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return exp1;
    }

    public final Object arithTerm() throws ParseException {
        Object exp1;
        block8: {
            exp1 = null;
            Object exp2 = null;
            exp1 = this.arithFactor();
            block7: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 21: 
                    case 22: {
                        break;
                    }
                    default: {
                        this.jj_la1[17] = this.jj_gen;
                        break block8;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 21: {
                        this.jj_consume_token(21);
                        exp2 = this.arithFactor();
                        exp1 = new Operator(12, exp1, exp2);
                        continue block7;
                    }
                    case 22: {
                        this.jj_consume_token(22);
                        exp2 = this.arithFactor();
                        exp1 = new Operator(13, exp1, exp2);
                        continue block7;
                    }
                }
                break;
            }
            this.jj_la1[18] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return exp1;
    }

    public final Object arithFactor() throws ParseException {
        Object exp1 = null;
        boolean negate = false;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 23: 
            case 24: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 24: {
                        this.jj_consume_token(24);
                        break block0;
                    }
                    case 23: {
                        this.jj_consume_token(23);
                        negate = true;
                        break block0;
                    }
                }
                this.jj_la1[19] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[20] = this.jj_gen;
            }
        }
        exp1 = this.numericExpression();
        if (negate) {
            exp1 = new Operator(11, exp1);
        }
        return exp1;
    }

    public final Object booleanExpression() throws ParseException {
        Object exp1 = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 38: {
                exp1 = this.identifier();
                break;
            }
            case 6: 
            case 7: {
                exp1 = this.booleanLiteral();
                break;
            }
            default: {
                this.jj_la1[21] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return exp1;
    }

    public final Object booleanLiteral() throws ParseException {
        boolean isTrue = true;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 6: {
                this.jj_consume_token(6);
                break;
            }
            case 7: {
                this.jj_consume_token(7);
                isTrue = false;
                break;
            }
            default: {
                this.jj_la1[22] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (isTrue) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public final Object stringExpression() throws ParseException {
        Object exp1 = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 38: {
                exp1 = this.identifier();
                break;
            }
            case 37: {
                exp1 = this.stringLiteral();
                break;
            }
            default: {
                this.jj_la1[23] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return exp1;
    }

    public final Object stringLiteral() throws ParseException {
        Token string = null;
        string = this.jj_consume_token(37);
        return this.stripQuotes(string.image);
    }

    public final Object numericExpression() throws ParseException {
        Object exp1 = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 31: 
            case 35: {
                exp1 = this.numericLiteral();
                break;
            }
            case 17: {
                this.jj_consume_token(17);
                exp1 = this.arithExpression();
                this.jj_consume_token(18);
                break;
            }
            case 38: {
                exp1 = this.identifier();
                break;
            }
            default: {
                this.jj_la1[24] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return exp1;
    }

    public final Object numericLiteral() throws ParseException {
        Token literal = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 35: {
                literal = this.jj_consume_token(35);
                return new Double(literal.image);
            }
            case 31: {
                literal = this.jj_consume_token(31);
                String number = literal.image;
                if (number.endsWith(LOFFER_L) || number.endsWith(UPPER_L)) {
                    return new Long(number.substring(0, number.length() - 1));
                }
                if (number.startsWith(OX) || number.startsWith(Ox)) {
                    byte first;
                    if (number.length() == 18 && (first = Byte.decode(number.substring(0, 3)).byteValue()) >= 8) {
                        number = Ox + (first - 8) + number.substring(3);
                        return new Long(Long.decode(number) - Long.MAX_VALUE - 1L);
                    }
                } else if (number.startsWith(ZERRO) && number.length() == 23 && number.charAt(1) == '1') {
                    number = ZERRO + number.substring(2);
                    return new Long(Long.decode(number) - Long.MAX_VALUE - 1L);
                }
                return Long.decode(number);
            }
        }
        this.jj_la1[25] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Object identifier() throws ParseException {
        Token id = null;
        id = this.jj_consume_token(38);
        Identifier identifier = (Identifier)this.identifierMap.get(id.image);
        if (identifier == null) {
            identifier = new Identifier(id.image);
            this.identifierMap.put(id.image, identifier);
        }
        return identifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(2, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_4(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_4();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(3, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_5(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_5();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(4, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_6(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_6();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(5, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_7(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_7();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(6, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_8(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_8();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(7, xla);
        }
    }

    private final boolean jj_3R_42() {
        return this.jj_3R_49();
    }

    private final boolean jj_3R_35() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_42()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_43()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_20() {
        return this.jj_scan_token(26);
    }

    private final boolean jj_3R_48() {
        if (this.jj_scan_token(22)) {
            return true;
        }
        return this.jj_3R_38();
    }

    private final boolean jj_3R_19() {
        return this.jj_scan_token(25);
    }

    private final boolean jj_3R_18() {
        return this.jj_scan_token(29);
    }

    private final boolean jj_3R_17() {
        return this.jj_scan_token(30);
    }

    private final boolean jj_3R_57() {
        return this.jj_scan_token(35);
    }

    private final boolean jj_3R_55() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_57()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_58()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_47() {
        if (this.jj_scan_token(21)) {
            return true;
        }
        return this.jj_3R_38();
    }

    private final boolean jj_3R_39() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_47()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_48()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3_7() {
        if (this.jj_3R_16()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_17()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_18()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_19()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_20()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_21()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_22()) {
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return this.jj_3R_16();
    }

    private final boolean jj_3R_36() {
        return this.jj_scan_token(9);
    }

    private final boolean jj_3R_33() {
        Token xsp;
        if (this.jj_3R_38()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_39());
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3R_53() {
        return this.jj_3R_7();
    }

    private final boolean jj_3R_15() {
        return this.jj_scan_token(29);
    }

    private final boolean jj_3R_52() {
        if (this.jj_scan_token(17)) {
            return true;
        }
        if (this.jj_3R_16()) {
            return true;
        }
        return this.jj_scan_token(18);
    }

    private final boolean jj_3R_14() {
        return this.jj_scan_token(30);
    }

    private final boolean jj_3R_51() {
        return this.jj_3R_55();
    }

    private final boolean jj_3R_23() {
        Token xsp;
        if (this.jj_3R_35()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_36());
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3R_46() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_51()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_52()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_53()) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3_6() {
        if (this.jj_3R_13()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_14()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_15()) {
                return true;
            }
        }
        return this.jj_3R_13();
    }

    private final boolean jj_3R_12() {
        return this.jj_scan_token(29);
    }

    private final boolean jj_3R_41() {
        if (this.jj_scan_token(23)) {
            return true;
        }
        return this.jj_3R_33();
    }

    private final boolean jj_3R_11() {
        return this.jj_scan_token(30);
    }

    private final boolean jj_3R_40() {
        if (this.jj_scan_token(24)) {
            return true;
        }
        return this.jj_3R_33();
    }

    private final boolean jj_3R_34() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_40()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_41()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_28() {
        if (this.jj_scan_token(16)) {
            return true;
        }
        return this.jj_3R_27();
    }

    private final boolean jj_3R_24() {
        return this.jj_scan_token(11);
    }

    private final boolean jj_3_5() {
        if (this.jj_3R_10()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_11()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_12()) {
                return true;
            }
        }
        return this.jj_3R_10();
    }

    private final boolean jj_3R_27() {
        return this.jj_scan_token(37);
    }

    private final boolean jj_3R_16() {
        Token xsp;
        if (this.jj_3R_33()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_34());
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3R_6() {
        Token xsp;
        if (this.jj_3R_23()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_24());
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3_4() {
        if (this.jj_3R_7()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(10)) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_scan_token(13)) {
            return true;
        }
        return this.jj_3R_9();
    }

    private final boolean jj_3R_30() {
        return this.jj_3R_27();
    }

    private final boolean jj_3R_29() {
        return this.jj_3R_7();
    }

    private final boolean jj_3R_7() {
        return this.jj_scan_token(38);
    }

    private final boolean jj_3R_10() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_29()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_30()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3_3() {
        if (this.jj_3R_7()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(10)) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_scan_token(14)) {
            return true;
        }
        if (this.jj_scan_token(17)) {
            return true;
        }
        if (this.jj_3R_8()) {
            return true;
        }
        return this.jj_scan_token(18);
    }

    private final boolean jj_3R_44() {
        return this.jj_scan_token(7);
    }

    private final boolean jj_3R_9() {
        if (this.jj_3R_27()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_28()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private final boolean jj_3R_26() {
        if (this.jj_scan_token(20)) {
            return true;
        }
        return this.jj_3R_25();
    }

    private final boolean jj_3R_56() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_2()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_3()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_4()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3_5()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3_6()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3_7()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3_8()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3R_59()) {
                                        return true;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3_2() {
        if (this.jj_3R_7()) {
            return true;
        }
        if (this.jj_scan_token(15)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(10)) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(8);
    }

    private final boolean jj_3R_37() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(6)) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_44()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_25() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(37)) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private final boolean jj_3R_32() {
        return this.jj_3R_37();
    }

    private final boolean jj_3R_31() {
        return this.jj_3R_7();
    }

    private final boolean jj_3R_54() {
        return this.jj_3R_56();
    }

    private final boolean jj_3R_13() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_31()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_32()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_8() {
        Token xsp;
        if (this.jj_3R_25()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_26());
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3R_50() {
        return this.jj_scan_token(23);
    }

    private final boolean jj_3R_49() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_1()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_54()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3_1() {
        if (this.jj_scan_token(17)) {
            return true;
        }
        if (this.jj_3R_6()) {
            return true;
        }
        return this.jj_scan_token(18);
    }

    private final boolean jj_3R_59() {
        return this.jj_3R_13();
    }

    private final boolean jj_3R_45() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(24)) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_50()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_38() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_45()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_3R_46();
    }

    private final boolean jj_3_8() {
        if (this.jj_3R_16()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(10)) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_scan_token(12)) {
            return true;
        }
        if (this.jj_3R_16()) {
            return true;
        }
        if (this.jj_scan_token(9)) {
            return true;
        }
        return this.jj_3R_16();
    }

    private final boolean jj_3R_43() {
        if (this.jj_scan_token(10)) {
            return true;
        }
        return this.jj_3R_49();
    }

    private final boolean jj_3R_22() {
        return this.jj_scan_token(28);
    }

    private final boolean jj_3R_58() {
        return this.jj_scan_token(31);
    }

    private final boolean jj_3R_21() {
        return this.jj_scan_token(27);
    }

    private static void jj_la1_0() {
        jj_la1_0 = new int[]{2048, 512, -2122185536, -2122186560, 1024, 1024, 1024, 0x60000000, 0x60000000, 0x7E000000, 1024, 192, 0x100000, 0, 65536, 0x1800000, 0x1800000, 0x600000, 0x600000, 0x1800000, 0x1800000, 192, 192, 0, -2147352576, Integer.MIN_VALUE};
    }

    private static void jj_la1_1() {
        jj_la1_1 = new int[]{0, 0, 104, 104, 0, 0, 0, 0, 0, 0, 0, 64, 0, 32, 0, 0, 0, 0, 0, 0, 0, 64, 0, 96, 72, 8};
    }

    public SelectorParser(InputStream stream) {
        this(stream, null);
    }

    public SelectorParser(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new SelectorParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 26; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 26; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public SelectorParser(Reader stream) {
        int i;
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new SelectorParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 26; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(Reader stream) {
        int i;
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 26; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public SelectorParser(SelectorParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 26; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(SelectorParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 26; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private final Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private final boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.lookingAhead ? this.jj_scanpos : this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            boolean exists = false;
            Enumeration e = this.jj_expentries.elements();
            while (e.hasMoreElements()) {
                int[] oldentry = (int[])e.nextElement();
                if (oldentry.length != this.jj_expentry.length) continue;
                exists = true;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] == this.jj_expentry[i]) continue;
                    exists = false;
                    break;
                }
                if (!exists) continue;
                break;
            }
            if (!exists) {
                this.jj_expentries.addElement(this.jj_expentry);
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.removeAllElements();
        boolean[] la1tokens = new boolean[41];
        for (i = 0; i < 41; ++i) {
            la1tokens[i] = false;
        }
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 26; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) == 0) continue;
                la1tokens[32 + j] = true;
            }
        }
        for (i = 0; i < 41; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.addElement(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = (int[])this.jj_expentries.elementAt(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private final void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 8; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                            break;
                        }
                        case 2: {
                            this.jj_3_3();
                            break;
                        }
                        case 3: {
                            this.jj_3_4();
                            break;
                        }
                        case 4: {
                            this.jj_3_5();
                            break;
                        }
                        case 5: {
                            this.jj_3_6();
                            break;
                        }
                        case 6: {
                            this.jj_3_7();
                            break;
                        }
                        case 7: {
                            this.jj_3_8();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private final void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        SelectorParser.jj_la1_0();
        SelectorParser.jj_la1_1();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }
}

