/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.selectors;

import java.util.HashMap;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import org.jboss.logging.Logger;
import org.jboss.mq.SpyMessage;
import org.jboss.mq.selectors.ISelectorParser;
import org.jboss.mq.selectors.Identifier;
import org.jboss.mq.selectors.Operator;
import org.jboss.mq.selectors.SelectorParser;
import org.jboss.util.NestedRuntimeException;

public class Selector {
    static Logger cat = Logger.getLogger(Selector.class);
    private static Class parserClass = SelectorParser.class;
    public static final String USE_NUMERIC_DELIVERY_MODE = "org.jboss.mq.selectors.useNumericDeliveryMode";
    private static boolean useNumericDeliveryMode;
    public String selector;
    public HashMap identifiers;
    public Object result;
    private Class resultType;

    public static Class getSelectorParserClass() {
        return parserClass;
    }

    public static void setSelectorParserClass(Class parserClass) {
        Selector.parserClass = parserClass;
    }

    public Selector(String sel) throws InvalidSelectorException {
        this.selector = sel;
        this.identifiers = new HashMap();
        try {
            ISelectorParser bob = (ISelectorParser)parserClass.newInstance();
            this.result = bob.parse(sel, this.identifiers);
            this.resultType = this.result.getClass();
        }
        catch (Exception e) {
            InvalidSelectorException exception = new InvalidSelectorException("The selector is invalid: " + sel);
            exception.setLinkedException(e);
            throw exception;
        }
        catch (Error e) {
            InvalidSelectorException exception = new InvalidSelectorException("The selector is invalid: " + sel);
            exception.setLinkedException((Exception)new NestedRuntimeException((Throwable)e));
            throw exception;
        }
    }

    public synchronized boolean test(SpyMessage.Header mes) throws JMSException {
        try {
            Object res;
            for (Identifier id : this.identifiers.values()) {
                Object find = mes.jmsProperties.get(id.name);
                if (find == null) {
                    find = this.getHeaderFieldReferences(mes, id.name);
                }
                if (find == null) {
                    id.value = null;
                    continue;
                }
                Class<?> type = find.getClass();
                if (type.equals(Boolean.class) || type.equals(String.class) || type.equals(Double.class) || type.equals(Float.class) || type.equals(Integer.class) || type.equals(Long.class) || type.equals(Short.class) || type.equals(Byte.class)) {
                    id.value = find;
                    continue;
                }
                throw new Exception("Bad property '" + id.name + "' type: " + type);
            }
            if (this.resultType.equals(Identifier.class)) {
                res = ((Identifier)this.result).value;
            } else if (this.resultType.equals(Operator.class)) {
                Operator op = (Operator)this.result;
                res = op.apply();
            } else {
                res = this.result;
            }
            if (res == null) {
                return false;
            }
            if (!res.getClass().equals(Boolean.class)) {
                throw new Exception("Bad object type: " + res);
            }
            return (Boolean)res;
        }
        catch (Exception e) {
            cat.warn((Object)("Invalid selector: " + this.selector), (Throwable)e);
            return false;
        }
    }

    public boolean test(SpyMessage msg) throws JMSException {
        return this.test(msg.header);
    }

    private Object getHeaderFieldReferences(SpyMessage.Header header, String idName) throws JMSException {
        if (idName.equals("JMSDeliveryMode")) {
            if (useNumericDeliveryMode) {
                return new Integer(header.jmsDeliveryMode);
            }
            if (header.jmsDeliveryMode == 1) {
                return "NON_PERSISTENT";
            }
            return "PERSISTENT";
        }
        if (idName.equals("JMSPriority")) {
            return new Integer(header.jmsPriority);
        }
        if (idName.equals("JMSMessageID")) {
            return header.jmsMessageID;
        }
        if (idName.equals("JMSTimestamp")) {
            return new Long(header.jmsTimeStamp);
        }
        if (idName.equals("JMSCorrelationID")) {
            return header.jmsCorrelationIDString;
        }
        if (idName.equals("JMSType")) {
            return header.jmsType;
        }
        return null;
    }

    static {
        try {
            String property = System.getProperty(USE_NUMERIC_DELIVERY_MODE, "false");
            useNumericDeliveryMode = Boolean.valueOf(property);
        }
        catch (Exception ignored) {
            cat.trace((Object)"Cannot get property org.jboss.mq.selectors.useNumericDeliveryMode", (Throwable)ignored);
        }
    }
}

