/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.pm.jdbc2;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import javax.jms.JMSException;
import org.jboss.mq.SpyJMSException;
import org.jboss.mq.pm.jdbc2.PersistenceManager;

public class MSSQLPersistenceManager
extends PersistenceManager {
    protected String CREATE_IDX_MESSAGE_MESSAGEID_DESTINATION = "CREATE UNIQUE CLUSTERED INDEX JMS_MESSAGES_IDX ON JMS_MESSAGES (MESSAGEID, DESTINATION)";

    protected synchronized void createSchema() throws JMSException {
        PersistenceManager.TransactionManagerStrategy tms = new PersistenceManager.TransactionManagerStrategy();
        tms.startTX();
        Connection c = null;
        Statement stmt = null;
        boolean threadWasInterrupted = Thread.interrupted();
        try {
            this.innerCreateSchema(c, (PreparedStatement)stmt);
        }
        catch (SQLException e) {
            tms.setRollbackOnly();
            throw new SpyJMSException("Could not get a connection for jdbc2 table construction ", e);
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Throwable ignore) {}
            stmt = null;
            try {
                if (c != null) {
                    c.close();
                }
            }
            catch (Throwable ignore) {}
            c = null;
            tms.endTX();
            if (threadWasInterrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void innerCreateSchema(Connection c, PreparedStatement stmt) throws SQLException {
        if (this.createTables) {
            c = this.getConnection();
            boolean createdMessageTable = false;
            try {
                stmt = c.prepareStatement(this.CREATE_MESSAGE_TABLE);
                stmt.executeUpdate();
                createdMessageTable = true;
            }
            catch (SQLException e) {
                this.log.debug((Object)("Could not create table with SQL: " + this.CREATE_MESSAGE_TABLE), (Throwable)e);
            }
            finally {
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Throwable ignored) {
                    this.log.trace((Object)("Ignored: " + ignored));
                }
                stmt = null;
            }
            if (createdMessageTable) {
                try {
                    stmt = c.prepareStatement(this.CREATE_IDX_MESSAGE_TXOP_TXID);
                    stmt.executeUpdate();
                }
                catch (SQLException e) {
                    this.log.debug((Object)("Could not create index with SQL: " + this.CREATE_IDX_MESSAGE_TXOP_TXID), (Throwable)e);
                }
                finally {
                    try {
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                    catch (Throwable ignored) {
                        this.log.trace((Object)("Ignored: " + ignored));
                    }
                    stmt = null;
                }
                try {
                    stmt = c.prepareStatement(this.CREATE_IDX_MESSAGE_DESTINATION);
                    stmt.executeUpdate();
                }
                catch (SQLException e) {
                    this.log.debug((Object)("Could not create index with SQL: " + this.CREATE_IDX_MESSAGE_DESTINATION), (Throwable)e);
                }
                finally {
                    try {
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                    catch (Throwable ignored) {
                        this.log.trace((Object)("Ignored: " + ignored));
                    }
                    stmt = null;
                }
                try {
                    stmt = c.prepareStatement(this.CREATE_IDX_MESSAGE_MESSAGEID_DESTINATION);
                    stmt.executeUpdate();
                }
                catch (SQLException e) {
                    this.log.debug((Object)("Could not create index with SQL: " + this.CREATE_IDX_MESSAGE_MESSAGEID_DESTINATION), (Throwable)e);
                }
                finally {
                    try {
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                    catch (Throwable ignored) {
                        this.log.trace((Object)("Ignored: " + ignored));
                    }
                    stmt = null;
                }
            }
            try {
                stmt = c.prepareStatement(this.CREATE_TX_TABLE);
                stmt.executeUpdate();
            }
            catch (SQLException e) {
                this.log.debug((Object)("Could not create table with SQL: " + this.CREATE_TX_TABLE), (Throwable)e);
            }
            finally {
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Throwable ignored) {
                    this.log.trace((Object)("Ignored: " + ignored));
                }
                stmt = null;
            }
        }
    }

    public void startService() throws Exception {
        this.CREATE_IDX_MESSAGE_MESSAGEID_DESTINATION = this.sqlProperties.getProperty("CREATE_IDX_MESSAGE_MESSAGEID_DESTINATION", this.CREATE_IDX_MESSAGE_MESSAGEID_DESTINATION);
        super.startService();
    }
}

