/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.il.http;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import org.jboss.invocation.http.interfaces.Util;
import org.jboss.logging.Logger;
import org.jboss.mq.il.http.HTTPILRequest;
import org.jboss.mq.il.http.HTTPILResponse;

public class HTTPClient {
    private static final String CONTENT_TYPE = "application/x-java-serialized-object; class=org.jboss.mq.il.http.HTTPILRequest";
    private static Logger log = Logger.getLogger(HTTPClient.class);

    public static Object post(URL url, HTTPILRequest request) throws Exception {
        if (log.isTraceEnabled()) {
            log.trace((Object)("post(URL " + url.toString() + ", HTTPILRequest " + request.toString() + ")"));
        }
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        Util.configureHttpsHostVerifier((HttpURLConnection)connection);
        connection.setDoInput(true);
        connection.setDoOutput(true);
        connection.setUseCaches(false);
        connection.setRequestProperty("ContentType", CONTENT_TYPE);
        connection.setRequestMethod("POST");
        ObjectOutputStream outputStream = new ObjectOutputStream(connection.getOutputStream());
        outputStream.writeObject(request);
        outputStream.close();
        ObjectInputStream inputStream = new ObjectInputStream(connection.getInputStream());
        HTTPILResponse response = (HTTPILResponse)inputStream.readObject();
        inputStream.close();
        Object responseValue = response.getValue();
        if (responseValue instanceof Exception) {
            throw (Exception)responseValue;
        }
        return responseValue;
    }

    public static URL resolveServerUrl(String url) throws MalformedURLException {
        return Util.resolveURL((String)url);
    }
}

