/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.remoting.interceptor;

import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.ServerInvocationHandler;
import org.jboss.remoting.ident.Identity;
import org.jboss.remoting.network.NetworkRegistry;
import org.jboss.remoting.transport.Connector;
import org.jboss.test.remoting.interceptor.TestInvocationHandler;

public class ServerInterceptorTest {
    private InvokerLocator locator;

    public void setLocator(InvokerLocator locator) {
        this.locator = locator;
    }

    protected void setup() {
        try {
            System.setProperty("jboss.identity", Identity.createUniqueID());
            MBeanServer server = MBeanServerFactory.createMBeanServer();
            System.out.println("my identity is: " + Identity.get((MBeanServer)server));
            NetworkRegistry registry = NetworkRegistry.getInstance();
            server.registerMBean(registry, new ObjectName("remoting:type=NetworkRegistry"));
            Connector connector = new Connector();
            connector.setInvokerLocator(this.locator.getLocatorURI());
            ObjectName obj = new ObjectName("jboss.remoting:type=Connector,transport=" + this.locator.getProtocol());
            server.registerMBean(connector, obj);
            connector.start();
            connector.addInvocationHandler("test", (ServerInvocationHandler)new TestInvocationHandler());
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        try {
            int port = 8081;
            String transport = "socket";
            InvokerLocator locator = new InvokerLocator(transport + "://localhost:" + port + "/?" + "datatype" + "=" + "serializable");
            ServerInterceptorTest server = new ServerInterceptorTest();
            server.setLocator(locator);
            server.setup();
            while (true) {
                Thread.sleep(1000L);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    public void run() {
        this.setup();
    }
}

