/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.embedded.adapters;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import org.jboss.bootstrap.BaseServerConfig;
import org.jboss.embedded.DeploymentScanner;

public class ServerConfig
implements org.jboss.bootstrap.spi.ServerConfig {
    protected BaseServerConfig config;
    protected Properties props;

    public void start() throws Exception {
        this.props = new Properties(System.getProperties());
        String homeDir = System.getProperty("jboss.home.dir");
        if (homeDir == null) {
            String path = System.getProperty("jboss.embedded.bootstrap.resource.path");
            if (path == null) {
                throw new Exception("${jboss.embedded.bootstrap.resource.path} is null");
            }
            path = path + "conf/bootstrap-beans.xml";
            URL url = Thread.currentThread().getContextClassLoader().getResource(path);
            if (url.toString().startsWith("file:")) {
                this.initializeByFile(path);
            } else {
                this.initializeByUnknown();
            }
        } else {
            this.props.put("jboss.server.home.dir", homeDir);
        }
        this.config = new BaseServerConfig(this.props);
        this.config.initURLs();
        if (!this.config.getServerTempDir().exists()) {
            this.config.getServerTempDir().mkdir();
        }
        if (!this.config.getServerDataDir().exists()) {
            this.config.getServerDataDir().mkdir();
        }
    }

    protected void initializeByFile(String path) throws Exception {
        URL homeDirUrl = DeploymentScanner.getDirFromResource(Thread.currentThread().getContextClassLoader(), path + "/..");
        File homeDir = new File(homeDirUrl.toURI());
        this.props.put("jboss.home.dir", homeDir.toString());
        this.props.put("jboss.server.home.dir", homeDir.toString());
    }

    protected void initializeByUnknown() throws Exception {
        String temp = System.getProperty("java.io.tmpdir");
        File fp = new File(temp, "embedded-jboss");
        if (!fp.exists()) {
            fp.mkdir();
        }
        this.props.put("jboss.home.dir", fp.toString());
        this.props.put("jboss.server.home.dir", fp.toString());
    }

    public void initURLs() throws MalformedURLException {
        this.config.initURLs();
    }

    public File getHomeDir() {
        return this.config.getHomeDir();
    }

    public URL getBootstrapURL() {
        return this.config.getBootstrapURL();
    }

    public URL getHomeURL() {
        return this.config.getHomeURL();
    }

    public URL getLibraryURL() {
        return this.config.getLibraryURL();
    }

    public URL getPatchURL() {
        return this.config.getPatchURL();
    }

    public boolean isInstallLifeThread() {
        return this.config.isInstallLifeThread();
    }

    public String getServerName() {
        return this.config.getServerName();
    }

    public File getServerBaseDir() {
        return this.config.getServerBaseDir();
    }

    public File getServerHomeDir() {
        return this.config.getServerHomeDir();
    }

    public File getServerLogDir() {
        return this.config.getServerLogDir();
    }

    public File getServerTempDir() {
        return this.config.getServerTempDir();
    }

    public File getServerDataDir() {
        return this.config.getServerDataDir();
    }

    public File getServerNativeDir() {
        return this.config.getServerNativeDir();
    }

    public File getServerTempDeployDir() {
        return this.config.getServerTempDeployDir();
    }

    public URL getServerBaseURL() {
        return this.config.getServerBaseURL();
    }

    public URL getServerHomeURL() {
        return this.config.getServerHomeURL();
    }

    public URL getServerLibraryURL() {
        return this.config.getServerLibraryURL();
    }

    public URL getCommonBaseURL() {
        return this.config.getCommonBaseURL();
    }

    public URL getCommonLibraryURL() {
        return this.config.getCommonLibraryURL();
    }

    public URL getServerConfigURL() {
        return this.config.getServerConfigURL();
    }

    public boolean getPlatformMBeanServer() {
        return this.config.getPlatformMBeanServer();
    }

    public void setExitOnShutdown(boolean flag) {
        this.config.setExitOnShutdown(flag);
    }

    public boolean getExitOnShutdown() {
        return this.config.getExitOnShutdown();
    }

    public void setBlockingShutdown(boolean flag) {
        this.config.setBlockingShutdown(flag);
    }

    public boolean getBlockingShutdown() {
        return this.config.getBlockingShutdown();
    }

    public void setRequireJBossURLStreamHandlerFactory(boolean flag) {
        this.config.setRequireJBossURLStreamHandlerFactory(flag);
    }

    public boolean getRequireJBossURLStreamHandlerFactory() {
        return this.config.getRequireJBossURLStreamHandlerFactory();
    }

    public void setRootDeploymentFilename(String filename) {
        this.config.setRootDeploymentFilename(filename);
    }

    public String getRootDeploymentFilename() {
        return this.config.getRootDeploymentFilename();
    }

    public String getSpecificationVersion() {
        return this.config.getSpecificationVersion();
    }
}

