/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2009, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.as.jpa.builder;

import java.util.HashMap;
import java.util.Map;

import javax.persistence.EntityManagerFactory;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.validation.Validation;
import javax.validation.ValidatorFactory;

import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.jpa.builder.CEMFBuilder;
import org.jboss.jpa.impl.JPAConstants;

/**
 * Create a container managed entity manager factory with bean validation enabled.
 * 
 * @author <a href="mailto:cdewolf@redhat.com">Carlo de Wolf</a>
 * @version $Revision: $
 */
public class JPA2CEMFBuilder implements CEMFBuilder
{
   public EntityManagerFactory build(DeploymentUnit deploymentUnit, PersistenceUnitInfo persistenceUnitInfo)
   {
      try
      {
         Class<?> providerClass = Thread.currentThread().getContextClassLoader().loadClass(persistenceUnitInfo.getPersistenceProviderClassName());
         
         PersistenceProvider pp = (PersistenceProvider) providerClass.newInstance();
         Map<Object, Object> properties = new HashMap<Object, Object>(1);
         // FIXME: get it from JNDI or the deployer
         ValidatorFactory beanValidationFactory = Validation.buildDefaultValidatorFactory();
         properties.put(JPAConstants.BEAN_VALIDATION_FACTORY, beanValidationFactory);
         EntityManagerFactory cemf = pp.createContainerEntityManagerFactory(persistenceUnitInfo, properties);
         return cemf;
      }
      catch(ClassNotFoundException e)
      {
         throw new RuntimeException(e);
      }
      catch (InstantiationException e)
      {
         throw new RuntimeException(e);
      }
      catch (IllegalAccessException e)
      {
         throw new RuntimeException(e);
      }
   }
}
