/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.deployers;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.as.ejb3.naming.NamingComponentEjbEncFactory;
import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
import org.jboss.beans.metadata.plugins.AbstractConstructorMetaData;
import org.jboss.beans.metadata.plugins.AbstractDemandMetaData;
import org.jboss.beans.metadata.plugins.AbstractInjectionValueMetaData;
import org.jboss.beans.metadata.plugins.AbstractValueMetaData;
import org.jboss.beans.metadata.plugins.builder.BeanMetaDataBuilderFactory;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.ConstructorMetaData;
import org.jboss.beans.metadata.spi.DemandMetaData;
import org.jboss.beans.metadata.spi.DependencyMetaData;
import org.jboss.beans.metadata.spi.SupplyMetaData;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.beans.metadata.spi.builder.BeanMetaDataBuilder;
import org.jboss.ejb3.DependencyPolicy;
import org.jboss.ejb3.DeploymentUnit;
import org.jboss.ejb3.EJBContainer;
import org.jboss.ejb3.KernelAbstraction;
import org.jboss.ejb3.MCDependencyPolicy;
import org.jboss.ejb3.javaee.JavaEEApplication;
import org.jboss.ejb3.javaee.JavaEEModule;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.plugins.deployment.AbstractKernelDeployment;
import org.jboss.kernel.spi.deployment.KernelDeployment;
import org.jboss.kernel.spi.registry.KernelRegistryEntry;
import org.jboss.logging.Logger;
import org.jboss.reloaded.naming.spi.JavaEEComponent;

public class JBossASKernel
implements KernelAbstraction {
    private static Logger log = Logger.getLogger(JBossASKernel.class);
    private MBeanServer mbeanServer;
    private Kernel kernel;

    public JBossASKernel(Kernel kernel) {
        this(kernel, null);
    }

    public JBossASKernel(Kernel kernel, MBeanServer mbeanServer) {
        this.kernel = kernel;
        this.mbeanServer = mbeanServer;
    }

    public MBeanServer getMbeanServer() {
        return this.mbeanServer;
    }

    public void setMbeanServer(MBeanServer mbeanServer) {
        this.mbeanServer = mbeanServer;
    }

    public void install(String name, DependencyPolicy dependencies, DeploymentUnit unit, Object service) {
        KernelDeployment deployment = null;
        if (unit != null && (deployment = (KernelDeployment)unit.getAttachment(KernelDeployment.class.getName())) == null) {
            AbstractKernelDeployment akd = new AbstractKernelDeployment();
            akd.setBeanFactories(new ArrayList());
            deployment = akd;
            String kdname = unit.getShortName();
            deployment.setName(kdname);
            unit.addAttachment(KernelDeployment.class.getName(), (Object)deployment);
            log.info((Object)("Created KernelDeployment for: " + unit.getShortName()));
        }
        AbstractBeanMetaData bean = new AbstractBeanMetaData(name, service.getClass().getName());
        bean.setConstructor((ConstructorMetaData)new AlreadyInstantiated(service));
        MCDependencyPolicy policy = (MCDependencyPolicy)dependencies;
        bean.setDepends(policy.getDependencies());
        bean.setDemands(policy.getDemands());
        bean.setSupplies(policy.getSupplies());
        log.info((Object)("installing bean: " + name));
        log.info((Object)"  with dependencies:");
        Iterator i$ = policy.getDependencies().iterator();
        while (i$.hasNext()) {
            DependencyMetaData obj;
            Object msgObject = obj = (DependencyMetaData)i$.next();
            if (obj instanceof AbstractDemandMetaData) {
                msgObject = ((AbstractDemandMetaData)obj).getDemand();
            }
            log.info((Object)("\t" + msgObject));
        }
        log.info((Object)"  and demands:");
        for (DemandMetaData dmd : policy.getDemands()) {
            log.info((Object)("\t" + dmd.getDemand() + "; Required: " + dmd.getWhenRequired().getStateString()));
        }
        log.info((Object)"  and supplies:");
        for (SupplyMetaData smd : policy.getSupplies()) {
            log.info((Object)("\t" + smd.getSupply()));
        }
        if (service instanceof EJBContainer) {
            EJBContainer container = (EJBContainer)EJBContainer.class.cast(service);
            JavaEEModule module = container.getModule();
            String moduleName = JBossASKernel.stripSuffix(module.getName());
            JavaEEApplication app = module.getApplication();
            String appName = app != null ? JBossASKernel.stripSuffix(app.getName()) : null;
            String scopedBeanName = "application=" + (appName != null ? appName : moduleName) + ",module=" + moduleName + ",component=" + container.getEjbName();
            String encFactoryBeanName = "jboss.ejb3:" + scopedBeanName + ",service=EjbEncFactory";
            BeanMetaDataBuilder builder = BeanMetaDataBuilderFactory.createBuilder((String)encFactoryBeanName, (String)NamingComponentEjbEncFactory.class.getName());
            String componentBeanName = "jboss.naming:" + scopedBeanName;
            builder.addConstructorParameter(JavaEEComponent.class.getName(), (ValueMetaData)new AbstractInjectionValueMetaData((Object)componentBeanName));
            deployment.getBeanFactories().add(builder.getBeanMetaDataFactory());
            builder = BeanMetaDataBuilderFactory.createBuilder((AbstractBeanMetaData)bean);
            builder.addPropertyMetaData("ejbEncFactory", (ValueMetaData)new AbstractInjectionValueMetaData((Object)encFactoryBeanName));
        }
        if (unit != null) {
            deployment.getBeanFactories().add(bean);
            log.info((Object)("Added bean(" + name + ") to KernelDeployment of: " + unit.getShortName()));
        } else {
            try {
                try {
                    this.kernel.getController().uninstall((Object)name);
                }
                catch (IllegalStateException e) {
                    // empty catch block
                }
                log.info((Object)("Installing bean(" + name + ") into kernel"));
                this.kernel.getController().install((BeanMetaData)bean);
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        }
    }

    public void installMBean(ObjectName on, DependencyPolicy dependencies, Object service) {
        if (this.mbeanServer == null) {
            throw new RuntimeException("No MBeanServer has been injected");
        }
        try {
            this.mbeanServer.registerMBean(service, on);
            this.install(on.getCanonicalName(), dependencies, null, service);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static String stripSuffix(String s) {
        if (s == null || s.length() < 4) {
            return s;
        }
        return s.substring(0, s.length() - 4);
    }

    public void uninstall(String name) {
    }

    public Object getAttribute(ObjectName objectName, String attribute) throws Exception {
        String name = objectName.getCanonicalName();
        KernelRegistryEntry entry = this.kernel.getRegistry().getEntry((Object)name);
        if (entry != null) {
            Object target = entry.getTarget();
            Field field = target.getClass().getField(attribute);
            return field.get(target);
        }
        return null;
    }

    public Set getMBeans(ObjectName query) throws Exception {
        KernelRegistryEntry target = this.kernel.getRegistry().getEntry((Object)query);
        HashSet<KernelRegistryEntry> set = new HashSet<KernelRegistryEntry>();
        set.add(target);
        return set;
    }

    public void uninstallMBean(ObjectName on) {
        try {
            this.mbeanServer.unregisterMBean(on);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Object invoke(ObjectName objectName, String operationName, Object[] params, String[] signature) throws Exception {
        String name = objectName.getCanonicalName();
        KernelRegistryEntry entry = this.kernel.getRegistry().getEntry((Object)name);
        if (entry != null) {
            Object target = entry.getTarget();
            Class[] types = new Class[signature.length];
            for (int i = 0; i < signature.length; ++i) {
                types[i] = Thread.currentThread().getContextClassLoader().loadClass(signature[i]);
            }
            Method method = target.getClass().getMethod(operationName, types);
            return method.invoke(target, params);
        }
        return null;
    }

    private boolean hasOperation(MBeanInfo info, String operationName) {
        for (MBeanOperationInfo operationInfo : info.getOperations()) {
            if (!operationInfo.getName().equals(operationName) || !operationInfo.getReturnType().equals("void") || operationInfo.getSignature().length != 0) continue;
            return true;
        }
        return false;
    }

    public static class AlreadyInstantiated
    extends AbstractConstructorMetaData {
        private static final long serialVersionUID = 1L;
        private Object bean;

        public AlreadyInstantiated(Object bean) {
            this.bean = bean;
            this.setFactory((ValueMetaData)new AbstractValueMetaData((Object)new Factory()));
            this.setFactoryClass(Factory.class.getName());
            this.setFactoryMethod("create");
        }

        public class Factory {
            public Object create() {
                return AlreadyInstantiated.this.bean;
            }
        }
    }
}

