/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.client;

import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.rmi.server.RMIClassLoader;
import java.rmi.server.RMIClassLoaderSpi;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.beans.metadata.plugins.builder.BeanMetaDataBuilderFactory;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.BeanMetaDataFactory;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.beans.metadata.spi.builder.BeanMetaDataBuilder;
import org.jboss.classloader.plugins.system.DefaultClassLoaderSystem;
import org.jboss.classloader.spi.ClassLoaderDomain;
import org.jboss.classloader.spi.ClassLoaderSystem;
import org.jboss.classloader.spi.ParentPolicy;
import org.jboss.classloading.spi.dependency.ClassLoading;
import org.jboss.classloading.spi.vfs.dependency.VFSClassLoaderPolicyModule;
import org.jboss.classloading.spi.vfs.metadata.VFSClassLoaderFactory;
import org.jboss.classloading.spi.vfs.metadata.VFSClassLoaderFactory10;
import org.jboss.client.AppClientLauncher;
import org.jboss.dependency.spi.ControllerMode;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.ejb3.client.JndiDependencyValueMetaData;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.plugins.bootstrap.basic.BasicBootstrap;
import org.jboss.kernel.plugins.deployment.AbstractKernelDeployment;
import org.jboss.kernel.plugins.deployment.xml.BasicXMLDeployer;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.kernel.spi.deployment.KernelDeployment;
import org.jboss.logging.Logger;
import org.jboss.metadata.client.jboss.JBossClientMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientLauncher
implements AppClientLauncher {
    private static final Logger log = Logger.getLogger(ClientLauncher.class);
    private static final String VERSION = "$Revision: 81053 $";
    private static Throwable exception;
    private static Kernel kernel;
    private static BasicXMLDeployer deployer;
    private static Class<?> theMainClass;
    private static boolean remotingDelgatesToTCL;
    private static List<String> extraClassPath;

    public static Class<?> getTheMainClass() {
        return theMainClass;
    }

    public static JBossClientMetaData loadXML(String applicationClientName) throws NamingException {
        log.warn((Object)"FIXME: using an unsupported hack to get metadata");
        InitialContext ctx = new InitialContext();
        JBossClientMetaData metaData = (JBossClientMetaData)ctx.lookup(applicationClientName + "/metaData");
        return metaData;
    }

    public static List<String> loadClassPath(String applicationClientName) throws NamingException {
        InitialContext ctx = new InitialContext();
        List cp = (List)ctx.lookup(applicationClientName + "/classPathEntries");
        return cp;
    }

    public void launch(String clientClass, String clientName, String[] args) throws Throwable {
        ClientLauncher.launch(clientClass, clientName, args, null);
    }

    public static void launch(JBossClientMetaData xml, String mainClassName, String applicationClientName, String[] args) throws Throwable {
        List<String> cp = Collections.emptyList();
        ClientLauncher.launch(xml, cp, mainClassName, applicationClientName, args, null);
    }

    public static void launch(String mainClassName, String clientName, String[] args, Properties jndiEnv) throws Throwable {
        System.setProperty("java.rmi.server.RMIClassLoaderSpi", JBossRMIClassLoader.class.getName());
        JBossClientMetaData xml = null;
        List<String> cp = ClientLauncher.loadClassPath(clientName);
        ClientLauncher.launch(xml, cp, mainClassName, clientName, args, jndiEnv);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void launch(JBossClientMetaData xml, List<String> classPath, String mainClassName, String applicationClientName, String[] args, Properties jndiEnv) throws Throwable {
        log.info((Object)"ClientLauncher, version: $Revision: 81053 $");
        args = ClientLauncher.init(args);
        if (jndiEnv != null) {
            for (Object key : jndiEnv.keySet()) {
                String name = (String)key;
                System.setProperty(name, jndiEnv.getProperty(name));
            }
        }
        if (remotingDelgatesToTCL) {
            System.setProperty("org.jboss.remoting.classloadingParentFirstDelegation", "false");
        }
        ArrayList<BeanMetaDataFactory> beanFactories = new ArrayList<BeanMetaDataFactory>();
        ArrayList<BeanMetaData> beans = new ArrayList<BeanMetaData>();
        BeanMetaDataBuilder builder = BeanMetaDataBuilderFactory.createBuilder((String)"ClassLoaderSystem", (String)ClassLoaderSystem.class.getName());
        builder.setFactoryClass(ClientLauncher.class.getName());
        builder.setFactoryMethod("getClassLoaderSystem");
        BeanMetaData classLoaderSystemBMD = builder.getBeanMetaData();
        ClientLauncher.addBeanMetaData(beanFactories, beans, classLoaderSystemBMD);
        builder = BeanMetaDataBuilderFactory.createBuilder((String)"ClassLoading", (String)ClassLoading.class.getName());
        builder.addMethodInstallCallback("addModule", ControllerState.CONFIGURED);
        builder.addMethodUninstallCallback("removeModule", ControllerState.CONFIGURED);
        BeanMetaData classLoadingBMD = builder.getBeanMetaData();
        ClientLauncher.addBeanMetaData(beanFactories, beans, classLoadingBMD);
        try {
            Class<?> clientContainerClass;
            builder = BeanMetaDataBuilderFactory.createBuilder((String)"ClientContainer", (String)"org.jboss.ejb3.client.ClientContainer");
            VFSClassLoaderFactory factory = new VFSClassLoaderFactory("ClientLauncherClassPath");
            ArrayList<String> roots = new ArrayList<String>();
            log.info((Object)"Setting up classpath from: ");
            for (String path : classPath) {
                log.info((Object)path);
                roots.add(path);
            }
            for (String path : extraClassPath) {
                log.info((Object)path);
                roots.add(path);
            }
            log.info((Object)"End classpath");
            factory.setRoots(roots);
            beanFactories.add((BeanMetaDataFactory)factory);
            String classLoaderName = factory.getContextName();
            if (classLoaderName == null) {
                classLoaderName = factory.getName() + ":" + factory.getVersion();
            }
            String metaDataJndiName = applicationClientName + "/metaData";
            JndiDependencyValueMetaData xmlMD = new JndiDependencyValueMetaData(metaDataJndiName, jndiEnv, classLoaderName);
            builder.addConstructorParameter(JBossClientMetaData.class.getName(), (ValueMetaData)xmlMD);
            builder.addConstructorParameter(Class.class.getName(), mainClassName);
            builder.addConstructorParameter(String.class.getName(), applicationClientName);
            builder.addConstructorParameter(Properties.class.getName(), (Object)jndiEnv);
            ValueMetaData classLoader = builder.createInject((Object)classLoaderName);
            builder.setClassLoader(classLoader);
            BeanMetaData clientContainerMD = builder.getBeanMetaData();
            AbstractKernelDeployment deployment = new AbstractKernelDeployment();
            deployment.setName(factory.getName() + ":" + factory.getVersion());
            ClientLauncher.addBeanMetaData(beanFactories, beans, clientContainerMD);
            deployment.setBeanFactories(beanFactories);
            if (beans.size() > 0) {
                deployment.setBeans(beans);
            }
            ClientLauncher.deploy((KernelDeployment)deployment);
            ClientLauncher.validate();
            KernelController controller = kernel.getController();
            KernelControllerContext context = (KernelControllerContext)controller.getContext((Object)"ClientContainer", ControllerState.INSTALLED);
            if (context == null) {
                throw new Exception("ClientContainer bean was not created");
            }
            Object client = context.getTarget();
            KernelControllerContext cclContext = (KernelControllerContext)controller.getContext((Object)classLoaderName, ControllerState.INSTALLED);
            if (cclContext == null) {
                throw new Exception(classLoaderName + " bean was not created");
            }
            ClassLoader ccLoader = (ClassLoader)cclContext.getTarget();
            if (ccLoader == null) {
                throw new Exception(classLoaderName + " bean was not created");
            }
            if (client.getClass().getClassLoader() != ccLoader) {
                log.warn((Object)(client.getClass().getClassLoader() + " != " + ccLoader));
            }
            if ((clientContainerClass = ccLoader.loadClass("org.jboss.ejb3.client.ClientContainer")).getClassLoader() != ccLoader) {
                log.warn((Object)(clientContainerClass.getClassLoader() + " != " + ccLoader));
            }
            ClassLoader prevLoader = Thread.currentThread().getContextClassLoader();
            try {
                Class[] empty = new Class[]{};
                Method getMainClass = clientContainerClass.getDeclaredMethod("getMainClass", empty);
                theMainClass = (Class)getMainClass.invoke(client, null);
                Thread.currentThread().setContextClassLoader(ccLoader);
                Class[] parameterTypes = new Class[]{args.getClass()};
                Method invokeMain = clientContainerClass.getDeclaredMethod("invokeMain", parameterTypes);
                invokeMain.invoke(client, new Object[]{args});
            }
            finally {
                Thread.currentThread().setContextClassLoader(prevLoader);
            }
            ClientLauncher.undeploy((KernelDeployment)deployment);
        }
        catch (Throwable e) {
            exception = e;
            throw e;
        }
    }

    public static ClassLoaderSystem getClassLoaderSystem() {
        DefaultClassLoaderSystem system = new DefaultClassLoaderSystem();
        ClassLoaderDomain defaultDomain = system.getDefaultDomain();
        defaultDomain.setParentPolicy(ParentPolicy.AFTER);
        return system;
    }

    private static void addBeanMetaData(ArrayList<BeanMetaDataFactory> beanFactories, ArrayList<BeanMetaData> beans, BeanMetaData bmd) {
        if (bmd instanceof BeanMetaDataFactory) {
            BeanMetaDataFactory bmdf = (BeanMetaDataFactory)bmd;
            beanFactories.add(bmdf);
        } else {
            beans.add(bmd);
        }
    }

    private static String[] init(String[] args) throws Throwable {
        String[] newArgs = ClientLauncher.parseArgs(args);
        BasicBootstrap bootstrap = new BasicBootstrap();
        bootstrap.run();
        kernel = bootstrap.getKernel();
        deployer = ClientLauncher.createDeployer();
        return newArgs;
    }

    private static String[] parseArgs(String[] args) {
        ArrayList<String> tmp = new ArrayList<String>();
        for (int n = 0; n < args.length; ++n) {
            String arg = args[n];
            if (arg.equalsIgnoreCase("-remotingDelgatesToTCL")) {
                remotingDelgatesToTCL = Boolean.parseBoolean(args[++n]);
                continue;
            }
            if (arg.equalsIgnoreCase("-extraClassPath")) {
                String[] cp;
                String cparg = args[++n];
                for (String path : cp = cparg.split(",")) {
                    extraClassPath.add(path);
                }
                log.debug((Object)("Set extraClassPath to: " + extraClassPath));
                continue;
            }
            tmp.add(arg);
        }
        String[] newArgs = new String[tmp.size()];
        tmp.toArray(newArgs);
        return newArgs;
    }

    private static BasicXMLDeployer createDeployer() {
        return new BasicXMLDeployer(kernel, ControllerMode.AUTOMATIC);
    }

    private static void deploy(KernelDeployment deployment) throws Exception {
        log.debug((Object)("Deploying " + deployment));
        try {
            deployer.deploy(deployment);
            log.debug((Object)("Deployed " + deployment));
        }
        catch (Exception e) {
            throw e;
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable t) {
            throw new RuntimeException("Error deploying deployment: " + deployment, t);
        }
    }

    private static void undeploy(KernelDeployment deployment) {
        log.debug((Object)("Undeploying " + deployment.getName()));
        try {
            deployer.undeploy(deployment);
            log.trace((Object)("Undeployed " + deployment.getName()));
        }
        catch (Throwable t) {
            log.warn((Object)("Error during undeployment: " + deployment.getName()), t);
        }
    }

    private static void validate() throws Exception {
        try {
            deployer.validate();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public static void main(String[] args) {
        String[] roots = new String[]{"vfszip:/home/svn/JBossHead/jboss-head/build/output/jboss-5.0.0.CR2/server/cts/tmp/jsr88/assembly_classpath_appclient.ear/assembly_classpath_appclient_client.jar", "vfszip:/Users/svn/JBossHead/jboss-head/build/output/jboss-5.0.0.CR2/server/cts/tmp/jsr88/assembly_classpath_appclient.ear/libs/direct_classpath_util.jar", "vfszip:/Users/svn/JBossHead/jboss-head/build/output/jboss-5.0.0.CR2/server/cts/tmp/jsr88/assembly_classpath_appclient.ear/libs/indirect_classpath_util.jar"};
        VFSClassLoaderFactory10 factory = new VFSClassLoaderFactory10();
        factory.setRoots(Arrays.asList(roots));
        VFSClassLoaderPolicyModule module = new VFSClassLoaderPolicyModule((VFSClassLoaderFactory)factory, "AppClientLoaderModule");
    }

    static {
        remotingDelgatesToTCL = true;
        extraClassPath = new ArrayList<String>();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class JBossRMIClassLoader
    extends RMIClassLoaderSpi {
        RMIClassLoaderSpi delegate = RMIClassLoader.getDefaultProviderInstance();

        @Override
        public Class<?> loadProxyClass(String codebase, String[] interfaces, ClassLoader ignored) throws MalformedURLException, ClassNotFoundException {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            return this.delegate.loadProxyClass(codebase, interfaces, loader);
        }

        @Override
        public Class<?> loadClass(String codebase, String name, ClassLoader ignored) throws MalformedURLException, ClassNotFoundException {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            return this.delegate.loadClass(codebase, name, loader);
        }

        @Override
        public ClassLoader getClassLoader(String codebase) throws MalformedURLException {
            return this.delegate.getClassLoader(codebase);
        }

        @Override
        public String getClassAnnotation(Class<?> cl) {
            String annotation = null;
            try {
                annotation = this.delegate.getClassAnnotation(cl);
            }
            catch (Throwable t) {
                annotation = System.getProperty("java.rmi.server.codebase");
            }
            return annotation;
        }
    }
}

